/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.neoforge.compat.curios;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosContainerAdapter
implements Container {
    private final IDynamicStackHandler stackHandler;
    private final int slotIndex;

    public CuriosContainerAdapter(IDynamicStackHandler stackHandler, int slotIndex) {
        this.stackHandler = stackHandler;
        this.slotIndex = slotIndex;
    }

    public int getContainerSize() {
        return this.stackHandler.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.stackHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return this.stackHandler.getStackInSlot(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.stackHandler.extractItem(index, count, false);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.stackHandler.extractItem(index, this.stackHandler.getStackInSlot(index).getCount(), false);
    }

    public void setItem(int index, ItemStack stack) {
        this.stackHandler.setStackInSlot(index, stack);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.stackHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public int getBackpackSlotIndex() {
        return this.slotIndex;
    }
}

