/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.api;

import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.api.BackpackCondition;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackPackSlot
extends Slot {
    private final AbstractContainerMenu menu;
    private final int columnIndex;
    private final Inventory inventory;

    public BackPackSlot(AbstractContainerMenu menu, Inventory inventory, int index, int columnIndex, int j, int k) {
        super((Container)inventory, index, j, k);
        this.menu = menu;
        this.columnIndex = columnIndex;
        this.inventory = inventory;
    }

    public boolean isActive() {
        ItemStack backpackStack = BackpackHelper.getEquipped(this.inventory.player);
        Item item = backpackStack.getItem();
        if (!(item instanceof BackpackItem)) {
            return false;
        }
        BackpackItem backpackItem = (BackpackItem)item;
        int columns = backpackItem.getBackpackType().getColumns();
        if (this.columnIndex >= columns) {
            return false;
        }
        return ((BackpackCondition)this.menu).shouldRenderBackpack();
    }

    public boolean mayPlace(ItemStack stack) {
        BackpackItem backpackItem;
        int columns;
        ItemStack backpackStack = BackpackHelper.getEquipped(this.inventory.player);
        boolean canPlace = !(stack.getItem() instanceof BackpackItem) && backpackStack.getItem() instanceof BackpackItem && super.mayPlace(stack);
        Item item = backpackStack.getItem();
        if (item instanceof BackpackItem && this.columnIndex >= (columns = (backpackItem = (BackpackItem)item).getBackpackType().getColumns())) {
            return false;
        }
        return canPlace;
    }
}

