/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.api;

import com.mojang.datafixers.util.Pair;
import com.yyz.yyzsbackpack.BackpackManager;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EquipPackSlot
extends Slot {
    private final Container inventory;

    public EquipPackSlot(Container container, int i, int j, int k) {
        super(container, i, j, k);
        this.inventory = container;
    }

    public boolean mayPlace(ItemStack stack) {
        return stack.getItem() instanceof BackpackItem;
    }

    public void onTake(Player player, ItemStack backpackStack) {
        if (backpackStack.getItem() instanceof BackpackItem) {
            BackpackManager.saveBackpackContents(this.inventory, backpackStack);
        }
        super.onTake(player, backpackStack);
    }

    public void setByPlayer(ItemStack newBackpackStack) {
        ItemStack oldBackpackStack = this.getItem();
        if (!oldBackpackStack.isEmpty() && oldBackpackStack.getItem() instanceof BackpackItem) {
            BackpackManager.saveBackpackContents(this.inventory, oldBackpackStack);
        }
        super.setByPlayer(newBackpackStack);
        if (!newBackpackStack.isEmpty() && newBackpackStack.getItem() instanceof BackpackItem) {
            BackpackManager.restoreBackpackContents(this.inventory, newBackpackStack);
        }
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)BackpackManager.BACKSLOT_TEXTURE);
    }
}

