/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.compat.jei;

import com.yyz.yyzsbackpack.util.BackpackHelper;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_5250;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class BackpackPlayerRecipeTransferHandler
implements IRecipeTransferHandler<class_1723, class_8786<class_3955>> {
    private static final IntSet PLAYER_INV_INDEXES = IntArraySet.of((int[])new int[]{0, 1, 3, 4});
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferHandler<class_1723, class_8786<class_3955>> handler;

    public BackpackPlayerRecipeTransferHandler(IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        IRecipeTransferInfo basicRecipeTransferInfo = handlerHelper.createBasicRecipeTransferInfo(class_1723.class, (class_3917)null, RecipeTypes.CRAFTING, 1, 4, 9, 36 + BackpackHelper.getMaxBackpackSize());
        this.handler = handlerHelper.createUnregisteredRecipeTransferHandler(basicRecipeTransferInfo);
    }

    public Class<? extends class_1723> getContainerClass() {
        return this.handler.getContainerClass();
    }

    public Optional<class_3917<class_1723>> getMenuType() {
        return this.handler.getMenuType();
    }

    public RecipeType<class_8786<class_3955>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(class_1723 container, class_8786<class_3955> recipe, IRecipeSlotsView recipeSlotsView, class_1657 player, boolean maxTransfer, boolean doTransfer) {
        if (!this.handlerHelper.recipeTransferHasServerSupport()) {
            class_5250 tooltipMessage = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip((class_2561)tooltipMessage);
        }
        List slotViews = recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT);
        if (!BackpackPlayerRecipeTransferHandler.validateIngredientsOutsidePlayerGridAreEmpty(slotViews)) {
            class_5250 tooltipMessage = class_2561.method_43471((String)"jei.tooltip.error.recipe.transfer.too.large.player.inventory");
            return this.handlerHelper.createUserErrorWithTooltip((class_2561)tooltipMessage);
        }
        List<IRecipeSlotView> filteredSlotViews = BackpackPlayerRecipeTransferHandler.filterSlots(slotViews);
        IRecipeSlotsView filteredRecipeSlots = this.handlerHelper.createRecipeSlotsView(filteredSlotViews);
        return this.handler.transferRecipe((class_1703)container, recipe, filteredRecipeSlots, player, maxTransfer, doTransfer);
    }

    private static boolean validateIngredientsOutsidePlayerGridAreEmpty(List<IRecipeSlotView> slotViews) {
        int bound = slotViews.size();
        for (int i = 0; i < bound; ++i) {
            IRecipeSlotView slotView;
            if (PLAYER_INV_INDEXES.contains(i) || (slotView = slotViews.get(i)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static List<IRecipeSlotView> filterSlots(List<IRecipeSlotView> slotViews) {
        IntStream var10000 = PLAYER_INV_INDEXES.intStream();
        Objects.requireNonNull(slotViews);
        return var10000.mapToObj(slotViews::get).toList();
    }
}

