/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.util;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackEquipSlot;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.base.BackpackStorageSlot;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_481;

public class SlotManager {
    public static void repositionBackpackInventorySlots(class_1703 menu, class_1661 inventory, int backpackSlotStartIndex, int baseHeight, int xOffset, int yOffset) {
        class_1799 stack = BackpackPlatform.getEquipped(inventory.field_7546);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)class_17922;
            int columns = backpackItem.getBackpackType().getColumns();
            int rows = backpackItem.getBackpackType().getRows();
            for (int row = 0; row < rows; ++row) {
                for (int column = 0; column < columns; ++column) {
                    class_1735 slot;
                    int slotIndex = backpackSlotStartIndex + row * columns + column;
                    if (slotIndex >= menu.field_7761.size() || !((slot = (class_1735)menu.field_7761.get(slotIndex)) instanceof BackpackStorageSlot)) continue;
                    slot.field_7873 = -25 - (columns - 1) * 18 + column * 18 + xOffset;
                    slot.field_7872 = (baseHeight - 166) / 2 + 3 + row * 18 + yOffset;
                }
            }
        }
    }

    public static void repositionBackpackEquipSlot(class_1703 menu, int baseHeight, int xOffset, int yOffset) {
        for (class_1735 slot : menu.field_7761) {
            if (!(slot instanceof BackpackEquipSlot)) continue;
            slot.field_7873 = 77 + xOffset;
            slot.field_7872 = (baseHeight - 166) / 2 + 8 + 36 + yOffset;
            break;
        }
    }

    public static void addBackpackInventorySlots(class_1703 screenHandler, class_1661 inventory) {
        for (int count = 0; count < BackpackHelper.getMaxBackpackSize(); ++count) {
            screenHandler.method_7621((class_1735)new BackpackStorageSlot(screenHandler, inventory, 36 + count, 0, 0));
        }
    }

    public static void addBackpackEquipSlot(class_1703 screenHandler, class_1661 inventory) {
        if (BackpackHelper.isTrinketModLoaded() && !Backpack.getConfig().use_dedicated_slot) {
            return;
        }
        screenHandler.method_7621((class_1735)new BackpackEquipSlot((class_1263)inventory, 36 + BackpackHelper.getMaxBackpackSize(), 77, 44));
    }

    public static void updateBackpackSlotPositions(class_437 screen, class_1703 menu, class_1661 inventory, int imageHeight) {
        if (screen instanceof class_481) {
            return;
        }
        if (menu instanceof BackpackMenu) {
            int baseHeight = imageHeight;
            int backpackSlotStartIndex = -1;
            for (int i = 0; i < menu.field_7761.size(); ++i) {
                if (!(menu.field_7761.get(i) instanceof BackpackStorageSlot)) continue;
                backpackSlotStartIndex = i;
                break;
            }
            if (backpackSlotStartIndex == -1) {
                return;
            }
            int xOffset = ((BackpackMenu)menu).getBackpackGuiX();
            int yOffset = ((BackpackMenu)menu).getBackpackGuiY();
            int equipXOffset = ((BackpackMenu)menu).getBackpackEquipSlotX();
            int equipYOffset = ((BackpackMenu)menu).getBackpackEquipSlotY();
            SlotManager.repositionBackpackInventorySlots(menu, inventory, backpackSlotStartIndex, baseHeight, xOffset, yOffset);
            SlotManager.repositionBackpackEquipSlot(menu, baseHeight, equipXOffset, equipYOffset);
        }
    }
}

