/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.meerkat.mob.meerkat;

import aquariusplayz.animalgarden.meerkat.setup.Registrations;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.event.ForgeEventFactory;

public class ModMob
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> VARIANT_TYPE = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState winkAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    public final AnimationState idleHeadAnimationState = new AnimationState();
    public final AnimationState idleLeftEarAnimationState = new AnimationState();
    public final AnimationState idleRightEarAnimationState = new AnimationState();
    public final AnimationState idleTailAnimationState = new AnimationState();
    public final AnimationState idleHead2AnimationState = new AnimationState();
    public final AnimationState idleHead3AnimationState = new AnimationState();
    public int danceType = new Random().nextInt(2);

    public ModMob(EntityType<? extends ModMob> p_29362_, Level p_29363_) {
        super(p_29362_, p_29363_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ModMobPanicGoal(1.0));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, p_332367_ -> this.isFood((ItemStack)p_332367_), false));
        this.goalSelector.addGoal(4, new MobAvoidEntityGoal<Player>(this, Player.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(5, new MobAvoidEntityGoal<Monster>(this, Monster.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (arg_0, arg_1) -> ((ModMob)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void tick() {
        super.tick();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.275f).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.TEMPT_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().random.nextInt(75) == 0 && this.animationEnded(this.winkAnimationState, 0.5f)) {
            this.winkAnimationState.start(this.tickCount);
        }
        if (this.isInSittingPose() && !this.sitAnimationState.isStarted()) {
            this.sitAnimationState.start(this.tickCount);
        } else if (!this.isInSittingPose() && this.sitAnimationState.isStarted()) {
            this.sitAnimationState.stop();
        }
        if (this.level().isClientSide()) {
            if (this.walkAnimation.isMoving()) {
                this.idleAnimationState.stop();
                this.idleLeftEarAnimationState.stop();
                this.idleRightEarAnimationState.stop();
                this.idleTailAnimationState.stop();
                this.idleHeadAnimationState.stop();
                this.idleHead2AnimationState.stop();
                this.idleHead3AnimationState.stop();
            } else if (!this.idleAnimationState.isStarted()) {
                this.idleAnimationState.start(this.tickCount);
            } else if (this.idleAnimationState.isStarted() && !this.walkAnimation.isMoving()) {
                if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.idleLeftEarAnimationState, 3.0f)) {
                    this.idleLeftEarAnimationState.start(this.tickCount);
                }
                if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.idleRightEarAnimationState, 3.0f)) {
                    this.idleRightEarAnimationState.start(this.tickCount);
                }
                if (this.level().random.nextInt(100) == 0 && this.animationEnded(this.idleTailAnimationState, 9.0f)) {
                    this.idleTailAnimationState.start(this.tickCount);
                }
                int a = this.level().random.nextInt(3);
                int b = this.level().random.nextInt(50);
                if (a == 0) {
                    if (b == 0 && this.animationEnded(this.idleHeadAnimationState, 5.5f) && this.animationEnded(this.idleHead2AnimationState, 5.5f) && this.animationEnded(this.idleHead3AnimationState, 3.5f)) {
                        this.idleHeadAnimationState.start(this.tickCount);
                    }
                } else if (a == 1) {
                    if (b == 0 && this.animationEnded(this.idleHeadAnimationState, 5.5f) && this.animationEnded(this.idleHead2AnimationState, 5.5f) && this.animationEnded(this.idleHead3AnimationState, 3.5f)) {
                        this.idleHead2AnimationState.start(this.tickCount);
                    }
                } else if (b == 0 && this.animationEnded(this.idleHeadAnimationState, 5.5f) && this.animationEnded(this.idleHead2AnimationState, 5.5f) && this.animationEnded(this.idleHead3AnimationState, 3.5f)) {
                    this.idleHead3AnimationState.start(this.tickCount);
                }
            }
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public boolean animationEnded(AnimationState state, float animLength) {
        return (float)state.getTimeInMillis((float)this.tickCount) > animLength * 1000.0f;
    }

    public boolean wantsToAttack(LivingEntity p_30389_, LivingEntity p_30390_) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (p_30389_ instanceof Creeper || p_30389_ instanceof Ghast || p_30389_ instanceof ArmorStand) {
            return false;
        }
        if (p_30389_ instanceof ModMob) {
            ModMob mob = (ModMob)p_30389_;
            return !mob.isTame() || mob.getOwner() != p_30390_;
        }
        if (p_30389_ instanceof Player) {
            Player player1;
            Player player = (Player)p_30389_;
            if (p_30390_ instanceof Player && !(player1 = (Player)p_30390_).canHarmPlayer(player)) {
                return false;
            }
        }
        if (p_30389_ instanceof AbstractHorse && (abstracthorse = (AbstractHorse)p_30389_).isTamed()) {
            return false;
        }
        return !(p_30389_ instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)p_30389_).isTame();
    }

    public void tryToTame(Player p_336244_) {
        if (this.random.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_336244_)) {
            this.tame(p_336244_);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        Item item = itemstack.getItem();
        if (this.isTame()) {
            if (this.isFood(itemstack)) {
                this.usePlayerItem(p_30412_, p_30413_, itemstack);
                FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                this.heal(2.0f * f);
                return super.mobInteract(p_30412_, p_30413_);
            }
            InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
            if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                this.setOrderedToSit(!this.isOrderedToSit());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS.withoutItem();
            }
            return interactionresult;
        }
        if (!this.level().isClientSide() && this.isFood(itemstack)) {
            itemstack.consume(1, (LivingEntity)p_30412_);
            this.tryToTame(p_30412_);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    public boolean isFood(ItemStack p_30440_) {
        FoodProperties foodproperties = (FoodProperties)p_30440_.get(DataComponents.FOOD);
        return foodproperties != null && foodproperties.nutrition() > 0;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)this.getType().create((Level)p_148993_, EntitySpawnReason.BREEDING);
        if (this.isTame()) {
            mob.setOwnerReference(this.getOwnerReference());
            mob.setTame(true, true);
            mob.setVariantType(this.getVariantType());
        }
        return mob;
    }

    @Nullable
    public SoundEvent getAmbientSound() {
        return (SoundEvent)Registrations.IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_29437_) {
        return (SoundEvent)Registrations.HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)Registrations.HURT.get();
    }

    protected float getSoundVolume() {
        return 0.25f;
    }

    public float getVoicePitch() {
        return ModMob.getPitch(this.random);
    }

    public static float getPitch(RandomSource p_218237_) {
        return (p_218237_.nextFloat() - p_218237_.nextFloat()) * 0.2f + 2.0f;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public boolean isPushable() {
        return true;
    }

    protected void doPush(Entity p_29367_) {
        if (!(p_29367_ instanceof Player)) {
            super.doPush(p_29367_);
        }
    }

    public boolean hurtServer(ServerLevel p_368472_, DamageSource p_364880_, float p_366649_) {
        if (this.isInvulnerableTo(p_368472_, p_364880_)) {
            return false;
        }
        this.setOrderedToSit(false);
        return super.hurtServer(p_368472_, p_364880_, p_366649_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
        p_335317_.define(VARIANT_TYPE, (Object)0);
        p_335317_.define(SIZE, (Object)0);
    }

    public int getVariantType() {
        return (Integer)this.entityData.get(VARIANT_TYPE);
    }

    private void setVariantType(int p_30398_) {
        this.entityData.set(VARIANT_TYPE, (Object)p_30398_);
    }

    public int getSizeType() {
        return (Integer)this.entityData.get(SIZE);
    }

    private void setSizeType(int p_30398_) {
        this.entityData.set(SIZE, (Object)p_30398_);
    }

    public void addAdditionalSaveData(ValueOutput p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        this.addPersistentAngerSaveData(p_29422_);
        p_29422_.putInt("VariantType", this.getVariantType());
        p_29422_.putInt("SizeType", this.getSizeType());
    }

    public void readAdditionalSaveData(ValueInput p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.readPersistentAngerSaveData(this.level(), p_29402_);
        this.setVariantType(p_29402_.getIntOr("VariantType", 0));
        this.setSizeType(p_29402_.getIntOr("SizeType", 0));
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    protected boolean canFlyToOwner() {
        return false;
    }

    public class ModMobPanicGoal
    extends PanicGoal {
        public ModMobPanicGoal(double p_344198_, TagKey<DamageType> p_343270_) {
            super((PathfinderMob)ModMob.this, p_344198_, p_343270_);
        }

        public ModMobPanicGoal(double p_344164_) {
            super((PathfinderMob)ModMob.this, p_344164_);
        }

        public boolean canUse() {
            if (ModMob.this.isAggressive()) {
                return false;
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            if (ModMob.this.isAggressive()) {
                return false;
            }
            return super.canContinueToUse();
        }

        public void tick() {
            if (!ModMob.this.unableToMoveToOwner() && ModMob.this.shouldTryTeleportToOwner()) {
                ModMob.this.tryToTeleportToOwner();
            }
            super.tick();
        }
    }

    public class MobAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final ModMob thismob;

        public MobAvoidEntityGoal(ModMob p_30454_, Class<T> p_30455_, float p_30456_, double p_30457_, double p_30458_) {
            super((PathfinderMob)p_30454_, p_30455_, p_30456_, p_30457_, p_30458_);
            this.thismob = p_30454_;
        }

        public boolean canUse() {
            return super.canUse() && (this.toAvoid instanceof Monster || this.toAvoid instanceof Player) ? !this.thismob.isTame() : false;
        }

        public void start() {
            ModMob.this.setTarget(null);
            super.start();
        }

        public void tick() {
            ModMob.this.setTarget(null);
            super.tick();
        }
    }
}

