/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.addons.proxy;

import dev.httpmarco.polocloud.addons.api.ConfigFactory;
import dev.httpmarco.polocloud.addons.api.LegacyFormatter;
import dev.httpmarco.polocloud.addons.api.MessageFormatter;
import dev.httpmarco.polocloud.addons.api.MiniMessageFormatter;
import dev.httpmarco.polocloud.addons.proxy.ProxyConfigAccessor;
import dev.httpmarco.polocloud.addons.proxy.ProxyConfiguration;
import dev.httpmarco.polocloud.sdk.java.Polocloud;
import dev.httpmarco.polocloud.shared.service.Service;
import dev.httpmarco.polocloud.shared.service.SharedServiceProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Ldev/httpmarco/polocloud/addons/proxy/ProxyAddon;", "", "dataFolder", "Ljava/io/File;", "minimessage", "", "<init>", "(Ljava/io/File;Z)V", "configFactory", "Ldev/httpmarco/polocloud/addons/api/ConfigFactory;", "Ldev/httpmarco/polocloud/addons/proxy/ProxyConfiguration;", "formatter", "Ldev/httpmarco/polocloud/addons/api/MessageFormatter;", "config", "Ldev/httpmarco/polocloud/addons/proxy/ProxyConfigAccessor;", "getConfig", "()Ldev/httpmarco/polocloud/addons/proxy/ProxyConfigAccessor;", "poloService", "Ldev/httpmarco/polocloud/shared/service/Service;", "getPoloService", "()Ldev/httpmarco/polocloud/shared/service/Service;", "setPoloService", "(Ldev/httpmarco/polocloud/shared/service/Service;)V", "applyFormatting", "", "proxy"})
public final class ProxyAddon {
    @NotNull
    private final ConfigFactory<ProxyConfiguration> configFactory;
    @NotNull
    private final MessageFormatter formatter;
    @NotNull
    private final ProxyConfigAccessor config;
    @NotNull
    private Service poloService;

    public ProxyAddon(@NotNull File dataFolder, boolean minimessage) {
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        this.configFactory = new ConfigFactory<ProxyConfiguration>(ProxyConfiguration.class, dataFolder, "proxy-config.json", new Pair[0]);
        this.formatter = minimessage ? (MessageFormatter)MiniMessageFormatter.INSTANCE : (MessageFormatter)LegacyFormatter.INSTANCE;
        this.config = new ProxyConfigAccessor(this.configFactory.getConfig());
        SharedServiceProvider<Service> sharedServiceProvider = Polocloud.instance().serviceProvider();
        String string = System.getenv("service-name");
        Intrinsics.checkNotNullExpressionValue(string, "getenv(...)");
        Service service = sharedServiceProvider.find(string);
        Intrinsics.checkNotNull(service);
        this.poloService = service;
        this.applyFormatting();
    }

    @NotNull
    public final ProxyConfigAccessor getConfig() {
        return this.config;
    }

    @NotNull
    public final Service getPoloService() {
        return this.poloService;
    }

    public final void setPoloService(@NotNull Service service) {
        Intrinsics.checkNotNullParameter(service, "<set-?>");
        this.poloService = service;
    }

    private final void applyFormatting() {
        ProxyConfiguration config = this.configFactory.getConfig();
        if (((CharSequence)config.getPrefix()).length() == 0) {
            config.setPrefix(this.formatter.formatPrefix());
        }
        config.getMessages().replaceAll((arg_0, arg_1) -> ProxyAddon.applyFormatting$lambda$1((arg_0, arg_1) -> ProxyAddon.applyFormatting$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
        if (((CharSequence)config.getTablist().getHeader()).length() == 0) {
            config.getTablist().setHeader(this.formatter.formatTablistHeader());
        }
        if (((CharSequence)config.getTablist().getFooter()).length() == 0) {
            config.getTablist().setFooter(this.formatter.formatTablistFooter());
        }
        if (((CharSequence)config.getMotd().getLineOne()).length() == 0) {
            config.getMotd().setLineOne(this.formatter.formatMotdLineOne());
        }
        if (((CharSequence)config.getMotd().getLineTwo()).length() == 0) {
            config.getMotd().setLineTwo(this.formatter.formatMotdLineTwo());
        }
        if (((CharSequence)config.getMaintenanceMotd().getLineOne()).length() == 0) {
            config.getMaintenanceMotd().setLineOne(this.formatter.formatMaintenanceMotdLineOne());
        }
        if (((CharSequence)config.getMaintenanceMotd().getLineTwo()).length() == 0) {
            config.getMaintenanceMotd().setLineTwo(this.formatter.formatMaintenanceMotdLineTwo());
        }
        if (((CharSequence)config.getMaintenanceMotd().getPingMessage()).length() == 0) {
            config.getMaintenanceMotd().setPingMessage(this.formatter.formatMaintenancePingMessage());
        }
        ConfigFactory.save$default(this.configFactory, null, 1, null);
    }

    private static final String applyFormatting$lambda$0(ProxyAddon this$0, String string, String value) {
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        Intrinsics.checkNotNullParameter(value, "value");
        return this$0.formatter.format(value);
    }

    private static final String applyFormatting$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (String)$tmp0.invoke(p0, p1);
    }
}

