/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.common.future;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00040\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"directExecutor", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "completableFromGuava", "Ljava/util/concurrent/CompletableFuture;", "R", "T", "guavaFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "mapper", "Lkotlin/Function1;", "common"})
public final class FutureConverterKt {
    @NotNull
    private static final ListeningExecutorService directExecutor;

    @NotNull
    public static final <T, R> CompletableFuture<R> completableFromGuava(@NotNull ListenableFuture<T> guavaFuture, @NotNull Function1<? super T, ? extends R> mapper) {
        Intrinsics.checkNotNullParameter(guavaFuture, "guavaFuture");
        Intrinsics.checkNotNullParameter(mapper, "mapper");
        CompletableFuture completable = new CompletableFuture();
        guavaFuture.addListener(() -> FutureConverterKt.completableFromGuava$lambda$0(mapper, guavaFuture, completable), directExecutor);
        return completable;
    }

    private static final void completableFromGuava$lambda$0(Function1 $mapper, ListenableFuture $guavaFuture, CompletableFuture $completable) {
        try {
            Object result = $mapper.invoke($guavaFuture.get());
            $completable.complete(result);
        }
        catch (Exception ex) {
            $completable.completeExceptionally(ex);
        }
    }

    static {
        ListeningExecutorService listeningExecutorService = MoreExecutors.newDirectExecutorService();
        Intrinsics.checkNotNullExpressionValue(listeningExecutorService, "newDirectExecutorService(...)");
        directExecutor = listeningExecutorService;
    }
}

