/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.common.network;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u00a8\u0006\u0002"}, d2={"localAddress", "", "common"})
public final class NetworkAddressKt {
    @NotNull
    public static final String localAddress() {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        Intrinsics.checkNotNull(interfaces);
        Iterator<NetworkInterface> iterator2 = CollectionsKt.iterator(interfaces);
        while (iterator2.hasNext()) {
            NetworkInterface iface = iterator2.next();
            if (iface.isLoopback() || !iface.isUp()) continue;
            Enumeration<InetAddress> enumeration = iface.getInetAddresses();
            Intrinsics.checkNotNullExpressionValue(enumeration, "getInetAddresses(...)");
            Iterator<InetAddress> iterator3 = CollectionsKt.iterator(enumeration);
            while (iterator3.hasNext()) {
                InetAddress addr = iterator3.next();
                if (!(addr instanceof Inet4Address) || ((Inet4Address)addr).isLoopbackAddress()) continue;
                String string = ((Inet4Address)addr).getHostAddress();
                Intrinsics.checkNotNullExpressionValue(string, "getHostAddress(...)");
                return string;
            }
        }
        return "null";
    }
}

