/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.common.os;

import com.sun.management.OperatingSystemMXBean;
import dev.httpmarco.polocloud.common.math.ResourceCalculatorKt;
import java.lang.management.ManagementFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0006\u0010\b\u001a\u00020\u0007\u001a\u0006\u0010\t\u001a\u00020\u0007\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"osBean", "Lcom/sun/management/OperatingSystemMXBean;", "getOsBean", "()Lcom/sun/management/OperatingSystemMXBean;", "osBean$delegate", "Lkotlin/Lazy;", "cpuUsage", "", "usedMemory", "maxMemory", "common"})
public final class SystemResourcesKt {
    @NotNull
    private static final Lazy osBean$delegate = LazyKt.lazy(SystemResourcesKt::osBean_delegate$lambda$0);

    private static final OperatingSystemMXBean getOsBean() {
        Lazy lazy = osBean$delegate;
        return (OperatingSystemMXBean)lazy.getValue();
    }

    public static final double cpuUsage() {
        double load = SystemResourcesKt.getOsBean().getCpuLoad();
        if (load < 0.0) {
            return -1.0;
        }
        return (double)MathKt.roundToInt(load * 10000.0) / 100.0;
    }

    public static final double usedMemory() {
        Runtime runtime = Runtime.getRuntime();
        long usedBytes = runtime.totalMemory() - runtime.freeMemory();
        return ResourceCalculatorKt.convertBytesToMegabytes(usedBytes);
    }

    public static final double maxMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxBytes = runtime.maxMemory();
        return ResourceCalculatorKt.convertBytesToMegabytes(maxBytes);
    }

    private static final OperatingSystemMXBean osBean_delegate$lambda$0() {
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        Intrinsics.checkNotNull(operatingSystemMXBean, "null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
        return (OperatingSystemMXBean)operatingSystemMXBean;
    }
}

