/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.common.version;

import dev.httpmarco.polocloud.common.language.Language;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"polocloudVersion", "", "runtimeVersion", "language", "Ldev/httpmarco/polocloud/common/language/Language;", "javaVersion", "rustVersion", "common"})
@SourceDebugExtension(value={"SMAP\nVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Version.kt\ndev/httpmarco/polocloud/common/version/VersionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class VersionKt {
    @NotNull
    public static final String polocloudVersion() {
        String string = System.getenv("POLOCLOUD_VERSION");
        Intrinsics.checkNotNullExpressionValue(string, "getenv(...)");
        return string;
    }

    @NotNull
    public static final String runtimeVersion(@NotNull Language language) {
        String string;
        Intrinsics.checkNotNullParameter((Object)language, "language");
        switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
            case 1: {
                string = VersionKt.javaVersion();
                break;
            }
            case 2: {
                return "";
            }
            case 3: {
                string = VersionKt.rustVersion();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String javaVersion() {
        Object object;
        try {
            String[] stringArray = new String[]{"java", "--version"};
            Process process = new ProcessBuilder(stringArray).start();
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
            Closeable closeable = inputStream;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)closeable, (Charset)object2);
            int n = 8192;
            closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                object3 = TextStreamsKt.readText(it);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)object2);
            }
            Object output = object3;
            Regex versionRegex = new Regex("openjdk\\s+(\\d+\\.\\d+\\.\\d+)");
            Object object4 = Regex.find$default(versionRegex, (CharSequence)output, 0, 2, null);
            if (object4 == null || (object4 = object4.getGroupValues()) == null || (object4 = (String)object4.get(1)) == null) {
                object4 = "";
            }
            object = object4;
        }
        catch (Exception exception) {
            object = "";
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String rustVersion() {
        Object object;
        try {
            String[] stringArray = new String[]{"rustc", "--version"};
            Process process = new ProcessBuilder(stringArray).start();
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
            Closeable closeable = inputStream;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)closeable, (Charset)object2);
            int n = 8192;
            closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                object3 = TextStreamsKt.readText(it);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally(closeable, (Throwable)object2);
            }
            Object output = object3;
            Regex versionRegex = new Regex("rustc\\s+(\\d+\\.\\d+\\.\\d+)");
            Object object4 = Regex.find$default(versionRegex, (CharSequence)output, 0, 2, null);
            if (object4 == null || (object4 = object4.getGroupValues()) == null || (object4 = (String)object4.get(1)) == null) {
                object4 = "";
            }
            object = object4;
        }
        catch (Exception exception) {
            object = "";
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Language.values().length];
            try {
                nArray[Language.JAVA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.GO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.RUST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

