/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.shared.player;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.httpmarco.polocloud.shared.player.PolocloudPlayer;
import java.lang.reflect.Type;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Ldev/httpmarco/polocloud/shared/player/PlayerSerializer;", "Lcom/google/gson/JsonSerializer;", "Ldev/httpmarco/polocloud/shared/player/PolocloudPlayer;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "shared"})
public final class PlayerSerializer
implements JsonSerializer<PolocloudPlayer>,
JsonDeserializer<PolocloudPlayer> {
    @Override
    @NotNull
    public JsonElement serialize(@NotNull PolocloudPlayer src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(typeOfSrc, "typeOfSrc");
        Intrinsics.checkNotNullParameter(context, "context");
        JsonObject json = new JsonObject();
        json.addProperty("uniqueId", src.uniqueId());
        json.addProperty("name", src.getName());
        json.addProperty("currentService", src.getCurrentServiceName());
        return json;
    }

    @Override
    @NotNull
    public PolocloudPlayer deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(typeOfT, "typeOfT");
        Intrinsics.checkNotNullParameter(context, "context");
        JsonObject obj = json.getAsJsonObject();
        String uniqueId = obj.get("uniqueId").getAsString();
        String name = obj.get("name").getAsString();
        String currentService = obj.get("currentService").getAsString();
        Intrinsics.checkNotNull(name);
        UUID uUID = UUID.fromString(uniqueId);
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        Intrinsics.checkNotNull(currentService);
        return new PolocloudPlayer(name, uUID, currentService);
    }
}

