/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.shared.player;

import dev.httpmarco.polocloud.v1.player.PlayerSnapshot;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0004\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0011"}, d2={"Ldev/httpmarco/polocloud/shared/player/PolocloudPlayer;", "", "name", "", "uniqueId", "Ljava/util/UUID;", "currentServiceName", "<init>", "(Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getUniqueId", "()Ljava/util/UUID;", "getCurrentServiceName", "toSnapshot", "Ldev/httpmarco/polocloud/v1/player/PlayerSnapshot;", "Companion", "shared"})
public class PolocloudPlayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final UUID uniqueId;
    @NotNull
    private final String currentServiceName;

    public PolocloudPlayer(@NotNull String name, @NotNull UUID uniqueId, @NotNull String currentServiceName) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(currentServiceName, "currentServiceName");
        this.name = name;
        this.uniqueId = uniqueId;
        this.currentServiceName = currentServiceName;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final UUID getUniqueId() {
        return this.uniqueId;
    }

    @NotNull
    public final String getCurrentServiceName() {
        return this.currentServiceName;
    }

    @NotNull
    public final String uniqueId() {
        String string = this.uniqueId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final PlayerSnapshot toSnapshot() {
        PlayerSnapshot playerSnapshot = PlayerSnapshot.newBuilder().setName(this.name).setUniqueId(this.uniqueId.toString()).setCurrentServiceName(this.currentServiceName).build();
        Intrinsics.checkNotNullExpressionValue(playerSnapshot, "build(...)");
        return playerSnapshot;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/httpmarco/polocloud/shared/player/PolocloudPlayer$Companion;", "", "<init>", "()V", "bindSnapshot", "Ldev/httpmarco/polocloud/shared/player/PolocloudPlayer;", "snapshot", "Ldev/httpmarco/polocloud/v1/player/PlayerSnapshot;", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PolocloudPlayer bindSnapshot(@NotNull PlayerSnapshot snapshot) {
            Intrinsics.checkNotNullParameter(snapshot, "snapshot");
            String string = snapshot.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            UUID uUID = UUID.fromString(snapshot.getUniqueId());
            Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
            String string2 = snapshot.getCurrentServiceName();
            Intrinsics.checkNotNullExpressionValue(string2, "getCurrentServiceName(...)");
            return new PolocloudPlayer(string, uUID, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

