/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.shared.service;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import dev.httpmarco.polocloud.shared.service.Service;
import dev.httpmarco.polocloud.shared.service.ServiceInformation;
import dev.httpmarco.polocloud.shared.template.Template;
import dev.httpmarco.polocloud.v1.GroupType;
import dev.httpmarco.polocloud.v1.services.ServiceState;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Ldev/httpmarco/polocloud/shared/service/ServiceSerializer;", "Lcom/google/gson/JsonSerializer;", "Ldev/httpmarco/polocloud/shared/service/Service;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "shared"})
@SourceDebugExtension(value={"SMAP\nServiceSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceSerializer.kt\ndev/httpmarco/polocloud/shared/service/ServiceSerializer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,91:1\n126#2:92\n153#2,3:93\n*S KotlinDebug\n*F\n+ 1 ServiceSerializer.kt\ndev/httpmarco/polocloud/shared/service/ServiceSerializer\n*L\n40#1:92\n40#1:93,3\n*E\n"})
public final class ServiceSerializer
implements JsonSerializer<Service>,
JsonDeserializer<Service> {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public JsonElement serialize(@NotNull Service src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(typeOfSrc, "typeOfSrc");
        Intrinsics.checkNotNullParameter(context, "context");
        JsonObject data = new JsonObject();
        data.addProperty("name", src.getGroupName());
        data.addProperty("id", src.getId());
        data.addProperty("hostname", src.getHostname());
        data.addProperty("port", src.getPort());
        data.addProperty("state", src.getState().name());
        data.addProperty("type", src.getType().name());
        data.add("templates", context.serialize(src.getTemplates()));
        data.addProperty("information", src.getInformation().toString());
        data.addProperty("minMemory", src.getMinMemory());
        data.addProperty("maxMemory", src.getMaxMemory());
        data.addProperty("maxPlayerCount", src.getMaxPlayerCount());
        data.addProperty("playerCount", src.getPlayerCount());
        data.addProperty("memoryUsage", src.getMemoryUsage());
        data.addProperty("cpuUsage", src.getCpuUsage());
        data.addProperty("motd", src.getMotd());
        Map<String, String> map = src.getProperties();
        JsonSerializationContext jsonSerializationContext = context;
        String string = "properties";
        JsonObject jsonObject = data;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), it.getValue()));
        }
        collection = (List)destination$iv$iv;
        jsonObject.add(string, jsonSerializationContext.serialize(MapsKt.toMap(collection)));
        return data;
    }

    @Override
    @NotNull
    public Service deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(typeOfT, "typeOfT");
        Intrinsics.checkNotNullParameter(context, "context");
        JsonObject data = json.getAsJsonObject();
        String name = data.get("name").getAsString();
        int id = data.get("id").getAsInt();
        String hostname = data.get("hostname").getAsString();
        int port = data.get("port").getAsInt();
        String string = data.get("type").getAsString();
        Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
        GroupType type = GroupType.valueOf(string);
        String string2 = data.get("state").getAsString();
        Intrinsics.checkNotNullExpressionValue(string2, "getAsString(...)");
        ServiceState state = ServiceState.valueOf(string2);
        Type templatesType2 = new TypeToken<List<? extends Template>>(){}.getType();
        List templates = (List)context.deserialize(data.get("templates"), templatesType2);
        String string3 = data.get("information").getAsString();
        Intrinsics.checkNotNullExpressionValue(string3, "getAsString(...)");
        ServiceInformation information = ServiceInformation.Companion.bindString(string3);
        int minMemory = data.get("minMemory").getAsInt();
        int maxMemory = data.get("maxMemory").getAsInt();
        int maxPlayerCount = data.get("maxPlayerCount").getAsInt();
        int playerCount = data.get("playerCount").getAsInt();
        double memoryUsage = data.get("memoryUsage").getAsDouble();
        double cpuUsage = data.get("cpuUsage").getAsDouble();
        String motd = data.get("motd").getAsString();
        Type propertiesType2 = new TypeToken<Map<String, ? extends String>>(){}.getType();
        Map properties = (Map)context.deserialize(data.get("properties"), propertiesType2);
        Intrinsics.checkNotNull(name);
        Intrinsics.checkNotNull(properties);
        Intrinsics.checkNotNull(hostname);
        Intrinsics.checkNotNull(templates);
        Intrinsics.checkNotNull(motd);
        return new Service(name, id, state, type, properties, hostname, port, templates, information, minMemory, maxMemory, playerCount, maxPlayerCount, memoryUsage, cpuUsage, motd);
    }
}

