/*
 * Decompiled with CFR 0.152.
 */
package dev.httpmarco.polocloud.shared.template;

import dev.httpmarco.polocloud.v1.templates.TemplateSnapshot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0004J\b\u0010\u0004\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/httpmarco/polocloud/shared/template/Template;", "", "name", "", "size", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "toSnapshot", "Ldev/httpmarco/polocloud/v1/templates/TemplateSnapshot;", "humanReadableSize", "bytes", "", "Companion", "shared"})
public class Template {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final String size;

    public Template(@NotNull String name, @NotNull String size) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(size, "size");
        this.name = name;
        this.size = size;
    }

    public /* synthetic */ Template(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "unknown";
        }
        this(string, string2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final TemplateSnapshot toSnapshot() {
        TemplateSnapshot templateSnapshot = TemplateSnapshot.newBuilder().setName(this.name).setSize(this.size()).build();
        Intrinsics.checkNotNullExpressionValue(templateSnapshot, "build(...)");
        return templateSnapshot;
    }

    @NotNull
    protected final String humanReadableSize(long bytes) {
        if (bytes <= 0L) {
            return "empty";
        }
        String[] stringArray = new String[]{"B", "KB", "MB", "GB", "TB"};
        String[] units = stringArray;
        int digitGroups = (int)(Math.log10(bytes) / Math.log10(1024.0));
        double humanValue = (double)bytes / Math.pow(1024.0, digitGroups);
        String string = "%.1f %s";
        Object[] objectArray = new Object[]{humanValue, units[digitGroups]};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @NotNull
    public String size() {
        return this.size;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a8\u0006\u000b"}, d2={"Ldev/httpmarco/polocloud/shared/template/Template$Companion;", "", "<init>", "()V", "fromSnapshot", "Ldev/httpmarco/polocloud/shared/template/Template;", "proto", "Ldev/httpmarco/polocloud/v1/templates/TemplateSnapshot;", "bindSnapshot", "", "list", "shared"})
    @SourceDebugExtension(value={"SMAP\nTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Template.kt\ndev/httpmarco/polocloud/shared/template/Template$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1563#2:42\n1634#2,3:43\n*S KotlinDebug\n*F\n+ 1 Template.kt\ndev/httpmarco/polocloud/shared/template/Template$Companion\n*L\n17#1:42\n17#1:43,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Template fromSnapshot(@NotNull TemplateSnapshot proto) {
            Intrinsics.checkNotNullParameter(proto, "proto");
            String string = proto.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String string2 = proto.getSize();
            Intrinsics.checkNotNullExpressionValue(string2, "getSize(...)");
            return new Template(string, string2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Template> bindSnapshot(@NotNull List<TemplateSnapshot> list) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(list, "list");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TemplateSnapshot templateSnapshot = (TemplateSnapshot)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.fromSnapshot((TemplateSnapshot)it));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

