/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mc.init;

import net.mcreator.mc.potion.ConfusionMobEffect;
import net.mcreator.mc.potion.FrozenMobEffect;
import net.mcreator.mc.potion.UltraBitterMobEffect;
import net.mcreator.mc.potion.UltraSpicyMobEffect;
import net.mcreator.mc.procedures.FrozenEndProcedure;
import net.mcreator.mc.procedures.UltraBitterEffectExpiresProcedure;
import net.mcreator.mc.procedures.UltraSpicyEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class Pnf404ModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"pnf404");
    public static final DeferredHolder<MobEffect, MobEffect> ULTRA_SPICY = REGISTRY.register("ultra_spicy", () -> new UltraSpicyMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ULTRA_BITTER = REGISTRY.register("ultra_bitter", () -> new UltraBitterMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FROZEN = REGISTRY.register("frozen", () -> new FrozenMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CONFUSION = REGISTRY.register("confusion", () -> new ConfusionMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            Pnf404ModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            Pnf404ModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(ULTRA_SPICY)) {
            UltraSpicyEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(ULTRA_BITTER)) {
            UltraBitterEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(FROZEN)) {
            FrozenEndProcedure.execute(entity);
        }
    }
}

