
// colour converting
// https://www.shadertoy.com/view/XljGzV
vec3 rgb2hsv(vec3 c){
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c){
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

bool colourMatch(vec3 compare1, vec3 compare2){
    // return true;
    int roundingPrecision = 1000;
    if(floor(compare1.r * roundingPrecision) == floor(compare2.r * roundingPrecision) && floor(compare1.g * roundingPrecision) == floor(compare2.g * roundingPrecision) && floor(compare1.b * roundingPrecision) == floor(compare2.b * roundingPrecision)){
        return true;
    }else{
        return false;
    }
};

vec3 withinRange(vec3 colour, vec3 compare1, vec3 compare2){
    // return true;
    int roundingPrecision = 1000;
    // compare1 = floor(compare1 * roundingPrecision);
    // compare2 = floor(compare2 * roundingPrecision);
    // colour = floor(colour * roundingPrecision);

    if(colour.r >= compare1.r && compare2.r <= colour.r ){
        return vec3(1,0,1);
    }else{
        // return false;
    }
};