/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxTweaksHandler;
import fi.dy.masa.servux.network.packet.ServuxTweaksPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.IServuxSettingCallback;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import fi.dy.masa.servux.util.InventoryUtils;
import fi.dy.masa.servux.util.nbt.NbtView;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3695;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class TweaksDataProvider
extends DataProviderBase {
    public static final TweaksDataProvider INSTANCE = new TweaksDataProvider();
    protected static final ServuxTweaksHandler<ServuxTweaksPacket.Payload> HANDLER = ServuxTweaksHandler.getInstance();
    protected final class_2487 metadata = new class_2487();
    private final BoolCallbacks boolCallback = new BoolCallbacks();
    private final IntCallbacks intCallback = new IntCallbacks();
    protected ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0, (IServuxSettingCallback<Integer>)this.intCallback);
    protected ServuxIntSetting updateInterval = new ServuxIntSetting((IDataProvider)this, "update_interval", 120, 1200, 40, (IServuxSettingCallback<Integer>)this.intCallback);
    protected ServuxBoolSetting stackableShulkers = new ServuxBoolSetting(this, "stackable_shulkers", false, this.boolCallback);
    protected ServuxIntSetting stackableShulkersSize = new ServuxIntSetting((IDataProvider)this, "stackable_shulkers_count", 64, 99, 1, (IServuxSettingCallback<Integer>)this.intCallback);
    protected ServuxBoolSetting stackableShulkersFix = new ServuxBoolSetting(this, "stackable_shulkers_fix", true, this.boolCallback);
    protected List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.updateInterval, this.stackableShulkers, this.stackableShulkersSize, this.stackableShulkersFix);
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();
    private boolean configDirty = false;

    protected TweaksDataProvider() {
        super("tweaks_data", ServuxTweaksHandler.CHANNEL_ID, 1, 0, "servux.provider.tweaks_data", "Tweaks Data provider for Client Side mods.");
        this.metadata.method_10582("name", this.getName());
        this.metadata.method_10582("id", this.getNetworkChannel().toString());
        this.metadata.method_10569("version", this.getProtocolVersion());
        this.metadata.method_10582("servux", Reference.MOD_STRING);
        this.setTickRate(40);
        this.checkTweaksMetadata();
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxTweaksPacket.Payload.ID, ServuxTweaksPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxTweaksPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxTweaksPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public boolean shouldTick() {
        return this.isEnabled();
    }

    @Override
    public void tick(MinecraftServer server, int tickCounter, class_3695 profiler) {
        if (!this.isEnabled()) {
            return;
        }
        if (tickCounter % (Integer)this.updateInterval.getValue() == 0) {
            profiler.method_15396(this.getName());
            if (this.configDirty) {
                this.updateAllTweaks(server);
                this.configDirty = false;
            }
            profiler.method_15407();
        }
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(class_3222 player) {
        return !this.isPlayerInvalid(player);
    }

    private void checkTweaksMetadata() {
        if (this.shouldEmptyShulkersStack()) {
            this.metadata.method_10556("stackingShulkers", this.shouldEmptyShulkersStack());
            this.metadata.method_10569("stackingShulkersMax", ((Integer)this.stackableShulkersSize.getValue()).intValue());
        } else {
            if (this.metadata.method_10545("stackingShulkers")) {
                this.metadata.method_10551("stackingShulkers");
            }
            if (this.metadata.method_10545("stackingShulkersMax")) {
                this.metadata.method_10551("stackingShulkersMax");
            }
        }
    }

    public void updateAllTweaks(MinecraftServer server) {
        Servux.debugLog("tweaksData: Invoke updateAllTweaks()", new Object[0]);
        List players = server.method_3760().method_14571();
        this.checkTweaksMetadata();
        for (class_3222 player : players) {
            if (!this.isPlayerRegistered(player)) continue;
            this.sendMetadata(player);
        }
    }

    public void sendMetadata(class_3222 player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("tweaks_service: Denying access for player {}, Insufficient Permissions", player.method_5477().method_54160());
            return;
        }
        Servux.debugLog("tweaksDataChannel: sendMetadata to player {}", player.method_5477().method_54160());
        this.checkTweaksMetadata();
        if (player.field_13987 != null) {
            HANDLER.sendPlayPayload(player.field_13987, new ServuxTweaksPacket.Payload(ServuxTweaksPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxTweaksPacket.Payload(ServuxTweaksPacket.MetadataResponse(this.metadata)));
        }
    }

    public void onPacketFailure(class_3222 player) {
        this.setPlayerInvalid(player);
    }

    public void removePlayer(class_3222 player) {
        this.removeInvalidPlayer(player);
    }

    private void setPlayerInvalid(class_3222 player) {
        if (!this.invalidPlayers.contains(player.method_5667())) {
            this.invalidPlayers.add(player.method_5667());
        }
    }

    private boolean isPlayerInvalid(class_3222 player) {
        return this.invalidPlayers.contains(player.method_5667());
    }

    private void removeInvalidPlayer(class_3222 player) {
        this.invalidPlayers.remove(player.method_5667());
    }

    public void onBlockEntityRequest(class_3222 player, class_2338 pos) {
        if (!this.hasPermission(player) || !this.isEnabled()) {
            return;
        }
        class_2586 be = player.method_51469().method_8321(pos);
        class_2487 nbt = be != null ? be.method_38244((class_7225.class_7874)player.method_56673()) : new class_2487();
        HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleBlockResponse(pos, nbt));
    }

    public void onEntityRequest(class_3222 player, int entityId) {
        if (!this.hasPermission(player)) {
            return;
        }
        class_1297 entity = player.method_51469().method_8469(entityId);
        if (entity != null) {
            NbtView view = NbtView.getWriter(player.method_51469().method_30349());
            class_2960 id = class_1299.method_5890((class_1299)entity.method_5864());
            entity.method_5647(view.getWriter());
            class_2487 nbt = view.readNbt();
            if (nbt != null && id != null) {
                nbt.method_10582("id", id.toString());
                HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleEntityResponse(entityId, nbt.method_10553()));
            }
        }
    }

    public boolean shouldEmptyShulkersStack() {
        return (Boolean)this.stackableShulkers.getValue();
    }

    public boolean isStackableShulkersFixActive() {
        return this.shouldEmptyShulkersStack() && (Boolean)this.stackableShulkersFix.getValue() != false;
    }

    public int defaultEmptyShulkersMaxCount() {
        if (this.shouldEmptyShulkersStack()) {
            return (Integer)this.stackableShulkersSize.getValue();
        }
        return 1;
    }

    public int getEmptyShulkersMaxCount(class_1799 stack) {
        if (this.shouldEmptyShulkersStack() && InventoryUtils.isShulkerBox(stack)) {
            return this.defaultEmptyShulkersMaxCount();
        }
        return (Integer)stack.method_57353().method_58695(class_9334.field_50071, (Object)1);
    }

    @Override
    public boolean hasPermission(class_3222 player) {
        return Permissions.check((class_1297)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }

    public static class BoolCallbacks
    implements IServuxSettingCallback<Boolean> {
        @Override
        public void onValueChanged(IServuxSetting<Boolean> setting, Boolean oldValue, Boolean value) {
            Servux.debugLog("Config Change detected; {}:{}", setting.dataProvider().getName(), setting.name());
            TweaksDataProvider.INSTANCE.configDirty = true;
        }
    }

    public static class IntCallbacks
    implements IServuxSettingCallback<Integer> {
        @Override
        public void onValueChanged(IServuxSetting<Integer> setting, Integer oldValue, Integer value) {
            Servux.debugLog("Config Change detected; {}:{}", setting.dataProvider().getName(), setting.name());
            TweaksDataProvider.INSTANCE.configDirty = true;
        }
    }
}

