/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.settings;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.IServuxSettingCallback;
import fi.dy.masa.servux.util.i18nLang;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_2561;

public abstract class AbstractServuxSetting<T>
implements IServuxSetting<T> {
    private final String name;
    private final class_2561 prettyName;
    private final class_2561 comment;
    private final T defaultValue;
    private final List<String> examples;
    private final IDataProvider dataProvider;
    @Nullable
    private final IServuxSettingCallback<T> callback;
    private T value;

    public AbstractServuxSetting(IDataProvider dataProvider, String name, class_2561 prettyName, class_2561 comment, T defaultValue, List<String> examples, IServuxSettingCallback<T> callback) {
        Objects.requireNonNull(name);
        this.name = name;
        this.prettyName = prettyName;
        this.comment = comment;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.examples = examples;
        this.dataProvider = dataProvider;
        this.callback = callback;
    }

    public AbstractServuxSetting(IDataProvider dataProvider, String name, class_2561 prettyName, class_2561 comment, T defaultValue, IServuxSettingCallback<T> callback) {
        this(dataProvider, name, prettyName, comment, defaultValue, null, callback);
    }

    public AbstractServuxSetting(IDataProvider dataProvider, String name, class_2561 prettyName, class_2561 comment, T defaultValue) {
        this(dataProvider, name, prettyName, comment, defaultValue, null, null);
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValueNoCallback(T value) {
        this.value = value;
    }

    @Override
    public void setValue(T value) throws CommandSyntaxException {
        T oldValue = this.getValue();
        this.setValueNoCallback(value);
        this.onValueChanged(oldValue, value);
    }

    @Override
    public IDataProvider dataProvider() {
        return this.dataProvider;
    }

    protected void onValueChanged(T oldValue, T value) {
        if (this.callback != null) {
            this.callback.onValueChanged(this, oldValue, value);
        }
    }

    @Override
    public void setValueFromString(String value) throws CommandSyntaxException {
        if (this.validateString(value)) {
            this.setValue(this.valueFromString(value));
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public class_2561 prettyName() {
        if (this.prettyName == null) {
            return i18nLang.getInstance().translate("servux.config." + this.dataProvider.getName() + "." + this.name + ".name", new Object[0]);
        }
        return this.prettyName;
    }

    @Override
    public class_2561 comment() {
        if (this.comment == null) {
            return i18nLang.getInstance().translate("servux.config." + this.dataProvider.getName() + "." + this.name + ".comment", new Object[0]);
        }
        return this.comment;
    }

    @Override
    public List<String> examples() {
        if (this.examples == null) {
            return List.of();
        }
        return this.examples;
    }
}

