/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.settings.AbstractServuxSetting;
import fi.dy.masa.servux.settings.IServuxSettingCallback;
import java.util.List;
import net.minecraft.class_2561;

public class ServuxBoolSetting
extends AbstractServuxSetting<Boolean> {
    public ServuxBoolSetting(IDataProvider dataProvider, String name, class_2561 prettyName, class_2561 comment, boolean defaultValue, IServuxSettingCallback<Boolean> callback) {
        super(dataProvider, name, prettyName, comment, defaultValue, List.of("true", "false"), callback);
    }

    public ServuxBoolSetting(IDataProvider dataProvider, String name, class_2561 prettyName, class_2561 comment, boolean defaultValue) {
        super(dataProvider, name, prettyName, comment, defaultValue, List.of("true", "false"), null);
    }

    public ServuxBoolSetting(IDataProvider dataProvider, String name, boolean defaultValue, IServuxSettingCallback<Boolean> callback) {
        super(dataProvider, name, null, null, defaultValue, List.of("true", "false"), callback);
    }

    public ServuxBoolSetting(IDataProvider dataProvider, String name, boolean defaultValue) {
        super(dataProvider, name, null, null, defaultValue, List.of("true", "false"), null);
    }

    @Override
    public boolean validateString(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
    }

    @Override
    public String valueToString(Object value) {
        return ((Boolean)value).toString();
    }

    @Override
    public Boolean valueFromString(String value) {
        return Boolean.parseBoolean(value);
    }

    @Override
    public void readFromJson(JsonElement element) {
        JsonPrimitive value;
        if (element.isJsonPrimitive() && (value = element.getAsJsonPrimitive()).isBoolean()) {
            this.setValueNoCallback(value.getAsBoolean());
        }
    }

    @Override
    public JsonElement writeToJson() {
        return new JsonPrimitive((Boolean)this.getValue());
    }
}

