/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderManager;
import fi.dy.masa.servux.dataproviders.LitematicsDataProvider;
import fi.dy.masa.servux.mixin.world.IMixinWorldTickScheduler;
import fi.dy.masa.servux.network.packet.ServuxLitematicaHandler;
import fi.dy.masa.servux.network.packet.ServuxLitematicaPacket;
import fi.dy.masa.servux.schematic.SchematicMetadata;
import fi.dy.masa.servux.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.servux.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.servux.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.servux.schematic.placement.SchematicPlacement;
import fi.dy.masa.servux.schematic.placement.SubRegionPlacement;
import fi.dy.masa.servux.schematic.selection.AreaSelection;
import fi.dy.masa.servux.schematic.selection.Box;
import fi.dy.masa.servux.schematic.transmit.SchematicBufferManager;
import fi.dy.masa.servux.util.BlockUtils;
import fi.dy.masa.servux.util.EntityUtils;
import fi.dy.masa.servux.util.FileUtils;
import fi.dy.masa.servux.util.IntBoundingBox;
import fi.dy.masa.servux.util.ReplaceBehavior;
import fi.dy.masa.servux.util.SchematicPlacingUtils;
import fi.dy.masa.servux.util.WorldUtils;
import fi.dy.masa.servux.util.data.FileType;
import fi.dy.masa.servux.util.nbt.NbtUtils;
import fi.dy.masa.servux.util.nbt.NbtView;
import fi.dy.masa.servux.util.position.PositionUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_155;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2577;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4076;
import net.minecraft.class_6755;
import net.minecraft.class_6760;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.Pair;

public class LitematicaSchematic {
    public static final String FILE_EXTENSION = ".litematic";
    public static final int MINECRAFT_DATA_VERSION_1_12 = 1139;
    public static final int MINECRAFT_DATA_VERSION = class_155.method_16673().comp_4026().comp_4038();
    public static final int SCHEMATIC_VERSION = 7;
    public static final int SCHEMATIC_VERSION_SUB = 1;
    public final Map<String, LitematicaBlockStateContainer> blockContainers = new HashMap<String, LitematicaBlockStateContainer>();
    public final Map<String, Map<class_2338, class_2487>> tileEntities = new HashMap<String, Map<class_2338, class_2487>>();
    public final Map<String, Map<class_2338, class_6760<class_2248>>> pendingBlockTicks = new HashMap<String, Map<class_2338, class_6760<class_2248>>>();
    public final Map<String, Map<class_2338, class_6760<class_3611>>> pendingFluidTicks = new HashMap<String, Map<class_2338, class_6760<class_3611>>>();
    public final Map<String, List<EntityInfo>> entities = new HashMap<String, List<EntityInfo>>();
    public final Map<String, class_2338> subRegionPositions = new HashMap<String, class_2338>();
    public final Map<String, class_2338> subRegionSizes = new HashMap<String, class_2338>();
    public final SchematicMetadata metadata = new SchematicMetadata();
    private int totalBlocksReadFromWorld;
    @Nullable
    private final Path schematicFile;
    private final FileType schematicType;

    public LitematicaSchematic(class_2487 nbtCompound) throws CommandSyntaxException {
        this.readFromNBT(nbtCompound, false);
        this.schematicFile = Path.of("/", new String[0]);
        this.schematicType = FileType.LITEMATICA_SCHEMATIC;
    }

    private LitematicaSchematic(@Nullable Path file) {
        this(file, FileType.LITEMATICA_SCHEMATIC);
    }

    private LitematicaSchematic(@Nullable Path file, FileType schematicType) {
        this.schematicFile = file;
        this.schematicType = schematicType;
    }

    @Nullable
    public Path getFile() {
        return this.schematicFile;
    }

    public class_2382 getTotalSize() {
        return this.metadata.getEnclosingSize();
    }

    public int getTotalBlocksReadFromWorld() {
        return this.totalBlocksReadFromWorld;
    }

    public SchematicMetadata getMetadata() {
        return this.metadata;
    }

    public int getSubRegionCount() {
        return this.blockContainers.size();
    }

    @Nullable
    public class_2338 getSubRegionPosition(String areaName) {
        return this.subRegionPositions.get(areaName);
    }

    public Map<String, class_2338> getAreaPositions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            class_2338 pos = this.subRegionPositions.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    public Map<String, class_2338> getAreaSizes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionSizes.keySet()) {
            class_2338 pos = this.subRegionSizes.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    @Nullable
    public class_2338 getAreaSize(String regionName) {
        return this.subRegionSizes.get(regionName);
    }

    public Map<String, Box> getAreas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            class_2338 pos = this.subRegionPositions.get(name);
            class_2338 posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((class_2382)this.subRegionSizes.get(name));
            Box box = new Box(pos, pos.method_10081((class_2382)posEndRel), name);
            builder.put((Object)name, (Object)box);
        }
        return builder.build();
    }

    @Nullable
    public static LitematicaSchematic createFromWorld(class_1937 world, AreaSelection area, SchematicSaveInfo info, String author) {
        List<Box> boxes = PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            Servux.LOGGER.warn("createFromWorld: No Selection boxes.");
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(Path.of("/", new String[0]));
        long time = System.currentTimeMillis();
        class_2338 origin = area.getEffectiveOrigin();
        schematic.setSubRegionPositions(boxes, origin);
        schematic.setSubRegionSizes(boxes);
        schematic.takeBlocksFromWorld(world, boxes, info);
        if (!info.ignoreEntities) {
            schematic.takeEntitiesFromWorld(world, boxes, origin);
        }
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setTimeCreated(time);
        schematic.metadata.setTimeModified(time);
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize(PositionUtils.getEnclosingAreaSize(boxes));
        schematic.metadata.setTotalBlocks(schematic.totalBlocksReadFromWorld);
        schematic.metadata.setSchematicVersion(7);
        schematic.metadata.setMinecraftDataVersion(MINECRAFT_DATA_VERSION);
        schematic.metadata.setFileType(FileType.LITEMATICA_SCHEMATIC);
        return schematic;
    }

    public boolean placeToWorld(class_1937 world, SchematicPlacement schematicPlacement, boolean notifyNeighbors) {
        return this.placeToWorld(world, schematicPlacement, notifyNeighbors, false);
    }

    public boolean placeToWorld(class_1937 world, SchematicPlacement schematicPlacement, boolean notifyNeighbors, boolean ignoreEntities) {
        WorldUtils.setShouldPreventBlockUpdates(world, true);
        ImmutableMap<String, SubRegionPlacement> relativePlacements = schematicPlacement.getEnabledRelativeSubRegionPlacements();
        class_2338 origin = schematicPlacement.getOrigin();
        for (String regionName : relativePlacements.keySet()) {
            SubRegionPlacement placement = (SubRegionPlacement)relativePlacements.get((Object)regionName);
            if (!placement.isEnabled()) continue;
            class_2338 regionPos = placement.getPos();
            class_2338 regionSize = this.subRegionSizes.get(regionName);
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<class_2338, class_2487> tileMap = this.tileEntities.get(regionName);
            List<EntityInfo> entityList = this.entities.get(regionName);
            Map<class_2338, class_6760<class_2248>> scheduledBlockTicks = this.pendingBlockTicks.get(regionName);
            Map<class_2338, class_6760<class_3611>> scheduledFluidTicks = this.pendingFluidTicks.get(regionName);
            if (regionPos != null && regionSize != null && container != null && tileMap != null) {
                this.placeBlocksToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, container, tileMap, scheduledBlockTicks, scheduledFluidTicks, notifyNeighbors);
            } else {
                Servux.LOGGER.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)this.metadata.getName(), (Object)regionName);
            }
            if (ignoreEntities || schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
            this.placeEntitiesToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, entityList);
        }
        WorldUtils.setShouldPreventBlockUpdates(world, false);
        return true;
    }

    private boolean placeBlocksToWorld(class_1937 world, class_2338 origin, class_2338 regionPos, class_2338 regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, LitematicaBlockStateContainer container, Map<class_2338, class_2487> tileMap, @Nullable Map<class_2338, class_6760<class_2248>> scheduledBlockTicks, @Nullable Map<class_2338, class_6760<class_3611>> scheduledFluidTicks, boolean notifyNeighbors) {
        class_2338 posEndRelSub = PositionUtils.getRelativeEndPositionFromAreaSize((class_2382)regionSize);
        class_2338 posEndRel = posEndRelSub.method_10081((class_2382)regionPos);
        class_2338 posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        class_2338 regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        class_2338 regionPosAbs = regionPosTransformed.method_10081((class_2382)origin);
        int sizeX = Math.abs(regionSize.method_10263());
        int sizeY = Math.abs(regionSize.method_10264());
        int sizeZ = Math.abs(regionSize.method_10260());
        class_2680 barrier = class_2246.field_10499.method_9564();
        boolean ignoreInventories = false;
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        ReplaceBehavior replace = ReplaceBehavior.ALL;
        class_2470 rotationCombined = schematicPlacement.getRotation().method_10501(placement.getRotation());
        class_2415 mirrorMain = schematicPlacement.getMirror();
        class_2415 mirrorSub = placement.getMirror();
        if (mirrorSub != class_2415.field_11302 && (schematicPlacement.getRotation() == class_2470.field_11463 || schematicPlacement.getRotation() == class_2470.field_11465)) {
            mirrorSub = mirrorSub == class_2415.field_11301 ? class_2415.field_11300 : class_2415.field_11301;
        }
        int bottomY = world.method_31607();
        int topY = world.method_31600() + 1;
        int tmp = posMinRel.method_10264() - regionPos.method_10264() + regionPosTransformed.method_10264() + origin.method_10264();
        int startY = 0;
        int endY = sizeY;
        if (tmp < bottomY) {
            startY += bottomY - tmp;
        }
        if ((tmp = posMinRel.method_10264() - regionPos.method_10264() + regionPosTransformed.method_10264() + origin.method_10264() + (endY - 1)) > topY) {
            endY -= tmp - topY;
        }
        for (int y = startY; y < endY; ++y) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int x = 0; x < sizeX; ++x) {
                    class_2586 te;
                    class_2680 state = container.get(x, y, z);
                    if (state.method_26204() == class_2246.field_10369) continue;
                    posMutable.method_10103(x, y, z);
                    class_2487 teNBT = tileMap.get(posMutable);
                    posMutable.method_10103(posMinRel.method_10263() + x - regionPos.method_10263(), posMinRel.method_10264() + y - regionPos.method_10264(), posMinRel.method_10260() + z - regionPos.method_10260());
                    class_2338 pos = PositionUtils.getTransformedPlacementPosition((class_2338)posMutable, schematicPlacement, placement);
                    pos = pos.method_10081((class_2382)regionPosTransformed).method_10081((class_2382)origin);
                    class_2680 stateOld = world.method_8320(pos);
                    if (replace == ReplaceBehavior.NONE && !stateOld.method_26215() || replace == ReplaceBehavior.WITH_NON_AIR && state.method_26215()) continue;
                    if (mirrorMain != class_2415.field_11302) {
                        state = state.method_26185(mirrorMain);
                    }
                    if (mirrorSub != class_2415.field_11302) {
                        state = state.method_26185(mirrorSub);
                    }
                    if (rotationCombined != class_2470.field_11467) {
                        state = state.method_26186(rotationCombined);
                    }
                    if (stateOld == state && !state.method_31709()) continue;
                    class_2586 teOld = world.method_8321(pos);
                    if (teOld != null) {
                        if (teOld instanceof class_1263) {
                            ((class_1263)teOld).method_5448();
                        }
                        world.method_8652(pos, barrier, 20);
                    }
                    if (!world.method_8652(pos, state, 18) || teNBT == null || (te = world.method_8321(pos)) == null) continue;
                    teNBT = teNBT.method_10553();
                    teNBT.method_10569("x", pos.method_10263());
                    teNBT.method_10569("y", pos.method_10264());
                    teNBT.method_10569("z", pos.method_10260());
                    try {
                        NbtView view = NbtView.getReader(teNBT, world.method_30349());
                        te.method_58690(view.getReader());
                        continue;
                    }
                    catch (Exception e) {
                        Servux.LOGGER.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        return true;
    }

    private void placeEntitiesToWorld(class_1937 world, class_2338 origin, class_2338 regionPos, class_2338 regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, List<EntityInfo> entityList) {
        class_2338 regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.method_10263() + origin.method_10263();
        int offY = regionPosRelTransformed.method_10264() + origin.method_10264();
        int offZ = regionPosRelTransformed.method_10260() + origin.method_10260();
        class_2470 rotationCombined = schematicPlacement.getRotation().method_10501(placement.getRotation());
        class_2415 mirrorMain = schematicPlacement.getMirror();
        class_2415 mirrorSub = placement.getMirror();
        if (mirrorSub != class_2415.field_11302 && (schematicPlacement.getRotation() == class_2470.field_11463 || schematicPlacement.getRotation() == class_2470.field_11465)) {
            mirrorSub = mirrorSub == class_2415.field_11301 ? class_2415.field_11300 : class_2415.field_11301;
        }
        for (EntityInfo info : entityList) {
            class_1297 entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            class_243 pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.field_1352 + (double)offX;
            double y = pos.field_1351 + (double)offY;
            double z = pos.field_1350 + (double)offZ;
            SchematicPlacingUtils.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    private void takeEntitiesFromWorld(class_1937 world, List<Box> boxes, class_2338 origin) {
        for (Box box : boxes) {
            class_238 bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2());
            class_2338 regionPosAbs = box.getPos1();
            ArrayList<EntityInfo> list = new ArrayList<EntityInfo>();
            List entities = world.method_8333(null, bb, EntityUtils.NOT_PLAYER);
            for (class_1297 entity : entities) {
                NbtView view = NbtView.getWriter(world.method_30349());
                entity.method_5662(view.getWriter());
                class_2487 tag = view.readNbt();
                class_2960 id = class_1299.method_5890((class_1299)entity.method_5864());
                if (tag == null || id == null) continue;
                class_243 posVec = new class_243(entity.method_23317() - (double)regionPosAbs.method_10263(), entity.method_23318() - (double)regionPosAbs.method_10264(), entity.method_23321() - (double)regionPosAbs.method_10260());
                tag.method_10582("id", id.toString());
                NbtUtils.putVec3dCodec(tag, posVec, "Pos");
                list.add(new EntityInfo(posVec, tag));
            }
            this.entities.put(box.getName(), list);
        }
    }

    public void takeEntitiesFromWorldWithinChunk(class_1937 world, int chunkX, int chunkZ, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes, Set<UUID> existingEntities, class_2338 origin) {
        for (Map.Entry entry : volumes.entrySet()) {
            String regionName = (String)entry.getKey();
            List<EntityInfo> list = this.entities.get(regionName);
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null || list == null) continue;
            class_238 bb = PositionUtils.createAABBFrom((IntBoundingBox)entry.getValue());
            List entities = world.method_8333(null, bb, EntityUtils.NOT_PLAYER);
            class_2338 regionPosAbs = box.getPos1();
            for (class_1297 entity : entities) {
                UUID uuid = entity.method_5667();
                if (existingEntities.contains(uuid)) continue;
                NbtView view = NbtView.getWriter(world.method_30349());
                entity.method_5662(view.getWriter());
                class_2487 tag = view.readNbt();
                class_2960 id = class_1299.method_5890((class_1299)entity.method_5864());
                if (tag == null || id == null) continue;
                class_243 posVec = new class_243(entity.method_23317() - (double)regionPosAbs.method_10263(), entity.method_23318() - (double)regionPosAbs.method_10264(), entity.method_23321() - (double)regionPosAbs.method_10260());
                tag.method_10582("id", id.toString());
                if (entity instanceof class_1530) {
                    class_1530 decorationEntity = (class_1530)entity;
                    class_2338 p = decorationEntity.method_24515();
                    tag.method_10569("TileX", p.method_10263() - regionPosAbs.method_10263());
                    tag.method_10569("TileY", p.method_10264() - regionPosAbs.method_10264());
                    tag.method_10569("TileZ", p.method_10260() - regionPosAbs.method_10260());
                }
                NbtUtils.putVec3dCodec(tag, posVec, "Pos");
                list.add(new EntityInfo(posVec, tag));
                existingEntities.add(uuid);
            }
        }
    }

    private void takeBlocksFromWorld(class_1937 world, List<Box> boxes, SchematicSaveInfo info) {
        class_2338.class_2339 posMutable = new class_2338.class_2339(0, 0, 0);
        for (Box box : boxes) {
            class_2338 size = box.getSize();
            int sizeX = Math.abs(size.method_10263());
            int sizeY = Math.abs(size.method_10264());
            int sizeZ = Math.abs(size.method_10260());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            HashMap<class_2338, class_2487> tileEntityMap = new HashMap<class_2338, class_2487>();
            HashMap blockTickMap = new HashMap();
            HashMap fluidTickMap = new HashMap();
            class_2338 minCorner = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int startX = minCorner.method_10263();
            int startY = minCorner.method_10264();
            int startZ = minCorner.method_10260();
            boolean visibleOnly = info.visibleOnly;
            boolean includeSupport = info.includeSupportBlocks;
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        class_2586 te;
                        posMutable.method_10103(x + startX, y + startY, z + startZ);
                        if (visibleOnly && !LitematicaSchematic.isExposed(world, (class_2338)posMutable) && (!includeSupport || !LitematicaSchematic.isSupport(world, (class_2338)posMutable))) continue;
                        class_2680 state = world.method_8320((class_2338)posMutable);
                        container.set(x, y, z, state);
                        if (!state.method_26215()) {
                            ++this.totalBlocksReadFromWorld;
                        }
                        if (!state.method_31709() || (te = world.method_8321((class_2338)posMutable)) == null) continue;
                        class_2338 pos = new class_2338(x, y, z);
                        class_2487 tag = te.method_38242((class_7225.class_7874)world.method_30349());
                        NbtUtils.writeBlockPosToTag((class_2382)pos, tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                IntBoundingBox tickBox = IntBoundingBox.createProper(startX, startY, startZ, startX + sizeX, startY + sizeY, startZ + sizeZ);
                long currentTick = world.method_8510();
                this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.method_14196()).servux_getChunkTickSchedulers(), blockTickMap, tickBox, minCorner, currentTick);
                this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.method_14179()).servux_getChunkTickSchedulers(), fluidTickMap, tickBox, minCorner, currentTick);
            }
            this.blockContainers.put(box.getName(), container);
            this.tileEntities.put(box.getName(), tileEntityMap);
            this.pendingBlockTicks.put(box.getName(), blockTickMap);
            this.pendingFluidTicks.put(box.getName(), fluidTickMap);
        }
    }

    private <T> void getTicksFromScheduler(Long2ObjectMap<class_6755<T>> chunkTickSchedulers, Map<class_2338, class_6760<T>> outputMap, IntBoundingBox box, class_2338 minCorner, long currentTick) {
        int minCX = class_4076.method_18675((int)box.minX);
        int minCZ = class_4076.method_18675((int)box.minZ);
        int maxCX = class_4076.method_18675((int)box.maxX);
        int maxCZ = class_4076.method_18675((int)box.maxZ);
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                long cp = class_1923.method_8331((int)cx, (int)cz);
                class_6755 chunkTickScheduler = (class_6755)chunkTickSchedulers.get(cp);
                if (chunkTickScheduler == null) continue;
                chunkTickScheduler.method_39372().filter(t -> box.containsPos((class_2382)t.comp_253())).forEach(t -> this.addRelativeTickToMap(outputMap, (class_6760)t, minCorner, currentTick));
            }
        }
    }

    private <T> void addRelativeTickToMap(Map<class_2338, class_6760<T>> outputMap, class_6760<T> tick, class_2338 minCorner, long currentTick) {
        class_2338 pos = tick.comp_253();
        class_2338 relativePos = new class_2338(pos.method_10263() - minCorner.method_10263(), pos.method_10264() - minCorner.method_10264(), pos.method_10260() - minCorner.method_10260());
        class_6760 newTick = new class_6760(tick.comp_252(), relativePos, tick.comp_254() - currentTick, tick.comp_255(), tick.comp_256());
        outputMap.put(relativePos, newTick);
    }

    public static boolean isExposed(class_1937 world, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 posAdj = pos.method_10093(dir);
            class_2680 stateAdj = world.method_8320(posAdj);
            if (stateAdj.method_26225() && stateAdj.method_26206((class_1922)world, posAdj, dir.method_10153())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGravityBlock(class_2680 state) {
        return state.method_26164(class_3481.field_15466) || state.method_26164(class_3481.field_45063) || state.method_26204() == class_2246.field_10255;
    }

    public static boolean isGravityBlock(class_1937 world, class_2338 pos) {
        return LitematicaSchematic.isGravityBlock(world.method_8320(pos));
    }

    public static boolean supportsExposedBlocks(class_1937 world, class_2338 pos) {
        class_2338 posUp = pos.method_10093(class_2350.field_11036);
        class_2680 stateUp = world.method_8320(posUp);
        while (true) {
            if (LitematicaSchematic.needsSupportNonGravity(stateUp)) {
                return true;
            }
            if (!LitematicaSchematic.isGravityBlock(stateUp)) break;
            if (LitematicaSchematic.isExposed(world, posUp)) {
                return true;
            }
            if ((posUp = posUp.method_10093(class_2350.field_11036)).method_10264() >= world.method_31600() + 1) break;
            stateUp = world.method_8320(posUp);
        }
        return false;
    }

    public static boolean needsSupportNonGravity(class_2680 state) {
        class_2248 block = state.method_26204();
        return block == class_2246.field_10450 || block == class_2246.field_10377 || block == class_2246.field_10477 || block instanceof class_2577;
    }

    public static boolean isSupport(class_1937 world, class_2338 pos) {
        class_2338 posUp = pos.method_10093(class_2350.field_11036);
        class_2680 stateUp = world.method_8320(posUp);
        if (LitematicaSchematic.needsSupportNonGravity(stateUp)) {
            return true;
        }
        return LitematicaSchematic.isGravityBlock(stateUp) && (LitematicaSchematic.isExposed(world, posUp) || LitematicaSchematic.supportsExposedBlocks(world, posUp));
    }

    private void setSubRegionPositions(List<Box> boxes, class_2338 areaOrigin) {
        for (Box box : boxes) {
            this.subRegionPositions.put(box.getName(), box.getPos1().method_10059((class_2382)areaOrigin));
        }
    }

    private void setSubRegionSizes(List<Box> boxes) {
        for (Box box : boxes) {
            this.subRegionSizes.put(box.getName(), box.getSize());
        }
    }

    @Nullable
    public LitematicaBlockStateContainer getSubRegionContainer(String regionName) {
        return this.blockContainers.get(regionName);
    }

    @Nullable
    public Map<class_2338, class_2487> getBlockEntityMapForRegion(String regionName) {
        return this.tileEntities.get(regionName);
    }

    @Nullable
    public List<EntityInfo> getEntityListForRegion(String regionName) {
        return this.entities.get(regionName);
    }

    @Nullable
    public Map<class_2338, class_6760<class_2248>> getScheduledBlockTicksForRegion(String regionName) {
        return this.pendingBlockTicks.get(regionName);
    }

    @Nullable
    public Map<class_2338, class_6760<class_3611>> getScheduledFluidTicksForRegion(String regionName) {
        return this.pendingFluidTicks.get(regionName);
    }

    private class_2487 writeToNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("MinecraftDataVersion", MINECRAFT_DATA_VERSION);
        nbt.method_10569("Version", 7);
        nbt.method_10569("SubVersion", 1);
        nbt.method_10566("Metadata", (class_2520)this.metadata.writeToNBT());
        nbt.method_10566("Regions", (class_2520)this.writeSubRegionsToNBT());
        return nbt;
    }

    private class_2487 writeSubRegionsToNBT() {
        class_2487 wrapper = new class_2487();
        if (!this.blockContainers.isEmpty()) {
            for (String regionName : this.blockContainers.keySet()) {
                LitematicaBlockStateContainer blockContainer = this.blockContainers.get(regionName);
                Map<class_2338, class_2487> tileMap = this.tileEntities.get(regionName);
                List<EntityInfo> entityList = this.entities.get(regionName);
                Map pendingBlockTicks = this.pendingBlockTicks.get(regionName);
                Map pendingFluidTicks = this.pendingFluidTicks.get(regionName);
                class_2487 tag = new class_2487();
                tag.method_10566("BlockStatePalette", (class_2520)blockContainer.getPalette().writeToNBT());
                tag.method_10566("BlockStates", (class_2520)new class_2501(blockContainer.getBackingLongArray()));
                tag.method_10566("TileEntities", (class_2520)this.writeTileEntitiesToNBT(tileMap));
                if (pendingBlockTicks != null) {
                    tag.method_10566("PendingBlockTicks", (class_2520)this.writePendingTicksToNBT(pendingBlockTicks, (class_2378)class_7923.field_41175, "Block"));
                }
                if (pendingFluidTicks != null) {
                    tag.method_10566("PendingFluidTicks", (class_2520)this.writePendingTicksToNBT(pendingFluidTicks, (class_2378)class_7923.field_41173, "Fluid"));
                }
                if (entityList != null) {
                    tag.method_10566("Entities", (class_2520)this.writeEntitiesToNBT(entityList));
                }
                class_2338 pos = this.subRegionPositions.get(regionName);
                tag.method_10566("Position", (class_2520)NbtUtils.createBlockPosTag((class_2382)pos));
                pos = this.subRegionSizes.get(regionName);
                tag.method_10566("Size", (class_2520)NbtUtils.createBlockPosTag((class_2382)pos));
                wrapper.method_10566(regionName, (class_2520)tag);
            }
        }
        return wrapper;
    }

    private class_2499 writeEntitiesToNBT(List<EntityInfo> entityList) {
        class_2499 tagList = new class_2499();
        if (!entityList.isEmpty()) {
            for (EntityInfo info : entityList) {
                tagList.add((Object)info.nbt);
            }
        }
        return tagList;
    }

    private <T> class_2499 writePendingTicksToNBT(Map<class_2338, class_6760<T>> tickMap, class_2378<T> registry, String tagName) {
        class_2499 tagList = new class_2499();
        if (!tickMap.isEmpty()) {
            for (class_6760<T> entry : tickMap.values()) {
                Object target = entry.comp_252();
                class_2960 id = registry.method_10221(target);
                if (id == null) continue;
                class_2487 tag = new class_2487();
                tag.method_10582(tagName, id.toString());
                tag.method_10569("Priority", entry.comp_255().method_8681());
                tag.method_10544("SubTick", entry.comp_256());
                tag.method_10569("Time", (int)entry.comp_254());
                tag.method_10569("x", entry.comp_253().method_10263());
                tag.method_10569("y", entry.comp_253().method_10264());
                tag.method_10569("z", entry.comp_253().method_10260());
                tagList.add((Object)tag);
            }
        }
        return tagList;
    }

    private class_2499 writeTileEntitiesToNBT(Map<class_2338, class_2487> tileMap) {
        class_2499 tagList = new class_2499();
        if (!tileMap.isEmpty()) {
            tagList.addAll(tileMap.values());
        }
        return tagList;
    }

    public void sendTransmitFile(class_2487 nbtIn, long sessionKey, class_3222 player) {
        Path file = this.getFile();
        class_2487 output = new class_2487();
        output.method_10582("Task", "Litematic-TransmitStart");
        output.method_10582("FileName", file.getFileName().toString());
        output.method_67494("FileType", FileType.CODEC, (Object)this.schematicType);
        output.method_10544("SliceKey", sessionKey);
        if (!nbtIn.method_33133()) {
            output.method_10566("PlacementData", (class_2520)nbtIn);
        }
        ServuxLitematicaHandler.getInstance().encodeServerData(player, ServuxLitematicaPacket.ResponseC2SStart(output));
        int bufferSize = 16384;
        byte[] buffer = new byte[16384];
        int totalBytes = 0;
        int totalSlices = 0;
        output.method_10544("SliceKey", sessionKey);
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            int bytesRead = 0;
            output.method_10582("Task", "Litematic-TransmitData");
            while (bytesRead != -1) {
                output.method_10551("Slice");
                output.method_10551("Size");
                output.method_10551("Data");
                bytesRead = is.read(buffer, 0, 16384);
                output.method_10569("Slice", totalSlices);
                output.method_10569("Size", bytesRead);
                output.method_10570("Data", buffer);
                ServuxLitematicaHandler.getInstance().encodeServerData(player, ServuxLitematicaPacket.ResponseC2SStart(output));
                totalBytes += bytesRead;
                ++totalSlices;
            }
        }
        catch (Exception err) {
            output = new class_2487();
            output.method_10544("SliceKey", sessionKey);
            output.method_10582("Task", "Litematic-TransmitCancel");
            ServuxLitematicaHandler.getInstance().encodeServerData(player, ServuxLitematicaPacket.ResponseC2SStart(output));
            Servux.LOGGER.error("sliceForServux: Exception reading file; {}", (Object)err.getLocalizedMessage());
            return;
        }
        output.method_10551("Slice");
        output.method_10551("Size");
        output.method_10551("Data");
        output.method_10569("TotalSize", totalBytes);
        output.method_10569("TotalSlices", totalSlices);
        output.method_10582("Task", "Litematic-TransmitEnd");
        ServuxLitematicaHandler.getInstance().encodeServerData(player, ServuxLitematicaPacket.ResponseC2SStart(output));
    }

    @Nullable
    public static Pair<LitematicaSchematic, class_2487> receiveFileTransmit(class_2487 nbt, class_3222 player) {
        SchematicBufferManager manager = LitematicsDataProvider.INSTANCE.getBufferManager();
        String task = nbt.method_68564("Task", "");
        long key = nbt.method_68080("SliceKey", -1L);
        if (task.isEmpty() || key == -1L) {
            Servux.LOGGER.error("receiveFileTransmit: Invalid sessionKey or Task received.");
            return null;
        }
        switch (task) {
            case "Litematic-TransmitStart": {
                FileType type = nbt.method_67491("FileType", FileType.CODEC).orElse(FileType.LITEMATICA_SCHEMATIC);
                String name = nbt.method_68564("FileName", "default_file");
                manager.createBuffer(name, type, key, nbt.method_68568("PlacementData"), player);
                break;
            }
            case "Litematic-TransmitData": {
                int slice = nbt.method_68083("Slice", -1);
                int size = nbt.method_68083("Size", -1);
                byte[] data = nbt.method_10547("Data").orElse(new byte[0]);
                if (slice < 0 || size < 0 || data.length == 0) {
                    Servux.LOGGER.error("receiveFileTransmit: Invalid Slice Data received for session key [{}]", (Object)key);
                    return null;
                }
                manager.receiveSlice(key, slice, data, size);
                break;
            }
            case "Litematic-TransmitCancel": {
                Servux.LOGGER.warn("receiveFileTransmit: Cancel received for session key [{}]", (Object)key);
                manager.cancelBuffer(key);
                break;
            }
            case "Litematic-TransmitEnd": {
                int totalSize = nbt.method_68083("TotalSize", -1);
                int totalSlices = nbt.method_68083("TotalSlices", -1);
                Path dir = LitematicsDataProvider.INSTANCE.getTransmitDir();
                class_2487 optional = manager.getOptionalNbt(key);
                LitematicaSchematic schematic = manager.finishBuffer(key, dir);
                manager.removePlayer(player);
                if (schematic == null) {
                    Servux.LOGGER.warn("receiveFileTransmit: Failed to create Schematic for finishing session key [{}]", (Object)key);
                    return null;
                }
                Servux.debugLog("receiveFileTransmit: Received file '{}', [tS: {}, tB: {}]", schematic.getFile().toAbsolutePath().toString(), totalSlices, totalSize);
                return Pair.of((Object)schematic, (Object)optional);
            }
            default: {
                Servux.LOGGER.error("receiveFileTransmit: Invalid sessionKey or Task received.");
            }
        }
        return null;
    }

    private boolean readFromNBT(class_2487 nbt, boolean enableFixers) throws CommandSyntaxException {
        this.blockContainers.clear();
        this.tileEntities.clear();
        this.entities.clear();
        this.pendingBlockTicks.clear();
        this.subRegionPositions.clear();
        this.subRegionSizes.clear();
        if (nbt.method_10545("Version")) {
            int minecraftDataVersion;
            int version = nbt.method_68083("Version", -1);
            int n = minecraftDataVersion = nbt.method_10545("MinecraftDataVersion") ? nbt.method_68083("MinecraftDataVersion", 1139) : class_155.method_16673().comp_4026().comp_4038();
            if (version >= 1 && version <= 7) {
                this.metadata.readFromNBT(nbt.method_68568("Metadata"));
                this.metadata.setSchematicVersion(version);
                this.metadata.setMinecraftDataVersion(minecraftDataVersion);
                this.metadata.setFileType(FileType.LITEMATICA_SCHEMATIC);
                this.readSubRegionsFromNBT(nbt.method_68568("Regions"), version, minecraftDataVersion, enableFixers);
                return true;
            }
            this.error("servux.litematics.error.schematic_load.unsupported_schematic_version");
        } else {
            this.error("servux.litematics.error.schematic_load.no_schematic_version_information");
        }
        return false;
    }

    private void error(String s, Objects ... objects) throws CommandSyntaxException {
        throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)s, (Object[])objects)).create();
    }

    private void error(String s) throws CommandSyntaxException {
        throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)s)).create();
    }

    private void readSubRegionsFromNBT(class_2487 tag, int version, int minecraftDataVersion, boolean enableFixers) {
        for (String regionName : tag.method_10541()) {
            class_2520 nbtBase;
            class_2499 list;
            if (tag.method_10580(regionName).method_10711() != 10) continue;
            class_2487 regionTag = tag.method_68568(regionName);
            class_2338 regionPos = NbtUtils.readBlockPos(regionTag.method_68568("Position"));
            class_2338 regionSize = NbtUtils.readBlockPos(regionTag.method_68568("Size"));
            Map<class_2338, class_2487> tiles = null;
            if (regionPos == null || regionSize == null) continue;
            this.subRegionPositions.put(regionName, regionPos);
            this.subRegionSizes.put(regionName, regionSize);
            if (version >= 2) {
                tiles = this.readTileEntitiesFromNBT(regionTag.method_68569("TileEntities"));
                if (enableFixers) {
                    tiles = this.convertTileEntities_to_1_20_5(tiles, minecraftDataVersion);
                }
                this.tileEntities.put(regionName, tiles);
                class_2499 entities = regionTag.method_68569("Entities");
                if (enableFixers) {
                    entities = this.convertEntities_to_1_20_5(entities, minecraftDataVersion);
                }
                this.entities.put(regionName, this.readEntitiesFromNBT(entities));
            } else if (version == 1) {
                tiles = this.readTileEntitiesFromNBT_v1(regionTag.method_68569("TileEntities"));
                this.tileEntities.put(regionName, tiles);
                this.entities.put(regionName, this.readEntitiesFromNBT_v1(regionTag.method_68569("Entities")));
            }
            if (version >= 3) {
                list = regionTag.method_68569("PendingBlockTicks");
                this.pendingBlockTicks.put(regionName, this.readPendingTicksFromNBT(list, (class_2378)class_7923.field_41175, "Block", (Object)class_2246.field_10124));
            }
            if (version >= 5) {
                list = regionTag.method_68569("PendingFluidTicks");
                this.pendingFluidTicks.put(regionName, this.readPendingTicksFromNBT(list, (class_2378)class_7923.field_41173, "Fluid", (Object)class_3612.field_15906));
            }
            if ((nbtBase = regionTag.method_10580("BlockStates")) == null || nbtBase.method_10711() != 12) continue;
            class_2499 palette = regionTag.method_68569("BlockStatePalette");
            long[] blockStateArr = ((class_2501)nbtBase).method_10615();
            class_2338 posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((class_2382)regionSize).method_10081((class_2382)regionPos);
            class_2338 posMin = PositionUtils.getMinCorner(regionPos, posEndRel);
            class_2338 posMax = PositionUtils.getMaxCorner(regionPos, posEndRel);
            class_2338 size = posMax.method_10059((class_2382)posMin).method_10069(1, 1, 1);
            if (enableFixers) {
                palette = this.convertBlockStatePalette_to_1_20_5(palette, minecraftDataVersion);
            }
            LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createFrom(palette, blockStateArr, size);
            if (minecraftDataVersion < MINECRAFT_DATA_VERSION && enableFixers) {
                this.postProcessContainerIfNeeded(palette, container, tiles);
            }
            this.blockContainers.put(regionName, container);
        }
    }

    public static boolean isSizeValid(@Nullable class_2382 size) {
        return size != null && size.method_10263() > 0 && size.method_10264() > 0 && size.method_10260() > 0;
    }

    @Nullable
    private static class_2382 readSizeFromTagImpl(class_2487 tag) {
        class_2499 tagList;
        if (tag.method_10545("size") && (tagList = tag.method_68569("size")).size() == 3) {
            return new class_2382(tagList.method_68576(0, 0), tagList.method_68576(1, 0), tagList.method_68576(2, 0));
        }
        return null;
    }

    @Nullable
    public static class_2338 readBlockPosFromNbtList(class_2487 tag, String tagName) {
        class_2499 tagList;
        if (tag.method_10545(tagName) && (tagList = tag.method_68569(tagName)).size() == 3) {
            return new class_2338(tagList.method_68576(0, 0), tagList.method_68576(1, 0), tagList.method_68576(2, 0));
        }
        return null;
    }

    protected boolean readPaletteFromLitematicaFormatTag(class_2499 tagList, ILitematicaBlockStatePalette palette) {
        int size = tagList.size();
        ArrayList<class_2680> list = new ArrayList<class_2680>(size);
        class_2378 lookup = DataProviderManager.INSTANCE.getRegistryManager().method_30530(class_7924.field_41254);
        for (int id = 0; id < size; ++id) {
            class_2487 tag = tagList.method_68582(id);
            class_2680 state = class_2512.method_10681((class_7871)lookup, (class_2487)tag);
            list.add(state);
        }
        return palette.setMapping(list);
    }

    public static boolean isValidSpongeSchematic(class_2487 tag) {
        if (tag.method_10545("Width") && tag.method_10545("Height") && tag.method_10545("Length") && tag.method_10545("Version") && tag.method_10545("Palette") && tag.method_10545("BlockData")) {
            return LitematicaSchematic.isSizeValid(LitematicaSchematic.readSizeFromTagSponge(tag));
        }
        return false;
    }

    public static boolean isValidSpongeSchematicv3(class_2487 tag) {
        class_2487 nbtV3;
        if (tag.method_10545("Schematic") && (nbtV3 = tag.method_68568("Schematic")).method_10545("Width") && nbtV3.method_10545("Height") && nbtV3.method_10545("Length") && nbtV3.method_10545("Version") && nbtV3.method_68083("Version", -1) >= 3 && nbtV3.method_10545("Blocks") && nbtV3.method_10545("DataVersion")) {
            return LitematicaSchematic.isSizeValid(LitematicaSchematic.readSizeFromTagSponge(nbtV3));
        }
        return false;
    }

    public static class_2382 readSizeFromTagSponge(class_2487 tag) {
        return new class_2382(tag.method_68083("Width", 0), tag.method_68083("Height", 0), tag.method_68083("Length", 0));
    }

    protected boolean readSpongePaletteFromTag(class_2487 tag, ILitematicaBlockStatePalette palette) {
        int size = tag.method_10541().size();
        ArrayList<class_2680> list = new ArrayList<class_2680>(size);
        class_2680 air = class_2246.field_10124.method_9564();
        for (int i = 0; i < size; ++i) {
            list.add(air);
        }
        for (String key : tag.method_10541()) {
            class_2680 state;
            int id = tag.method_68083(key, 0);
            Optional<class_2680> stateOptional = BlockUtils.getBlockStateFromString(key);
            if (stateOptional.isPresent()) {
                state = stateOptional.get();
            } else {
                Servux.LOGGER.warn("Unknown block in the Sponge schematic palette: '{}'", (Object)key);
                state = LitematicaBlockStateContainer.AIR_BLOCK_STATE;
            }
            if (id < 0 || id >= size) {
                Servux.LOGGER.error("Invalid ID in the Sponge schematic palette: '{}'", (Object)id);
                return false;
            }
            list.set(id, state);
        }
        return palette.setMapping(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean readSpongeBlocksFromTag(class_2487 tag, String schematicName, class_2382 size, int minecraftDataVersion, int spongeVersion) {
        int paletteSize;
        byte[] blockData;
        class_2487 paletteTag;
        class_2487 blocksTag = new class_2487();
        if (spongeVersion >= 3 && tag.method_10545("Blocks")) {
            blocksTag = tag.method_68568("Blocks");
            if (!blocksTag.method_10545("Palette") || !blocksTag.method_10545("Data")) return false;
            paletteTag = blocksTag.method_68568("Palette");
            blockData = blocksTag.method_10547("Data").orElse(new byte[0]);
            paletteSize = paletteTag.method_10541().size();
        } else {
            if (!tag.method_10545("Palette") || !tag.method_10545("BlockData")) return false;
            paletteTag = tag.method_68568("Palette");
            blockData = tag.method_10547("BlockData").orElse(new byte[0]);
            paletteSize = paletteTag.method_10541().size();
        }
        LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createContainer(paletteSize, blockData, size);
        if (container == null) {
            Servux.LOGGER.error("Failed to read blocks from Sponge schematic");
            return false;
        }
        this.blockContainers.put(schematicName, container);
        if (!this.readSpongePaletteFromTag(paletteTag, container.getPalette())) {
            return false;
        }
        if (spongeVersion < 3) return true;
        if (blocksTag.method_33133()) return false;
        Map<class_2338, class_2487> tileEntities = this.readSpongeBlockEntitiesFromTag(blocksTag, spongeVersion);
        this.tileEntities.put(schematicName, tileEntities);
        return true;
    }

    protected Map<class_2338, class_2487> readSpongeBlockEntitiesFromTag(class_2487 tag, int spongeVersion) {
        String tagName;
        HashMap<class_2338, class_2487> blockEntities = new HashMap<class_2338, class_2487>();
        String string = tagName = spongeVersion == 1 ? "TileEntities" : "BlockEntities";
        if (!tag.method_10545(tagName)) {
            return blockEntities;
        }
        class_2499 tagList = tag.method_68569(tagName);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            class_2487 beTag = tagList.method_68582(i);
            class_2338 pos = NbtUtils.readBlockPosFromArrayTag(beTag, "Pos");
            if (pos == null || beTag.method_33133()) continue;
            beTag.method_10582("id", beTag.method_68564("Id", ""));
            beTag.method_10551("Id");
            beTag.method_10551("Pos");
            if (spongeVersion == 1) {
                beTag.method_10551("ContentVersion");
            }
            if (spongeVersion >= 3) {
                class_2487 beData = beTag.method_68568("Data");
                blockEntities.put(pos, beData);
                continue;
            }
            blockEntities.put(pos, beTag);
        }
        return blockEntities;
    }

    protected List<EntityInfo> readSpongeEntitiesFromTag(class_2487 tag, class_2382 offset, int spongeVersion) {
        ArrayList<EntityInfo> entities = new ArrayList<EntityInfo>();
        class_2499 tagList = tag.method_68569("Entities");
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            class_2487 entityEntry = tagList.method_68582(i);
            class_243 pos = NbtUtils.getVec3dCodec(entityEntry, "Pos");
            if (pos == null || entityEntry.method_33133()) continue;
            entityEntry.method_10582("id", entityEntry.method_68564("Id", ""));
            entityEntry.method_10551("Id");
            if (spongeVersion >= 3) {
                class_2487 entityData = entityEntry.method_68568("Data");
                if (!entityData.method_10545("id")) {
                    entityData.method_10582("id", entityEntry.method_68564("id", ""));
                }
                entities.add(new EntityInfo(pos, entityData));
                continue;
            }
            pos = new class_243(pos.field_1352 - (double)offset.method_10263(), pos.field_1351 - (double)offset.method_10264(), pos.field_1350 - (double)offset.method_10260());
            entities.add(new EntityInfo(pos, entityEntry));
        }
        return entities;
    }

    public boolean readFromSpongeSchematic(String name, class_2487 tag) {
        if (LitematicaSchematic.isValidSpongeSchematicv3(tag)) {
            class_2487 spongeTag = tag.method_68568("Schematic");
            tag.method_10551("Schematic");
            tag.method_10543(spongeTag);
        } else if (!LitematicaSchematic.isValidSpongeSchematic(tag)) {
            return false;
        }
        int spongeVersion = tag.method_10545("Version") ? tag.method_68083("Version", -1) : -1;
        int minecraftDataVersion = tag.method_10545("DataVersion") ? tag.method_68083("DataVersion", 1139) : 1139;
        class_2382 size = LitematicaSchematic.readSizeFromTagSponge(tag);
        if (!this.readSpongeBlocksFromTag(tag, name, size, minecraftDataVersion, spongeVersion)) {
            return false;
        }
        class_2382 offset = NbtUtils.readVec3iFromIntArray(tag, "Offset");
        if (offset == null) {
            offset = class_2382.field_11176;
        }
        if (spongeVersion < 3) {
            Map<class_2338, class_2487> tileEntities = this.readSpongeBlockEntitiesFromTag(tag, spongeVersion);
            this.tileEntities.put(name, tileEntities);
        }
        List<EntityInfo> entities = this.readSpongeEntitiesFromTag(tag, offset, spongeVersion);
        this.entities.put(name, entities);
        if (tag.method_10545("Metadata")) {
            class_2487 metadata = tag.method_68568("Metadata");
            this.metadata.setName(metadata.method_10545("Name") ? metadata.method_68564("Name", "?") : name);
            this.metadata.setAuthor(metadata.method_10545("Author") ? metadata.method_68564("Author", "?") : "unknown");
            this.metadata.setTimeCreated(metadata.method_10545("Date") ? metadata.method_68080("Date", System.currentTimeMillis()) : System.currentTimeMillis());
        } else {
            this.metadata.setAuthor("unknown");
            this.metadata.setName(name);
            this.metadata.setTimeCreated(System.currentTimeMillis());
        }
        if (tag.method_10545("author")) {
            this.metadata.setAuthor(tag.method_68564("author", "?"));
        }
        this.subRegionPositions.put(name, class_2338.field_10980);
        this.subRegionSizes.put(name, new class_2338(size));
        this.metadata.setRegionCount(1);
        this.metadata.setTotalVolume(size.method_10263() * size.method_10264() * size.method_10260());
        this.metadata.setEnclosingSize(size);
        this.metadata.setTimeModified(this.metadata.getTimeCreated());
        this.metadata.setTotalBlocks(this.totalBlocksReadFromWorld);
        this.metadata.setSchematicVersion(spongeVersion);
        this.metadata.setMinecraftDataVersion(minecraftDataVersion);
        this.metadata.setFileType(FileType.SPONGE_SCHEMATIC);
        return true;
    }

    public boolean readFromVanillaStructure(String name, class_2487 tag) {
        class_2382 size = LitematicaSchematic.readSizeFromTagImpl(tag);
        if (tag.method_10545("palette") && tag.method_10545("blocks") && LitematicaSchematic.isSizeValid(size)) {
            class_2499 paletteTag = tag.method_68569("palette");
            int minecraftDataVersion = tag.method_10545("DataVersion") ? tag.method_68083("DataVersion", 1139) : 1139;
            HashMap<class_2338, class_2487> tileMap = new HashMap<class_2338, class_2487>();
            this.tileEntities.put(name, tileMap);
            class_2680 air = class_2246.field_10124.method_9564();
            int paletteSize = paletteTag.size();
            ArrayList<class_2680> list = new ArrayList<class_2680>(paletteSize);
            class_2378 lookup = DataProviderManager.INSTANCE.getRegistryManager().method_30530(class_7924.field_41254);
            if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
                Servux.LOGGER.info("VanillaStructure: executing Vanilla DataFixer for Block State Palette DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            }
            for (int id = 0; id < paletteSize; ++id) {
                class_2487 t = paletteTag.method_68582(id);
                if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
                    t = SchematicConversionMaps.updateBlockStates(t, minecraftDataVersion);
                }
                class_2680 state = class_2512.method_10681((class_7871)lookup, (class_2487)t);
                list.add(state);
            }
            class_2680 zeroState = (class_2680)list.get(0);
            int airId = -1;
            for (int i = 0; i < paletteSize; ++i) {
                if (list.get(i) != air) continue;
                airId = i;
                break;
            }
            if (airId != 0) {
                if (airId == -1) {
                    list.add(0, air);
                    ++paletteSize;
                } else {
                    list.set(0, air);
                    list.set(airId, zeroState);
                }
            }
            int bits = Math.max(2, 32 - Integer.numberOfLeadingZeros(paletteSize - 1));
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(size.method_10263(), size.method_10264(), size.method_10260(), bits, null);
            ILitematicaBlockStatePalette palette = container.getPalette();
            palette.setMapping(list);
            this.blockContainers.put(name, container);
            if (tag.method_10545("author")) {
                this.getMetadata().setAuthor(tag.method_68564("author", "?"));
            }
            this.subRegionPositions.put(name, class_2338.field_10980);
            this.subRegionSizes.put(name, new class_2338(size));
            this.metadata.setName(name);
            this.metadata.setRegionCount(1);
            this.metadata.setTotalVolume(size.method_10263() * size.method_10264() * size.method_10260());
            this.metadata.setEnclosingSize(size);
            this.metadata.setTimeCreated(System.currentTimeMillis());
            this.metadata.setTimeModified(this.metadata.getTimeCreated());
            this.metadata.setSchematicVersion(0);
            this.metadata.setMinecraftDataVersion(minecraftDataVersion);
            this.metadata.setFileType(FileType.VANILLA_STRUCTURE);
            class_2499 blockList = tag.method_68569("blocks");
            int count = blockList.size();
            int totalBlocks = 0;
            for (int i = 0; i < count; ++i) {
                class_2487 blockTag = blockList.method_68582(i);
                class_2338 pos = LitematicaSchematic.readBlockPosFromNbtList(blockTag, "pos");
                if (pos == null) {
                    Servux.LOGGER.error("Failed to read block position for vanilla structure");
                    return false;
                }
                int id = blockTag.method_68083("state", 0);
                class_2680 state = airId == -1 ? palette.getBlockState(id + 1) : (airId != 0 ? (id == 0 ? zeroState : (id == airId ? air : palette.getBlockState(id))) : palette.getBlockState(id));
                if (state == null) {
                    state = air;
                } else if (state != air) {
                    ++totalBlocks;
                }
                container.set(pos.method_10263(), pos.method_10264(), pos.method_10260(), state);
                if (!blockTag.method_10545("nbt")) continue;
                tileMap.put(pos, blockTag.method_68568("nbt"));
            }
            this.metadata.setTotalBlocks(totalBlocks);
            this.entities.put(name, this.readEntitiesFromVanillaStructure(tag, minecraftDataVersion));
            return true;
        }
        return false;
    }

    protected List<EntityInfo> readEntitiesFromVanillaStructure(class_2487 tag, int minecraftDataVersion) {
        ArrayList<EntityInfo> entities = new ArrayList<EntityInfo>();
        class_2499 tagList = tag.method_68569("entities");
        int size = tagList.size();
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            Servux.LOGGER.info("VanillaStructure: executing Vanilla DataFixer for Entities DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
        }
        for (int i = 0; i < size; ++i) {
            class_243 pos;
            class_2487 entityData = tagList.method_68582(i);
            if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
                entityData = SchematicConversionMaps.updateEntity(entityData, minecraftDataVersion);
            }
            if ((pos = LitematicaSchematic.readVec3dFromNbtList(entityData, "pos")) == null || !entityData.method_10545("nbt")) continue;
            entities.add(new EntityInfo(pos, entityData.method_68568("nbt")));
        }
        return entities;
    }

    @Nullable
    public static class_243 readVec3dFromNbtList(@Nullable class_2487 tag, String tagName) {
        class_2499 tagList;
        if (tag != null && tag.method_10545(tagName) && (tagList = tag.method_68569(tagName)).method_10711() == 6 && tagList.size() == 3) {
            return new class_243(tagList.method_68574(0, 0.0), tagList.method_68574(1, 0.0), tagList.method_68574(2, 0.0));
        }
        return null;
    }

    private void postProcessContainerIfNeeded(class_2499 palette, LitematicaBlockStateContainer container, @Nullable Map<class_2338, class_2487> tiles) {
        List<class_2680> states = LitematicaSchematic.getStatesFromPaletteTag(palette);
    }

    public static List<class_2680> getStatesFromPaletteTag(class_2499 palette) {
        ArrayList<class_2680> states = new ArrayList<class_2680>();
        class_2378 lookup = DataProviderManager.INSTANCE.getRegistryManager().method_30530(class_7924.field_41254);
        int size = palette.size();
        for (int i = 0; i < size; ++i) {
            class_2487 tag = palette.method_68582(i);
            class_2680 state = class_2512.method_10681((class_7871)lookup, (class_2487)tag);
            if (i <= 0 && state == LitematicaBlockStateContainer.AIR_BLOCK_STATE) continue;
            states.add(state);
        }
        return states;
    }

    private List<EntityInfo> readEntitiesFromNBT(class_2499 tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            class_2487 entityData = tagList.method_68582(i);
            class_243 posVec = NbtUtils.getVec3dCodec(entityData, "Pos");
            if (posVec == null || entityData.method_33133()) continue;
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<class_2338, class_2487> readTileEntitiesFromNBT(class_2499 tagList) {
        HashMap<class_2338, class_2487> tileMap = new HashMap<class_2338, class_2487>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            class_2487 tag = tagList.method_68582(i);
            class_2338 pos = NbtUtils.readBlockPos(tag);
            if (pos == null || tag.method_33133()) continue;
            tileMap.put(pos, tag);
        }
        return tileMap;
    }

    private <T> Map<class_2338, class_6760<T>> readPendingTicksFromNBT(class_2499 tagList, class_2378<T> registry, String tagName, T emptyValue) {
        HashMap<class_2338, class_6760<T>> tickMap = new HashMap<class_2338, class_6760<T>>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            class_2487 tag = tagList.method_68582(i);
            if (!tag.method_10545("Time")) continue;
            Object target = null;
            try {
                target = registry.method_63535(class_2960.method_12829((String)tag.method_68564(tagName, "")));
                if (target == null || target == emptyValue) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (target == null) continue;
            class_2338 pos = new class_2338(tag.method_68083("x", 0), tag.method_68083("y", 0), tag.method_68083("z", 0));
            class_1953 priority = class_1953.method_8680((int)tag.method_68083("Priority", 0));
            int scheduledTime = tag.method_68083("Time", 0);
            long subTick = tag.method_68080("SubTick", 0L);
            tickMap.put(pos, new class_6760(target, pos, (long)scheduledTime, priority, subTick));
        }
        return tickMap;
    }

    private class_2499 convertBlockStatePalette_to_1_20_5(class_2499 oldPalette, int minecraftDataVersion) {
        if (minecraftDataVersion < 1139) {
            minecraftDataVersion = 1139;
        }
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            class_2499 newPalette = new class_2499();
            int count = oldPalette.size();
            Servux.LOGGER.info("LitematicaSchematic: executing Vanilla DataFixer for Block State Palette DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            for (int i = 0; i < count; ++i) {
                newPalette.add((Object)SchematicConversionMaps.updateBlockStates(oldPalette.method_68582(i), minecraftDataVersion));
            }
            return newPalette;
        }
        return oldPalette;
    }

    private Map<class_2338, class_2487> convertTileEntities_to_1_20_5(Map<class_2338, class_2487> oldTE, int minecraftDataVersion) {
        if (minecraftDataVersion < 1139) {
            minecraftDataVersion = 1139;
        }
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            HashMap<class_2338, class_2487> newTE = new HashMap<class_2338, class_2487>();
            Servux.LOGGER.info("LitematicaSchematic: executing Vanilla DataFixer for Tile Entities DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            for (class_2338 key : oldTE.keySet()) {
                newTE.put(key, SchematicConversionMaps.updateBlockEntity(SchematicConversionMaps.checkForIdTag(oldTE.get(key)), minecraftDataVersion));
            }
            return newTE;
        }
        return oldTE;
    }

    private class_2499 convertEntities_to_1_20_5(class_2499 oldEntitiesList, int minecraftDataVersion) {
        if (minecraftDataVersion < 1139) {
            minecraftDataVersion = 1139;
        }
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            class_2499 newEntitiesList = new class_2499();
            int size = oldEntitiesList.size();
            Servux.LOGGER.info("LitematicaSchematic: executing Vanilla DataFixer for Entities DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            for (int i = 0; i < size; ++i) {
                newEntitiesList.add((Object)SchematicConversionMaps.updateEntity(oldEntitiesList.method_68582(i), minecraftDataVersion));
            }
            return newEntitiesList;
        }
        return oldEntitiesList;
    }

    private List<EntityInfo> convertSpongeEntities_to_1_20_5(List<EntityInfo> oldEntitiesList, int minecraftDataVersion) {
        if (minecraftDataVersion < 1139) {
            minecraftDataVersion = 1139;
        }
        if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
            ArrayList<EntityInfo> newEntitiesList = new ArrayList<EntityInfo>();
            Servux.LOGGER.info("SpongeSchematic: executing Vanilla DataFixer for Entities DataVersion {} -> {}", (Object)minecraftDataVersion, (Object)MINECRAFT_DATA_VERSION);
            for (EntityInfo oldEntityInfo : oldEntitiesList) {
                newEntitiesList.add(new EntityInfo(oldEntityInfo.posVec, SchematicConversionMaps.updateEntity(oldEntityInfo.nbt, minecraftDataVersion)));
            }
            return newEntitiesList;
        }
        return oldEntitiesList;
    }

    private List<EntityInfo> readEntitiesFromNBT_v1(class_2499 tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            class_2487 tag = tagList.method_68582(i);
            class_243 posVec = NbtUtils.readVec3d(tag);
            class_2487 entityData = tag.method_68568("EntityData");
            if (posVec == null || entityData.method_33133()) continue;
            NbtUtils.putVec3dCodec(entityData, posVec, "Pos");
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<class_2338, class_2487> readTileEntitiesFromNBT_v1(class_2499 tagList) {
        HashMap<class_2338, class_2487> tileMap = new HashMap<class_2338, class_2487>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            class_2487 tag = tagList.method_68582(i);
            class_2487 tileNbt = tag.method_68568("TileNBT");
            class_2338 pos = NbtUtils.readBlockPos(tag);
            if (pos == null || tileNbt.method_33133()) continue;
            NbtUtils.writeBlockPosToTag((class_2382)pos, tileNbt);
            tileMap.put(pos, tileNbt);
        }
        return tileMap;
    }

    public boolean writeToFile(Path dir, String fileNameIn, boolean override) {
        return this.writeToFile(dir, fileNameIn, override, false);
    }

    public boolean writeToFile(Path dir, String fileNameIn, boolean override, boolean downgrade) {
        Object fileName = fileNameIn;
        if (!((String)fileName).endsWith(FILE_EXTENSION)) {
            fileName = (String)fileName + FILE_EXTENSION;
        }
        Path fileSchematic = dir.resolve((String)fileName);
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                return false;
            }
            if (!override && Files.exists(fileSchematic, new LinkOption[0])) {
                return false;
            }
            NbtUtils.writeCompressed(this.writeToNBT(), fileSchematic);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean readFromFile() {
        return this.readFromFile(this.schematicType);
    }

    private boolean readFromFile(FileType schematicType) {
        try {
            class_2487 nbt = LitematicaSchematic.readNbtFromFile(this.schematicFile);
            if (nbt != null) {
                if (schematicType == FileType.SPONGE_SCHEMATIC) {
                    String name = FileUtils.getNameWithoutExtension(this.schematicFile.getFileName().toString()) + " (Converted Sponge)";
                    return this.readFromSpongeSchematic(name, nbt);
                }
                if (schematicType == FileType.VANILLA_STRUCTURE) {
                    String name = FileUtils.getNameWithoutExtension(this.schematicFile.getFileName().toString()) + " (Converted Structure)";
                    return this.readFromVanillaStructure(name, nbt);
                }
                if (schematicType == FileType.LITEMATICA_SCHEMATIC) {
                    return this.readFromNBT(nbt, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static class_2487 readNbtFromFile(Path file) {
        if (file == null) {
            return null;
        }
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        return NbtUtils.readNbtFromFileAsPath(file);
    }

    public static Path fileFromDirAndName(Path dir, String fileName, FileType schematicType) {
        if (!((String)fileName).endsWith(FILE_EXTENSION) && schematicType == FileType.LITEMATICA_SCHEMATIC) {
            fileName = (String)fileName + FILE_EXTENSION;
        }
        return dir.resolve((String)fileName);
    }

    @Nullable
    public static LitematicaSchematic createFromFile(Path dir, String fileName) {
        return LitematicaSchematic.createFromFile(dir, fileName, FileType.LITEMATICA_SCHEMATIC);
    }

    @Nullable
    public static LitematicaSchematic createFromFile(Path dir, String fileName, FileType schematicType) {
        Path file = LitematicaSchematic.fileFromDirAndName(dir, fileName, schematicType);
        LitematicaSchematic schematic = new LitematicaSchematic(file, schematicType);
        return schematic.readFromFile(schematicType) ? schematic : null;
    }

    public static class SchematicSaveInfo {
        public final boolean visibleOnly;
        public final boolean includeSupportBlocks;
        public final boolean ignoreEntities;
        public final boolean fromSchematicWorld;

        public SchematicSaveInfo(boolean visibleOnly, boolean ignoreEntities) {
            this(visibleOnly, false, ignoreEntities, false);
        }

        public SchematicSaveInfo(boolean visibleOnly, boolean includeSupportBlocks, boolean ignoreEntities, boolean fromSchematicWorld) {
            this.visibleOnly = visibleOnly;
            this.includeSupportBlocks = includeSupportBlocks;
            this.ignoreEntities = ignoreEntities;
            this.fromSchematicWorld = fromSchematicWorld;
        }
    }

    public static class EntityInfo {
        public final class_243 posVec;
        public final class_2487 nbt;

        public EntityInfo(class_243 posVec, class_2487 nbt) {
            this.posVec = posVec;
            if (nbt.method_10545("SleepingX")) {
                nbt.method_10569("SleepingX", class_3532.method_15357((double)posVec.field_1352));
            }
            if (nbt.method_10545("SleepingY")) {
                nbt.method_10569("SleepingY", class_3532.method_15357((double)posVec.field_1351));
            }
            if (nbt.method_10545("SleepingZ")) {
                nbt.method_10569("SleepingZ", class_3532.method_15357((double)posVec.field_1350));
            }
            this.nbt = nbt;
        }
    }
}

