/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.util;

import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class BlockUtils {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static Optional<class_2754<class_2350>> getFirstDirectionProperty(class_2680 state) {
        for (class_2769 prop : state.method_28501()) {
            class_2754 ep;
            if (!(prop instanceof class_2754) || !(ep = (class_2754)prop).method_11902().equals(class_2350.class)) continue;
            return Optional.of(ep);
        }
        return Optional.empty();
    }

    public static Optional<class_2350> getFirstPropertyFacingValue(class_2680 state) {
        Optional<class_2754<class_2350>> propOptional = BlockUtils.getFirstDirectionProperty(state);
        return propOptional.map(directionProperty -> class_2350.method_10168((String)((class_2350)state.method_11654((class_2769)directionProperty)).method_10151()));
    }

    @Nullable
    public static class_2350 getPropertyFacingValue(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12525) ? (class_2350)state.method_11654((class_2769)class_2741.field_12525) : null;
    }

    public static class_2680 fixMirrorDoubleChest(class_2680 state, class_2415 mirror, class_2745 type) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2281.field_10768);
        class_2350.class_2351 axis = facing.method_10166();
        if (mirror == class_2415.field_11301) {
            state = (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)type.method_11824());
            if (axis == class_2350.class_2351.field_11048) {
                state = (class_2680)state.method_11657((class_2769)class_2281.field_10768, (Comparable)facing.method_10153());
            }
        } else if (mirror == class_2415.field_11300) {
            state = (class_2680)state.method_11657((class_2769)class_2281.field_10770, (Comparable)type.method_11824());
            if (axis == class_2350.class_2351.field_11051) {
                state = (class_2680)state.method_11657((class_2769)class_2281.field_10768, (Comparable)facing.method_10153());
            }
        }
        return state;
    }

    public static Optional<class_2680> getBlockStateFromString(String str) {
        int index = str.indexOf("[");
        String blockName = index != -1 ? str.substring(0, index) : str;
        try {
            Optional opt;
            class_2960 id = class_2960.method_12829((String)blockName);
            if (class_7923.field_41175.method_10250(id) && (opt = class_7923.field_41175.method_10223(id)).isPresent()) {
                class_2248 block = (class_2248)((class_6880.class_6883)opt.get()).comp_349();
                class_2680 state = block.method_9564();
                if (index != -1 && str.length() > index + 4 && str.charAt(str.length() - 1) == ']') {
                    class_2689 stateManager = block.method_9595();
                    String propStr = str.substring(index + 1, str.length() - 1);
                    for (String propAndVal : COMMA_SPLITTER.split((CharSequence)propStr)) {
                        Object val;
                        class_2769 prop;
                        Iterator valIter = EQUAL_SPLITTER.split((CharSequence)propAndVal).iterator();
                        if (!valIter.hasNext() || (prop = stateManager.method_11663((String)valIter.next())) == null || !valIter.hasNext() || (val = BlockUtils.getPropertyValueByName(prop, (String)valIter.next())) == null) continue;
                        state = BlockUtils.getBlockStateWithProperty(state, prop, val);
                    }
                }
                return Optional.of(state);
            }
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static <T extends Comparable<T>> class_2680 getBlockStateWithProperty(class_2680 state, class_2769<T> prop, Comparable<?> value) {
        return (class_2680)state.method_11657(prop, value);
    }

    @Nullable
    public static <T extends Comparable<T>> T getPropertyValueByName(class_2769<T> prop, String valStr) {
        return (T)((Comparable)prop.method_11900(valStr).orElse(null));
    }
}

