/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.util.nbt;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import fi.dy.masa.servux.Servux;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_4844;

public class NbtUtils {
    @Nullable
    public static UUID getUUIDCodec(@Nonnull class_2487 nbt) {
        return NbtUtils.getUUIDCodec(nbt, "UUID");
    }

    @Nullable
    public static UUID getUUIDCodec(@Nonnull class_2487 nbt, String key) {
        if (nbt.method_10545(key)) {
            return nbt.method_67491(key, class_4844.field_25122).orElse(null);
        }
        return null;
    }

    public static class_2487 putUUIDCodec(@Nonnull class_2487 nbtIn, @Nonnull UUID uuid, String key) {
        nbtIn.method_67494(key, class_4844.field_25122, (Object)uuid);
        return nbtIn;
    }

    @Nonnull
    public static class_2487 putVec2fCodec(@Nonnull class_2487 tag, @Nonnull class_241 pos, String key) {
        tag.method_67494(key, class_241.field_56695, (Object)pos);
        return tag;
    }

    @Nonnull
    public static class_2487 putVec3iCodec(@Nonnull class_2487 tag, @Nonnull class_2382 pos, String key) {
        tag.method_67494(key, class_2382.field_25123, (Object)pos);
        return tag;
    }

    @Nonnull
    public static class_2487 putVec3dCodec(@Nonnull class_2487 tag, @Nonnull class_243 pos, String key) {
        tag.method_67494(key, class_243.field_38277, (Object)pos);
        return tag;
    }

    @Nonnull
    public static class_2487 putPosCodec(@Nonnull class_2487 tag, @Nonnull class_2338 pos, String key) {
        tag.method_67494(key, class_2338.field_25064, (Object)pos);
        return tag;
    }

    public static class_241 getVec2fCodec(@Nonnull class_2487 tag, String key) {
        return tag.method_67491(key, class_241.field_56695).orElse(class_241.field_1340);
    }

    public static class_2382 getVec3iCodec(@Nonnull class_2487 tag, String key) {
        return tag.method_67491(key, class_2382.field_25123).orElse(class_2382.field_11176);
    }

    public static class_243 getVec3dCodec(@Nonnull class_2487 tag, String key) {
        return tag.method_67491(key, class_243.field_38277).orElse(class_243.field_1353);
    }

    public static class_2338 getPosCodec(@Nonnull class_2487 tag, String key) {
        return tag.method_67491(key, class_2338.field_25064).orElse(class_2338.field_10980);
    }

    @Nonnull
    public static class_2487 writeVec3iToArray(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static class_2487 writeVec3iToArrayTag(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static class_2487 writeBlockPosToArrayTag(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        int[] arr = new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
        tag.method_10539(tagName, arr);
        return tag;
    }

    @Nullable
    public static class_2338 readBlockPosFromIntArray(@Nonnull class_2487 nbt, String key) {
        return NbtUtils.readBlockPosFromArrayTag(nbt, key);
    }

    @Nullable
    public static class_2338 readBlockPosFromArrayTag(@Nonnull class_2487 tag, String tagName) {
        int[] pos;
        if (tag.method_10545(tagName) && (pos = tag.method_10561(tagName).orElse(new int[0])).length == 3) {
            return new class_2338(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static class_2382 readVec3iFromIntArray(@Nonnull class_2487 nbt, String key) {
        return NbtUtils.readVec3iFromIntArrayTag(nbt, key);
    }

    @Nullable
    public static class_2382 readVec3iFromIntArrayTag(@Nonnull class_2487 tag, String tagName) {
        int[] pos;
        if (tag.method_10545(tagName) && (pos = tag.method_10561(tagName).orElse(new int[0])).length == 3) {
            return new class_2382(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    public static class_2487 createBlockPosTag(class_2382 pos) {
        return NbtUtils.writeBlockPosToTag(pos, new class_2487());
    }

    public static class_2487 writeBlockPosToTag(class_2382 pos, class_2487 tag) {
        tag.method_10569("x", pos.method_10263());
        tag.method_10569("y", pos.method_10264());
        tag.method_10569("z", pos.method_10260());
        return tag;
    }

    @Nullable
    public static class_2338 readBlockPos(@Nullable class_2487 tag) {
        if (tag != null && tag.method_10545("x") && tag.method_10545("y") && tag.method_10545("z")) {
            return new class_2338(tag.method_68083("x", 0), tag.method_68083("y", 0), tag.method_68083("z", 0));
        }
        return null;
    }

    public static class_2487 writeVec3dToTag(class_243 vec, class_2487 tag) {
        tag.method_10549("dx", vec.field_1352);
        tag.method_10549("dy", vec.field_1351);
        tag.method_10549("dz", vec.field_1350);
        return tag;
    }

    public static class_2487 writeEntityPositionToTag(class_243 pos, class_2487 tag) {
        class_2499 posList = new class_2499();
        posList.add((Object)class_2489.method_23241((double)pos.field_1352));
        posList.add((Object)class_2489.method_23241((double)pos.field_1351));
        posList.add((Object)class_2489.method_23241((double)pos.field_1350));
        tag.method_10566("Pos", (class_2520)posList);
        return tag;
    }

    @Nullable
    public static class_243 readVec3d(@Nullable class_2487 tag) {
        if (tag != null && tag.method_10545("dx") && tag.method_10545("dy") && tag.method_10545("dz")) {
            return new class_243(tag.method_68563("dx", 0.0), tag.method_68563("dy", 0.0), tag.method_68563("dz", 0.0));
        }
        return null;
    }

    @Nullable
    public static class_243 readEntityPositionFromTag(@Nullable class_2487 tag) {
        class_2499 tagList;
        if (tag != null && tag.method_10545("Pos") && (tagList = tag.method_68569("Pos")).method_10711() == 6 && tagList.size() == 3) {
            return new class_243(tagList.method_68574(0, 0.0), tagList.method_68574(1, 0.0), tagList.method_68574(2, 0.0));
        }
        return null;
    }

    @Nullable
    public static class_2382 readVec3iFromTag(@Nullable class_2487 tag) {
        if (tag != null && tag.method_10545("x") && tag.method_10545("y") && tag.method_10545("z")) {
            return new class_2382(tag.method_68083("x", 0), tag.method_68083("y", 0), tag.method_68083("z", 0));
        }
        return null;
    }

    @Nullable
    public static class_2487 readNbtFromFileAsPath(@Nonnull Path file) {
        return NbtUtils.readNbtFromFileAsPath(file, class_2505.method_53898());
    }

    @Nullable
    public static class_2487 readNbtFromFileAsPath(@Nonnull Path file, class_2505 tracker) {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        try {
            return class_2507.method_10629((InputStream)Files.newInputStream(file, new OpenOption[0]), (class_2505)tracker);
        }
        catch (Exception e) {
            Servux.LOGGER.warn("readNbtFromFileAsPath: Failed to read NBT data from file '{}'", (Object)file.toString());
            return null;
        }
    }

    public static void writeCompressed(@Nonnull class_2487 tag, @Nonnull OutputStream outputStream) {
        try {
            class_2507.method_10634((class_2487)tag, (OutputStream)outputStream);
        }
        catch (Exception err) {
            Servux.LOGGER.warn("writeCompressed: Failed to write NBT data to output stream");
        }
    }

    public static void writeCompressed(@Nonnull class_2487 tag, @Nonnull Path file) {
        try {
            class_2507.method_30614((class_2487)tag, (Path)file);
        }
        catch (Exception err) {
            Servux.LOGGER.warn("writeCompressed: Failed to write NBT data to file");
        }
    }

    public static <T> Optional<T> readFlatMap(@Nonnull class_2487 nbt, MapCodec<T> mapCodec) {
        class_2509 ops = class_2509.field_11560;
        DataResult dataResult = ops.getMap((Object)nbt).flatMap(arg_0 -> NbtUtils.lambda$readFlatMap$0(mapCodec, (DynamicOps)ops, arg_0));
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            case 0 -> {
                DataResult.Success result = (DataResult.Success)dataResult2;
                yield Optional.of(result.value());
            }
            case 1 -> {
                DataResult.Error error = (DataResult.Error)dataResult2;
                yield error.partialValue();
            }
            default -> Optional.empty();
        };
    }

    public static <T> class_2487 writeFlatMap(MapCodec<T> mapCodec, T value) {
        class_2509 ops = class_2509.field_11560;
        class_2487 nbt = new class_2487();
        DataResult dataResult = mapCodec.encoder().encodeStart((DynamicOps)ops, value);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success result = (DataResult.Success)dataResult2;
                nbt.method_10543((class_2487)result.value());
                break;
            }
            case 1: {
                DataResult.Error error = (DataResult.Error)dataResult2;
                error.partialValue().ifPresent(partial -> nbt.method_10543((class_2487)partial));
            }
        }
        return nbt;
    }

    private static /* synthetic */ DataResult lambda$readFlatMap$0(MapCodec mapCodec, DynamicOps ops, MapLike map) {
        return mapCodec.decode(ops, map);
    }
}

