/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fi.dy.masa.servux.dataproviders.DataProviderManager;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.dataproviders.ServuxConfigProvider;
import fi.dy.masa.servux.interfaces.IServerCommand;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class ServuxCommand
implements IServerCommand {
    public static final ServuxCommand INSTANCE = new ServuxCommand();

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"servux").requires(Permissions.require((String)"servux.commands", (int)4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"servux.commands.reload", (int)4))).executes(ctx -> {
            ServuxConfigProvider.INSTANCE.doReloadConfig((class_2168)ctx.getSource());
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save").requires(Permissions.require((String)"servux.commands.save", (int)4))).executes(ctx -> {
            ServuxConfigProvider.INSTANCE.doSaveConfig((class_2168)ctx.getSource());
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(Permissions.require((String)"servux.commands.set", (int)4))).then(this.settingsNode().then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> {
            class_2960 settingId = (class_2960)ctx.getArgument("setting", class_2960.class);
            String settingName = StringUtils.removeDefaultMinecraftNamespace(settingId);
            IServuxSetting<?> setting = DataProviderManager.INSTANCE.getSettingByName(settingName);
            if (setting != null) {
                return class_2172.method_9265(setting.examples(), (SuggestionsBuilder)builder);
            }
            return builder.buildFuture();
        }).executes(ServuxCommand::configModify))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(Permissions.require((String)"servux.commands.info", (int)4))).then(this.settingsNode().executes(ServuxCommand::configInfo)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"servux.commands.list", (int)4))).executes(ctx -> this.configList((CommandContext<class_2168>)ctx, DataProviderManager.INSTANCE.getAllProviders().stream().flatMap(iDataProvider -> iDataProvider.getSettings().stream()).toList()))).then(class_2170.method_9244((String)"provider", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> class_2172.method_35510(DataProviderManager.INSTANCE.getAllProviders(), (SuggestionsBuilder)builder, IDataProvider::getName, iDataProvider -> class_2561.method_43470((String)iDataProvider.getDescription()).method_10852((class_2561)StringUtils.translate("servux.suffix.data_provider", new Object[0])))).executes(ctx -> {
            String provider = StringArgumentType.getString((CommandContext)ctx, (String)"provider");
            Optional<IDataProvider> dataProvider = DataProviderManager.INSTANCE.getProviderByName(provider);
            if (dataProvider.isEmpty()) {
                throw StringUtils.translateError("servux.command.error.unknown_data_provider", new Object[0]);
            }
            ((class_2168)ctx.getSource()).method_9226(() -> StringUtils.translate("servux.command.config.list.data_provider", provider), false);
            return this.configList((CommandContext<class_2168>)ctx, dataProvider.get().getSettings());
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"search").requires(Permissions.require((String)"servux.commands.list", (int)4))).then(class_2170.method_9244((String)"query", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String query = StringArgumentType.getString((CommandContext)ctx, (String)"query");
            List<IServuxSetting<?>> settings = this.configSearch((CommandContext<class_2168>)ctx, query);
            if (settings.isEmpty()) {
                ((class_2168)ctx.getSource()).method_9226(() -> StringUtils.translate("servux.command.search.none", query), false);
                return 0;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> StringUtils.translate("servux.command.search.results", settings.size(), query), false);
            return this.configList((CommandContext<class_2168>)ctx, settings);
        }))));
    }

    private List<IServuxSetting<?>> configSearch(CommandContext<class_2168> ctx, String query) {
        String[] searchParts = query.split(" ");
        return DataProviderManager.INSTANCE.getAllProviders().stream().flatMap(iDataProvider -> iDataProvider.getSettings().stream()).filter(iServuxSetting -> {
            for (String part : searchParts) {
                if (iServuxSetting.name().contains(part) || iServuxSetting.comment().getString().contains(part) || iServuxSetting.dataProvider().getName().contains(part)) continue;
                return false;
            }
            return true;
        }).toList();
    }

    private int configList(CommandContext<class_2168> ctx, List<IServuxSetting<?>> list) {
        if (list.isEmpty()) {
            ((class_2168)ctx.getSource()).method_9226(() -> StringUtils.translate("servux.command.error.no_settings", new Object[0]), false);
            return 0;
        }
        HashSet<String> appearedNames = new HashSet<String>();
        HashSet<String> appearedMultiTimes = new HashSet<String>();
        for (IServuxSetting<?> setting : list) {
            if (appearedNames.add(setting.name())) continue;
            appearedMultiTimes.add(setting.name());
        }
        for (IServuxSetting<?> setting : list) {
            ((class_2168)ctx.getSource()).method_9226(() -> {
                String value;
                class_5250 text = class_2561.method_43473();
                text.method_10852((class_2561)setting.shortDisplayName().method_27661().method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10609("/servux info " + setting.qualifiedName()))));
                if (appearedMultiTimes.contains(setting.name())) {
                    text.method_10852((class_2561)class_2561.method_43470((String)" (").method_10852(class_2561.method_30163((String)setting.dataProvider().getName())).method_27693(")").method_27692(class_124.field_1080));
                }
                if ((value = setting.valueToString(setting.getValue())).length() < 10) {
                    text.method_27693(": ").method_27693(value);
                }
                return text;
            }, false);
        }
        return list.size();
    }

    private ArgumentBuilder<class_2168, ?> settingsNode() {
        RequiredArgumentBuilder node = class_2170.method_9244((String)"setting", (ArgumentType)class_2232.method_9441());
        node.suggests((ctx, builder) -> {
            if (builder.getRemainingLowerCase().contains(":")) {
                String providerName = builder.getRemaining().split(":")[0];
                DataProviderManager.INSTANCE.getProviderByName(providerName).ifPresent(iDataProvider -> iDataProvider.getSettings().forEach(iServuxSetting -> builder.suggest(providerName + ":" + iServuxSetting.name(), (Message)iServuxSetting.prettyName())));
            } else {
                class_2172.method_35510(DataProviderManager.INSTANCE.getAllProviders().stream().flatMap(iDataProvider -> iDataProvider.getSettings().stream()).toList(), (SuggestionsBuilder)builder, IServuxSetting::name, IServuxSetting::prettyName);
                class_2172.method_35510(DataProviderManager.INSTANCE.getAllProviders(), (SuggestionsBuilder)builder, IDataProvider::getName, iDataProvider -> class_2561.method_43470((String)iDataProvider.getDescription()).method_10852((class_2561)StringUtils.translate("servux.suffix.data_provider", new Object[0])));
            }
            return builder.buildFuture();
        });
        return node;
    }

    private static int configInfo(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_2960 settingId = (class_2960)ctx.getArgument("setting", class_2960.class);
        String settingName = StringUtils.removeDefaultMinecraftNamespace(settingId);
        IServuxSetting<?> setting = DataProviderManager.INSTANCE.getSettingByName(settingName);
        if (setting == null) {
            throw StringUtils.translateError("servux.command.error.unknown_setting", new Object[0]);
        }
        ((class_2168)ctx.getSource()).method_9226(class_2561::method_43473, false);
        ((class_2168)ctx.getSource()).method_9226(() -> {
            class_5250 text = class_2561.method_43473();
            text.method_10852((class_2561)setting.prettyName().method_27661().method_27694(style -> style.method_10977(class_124.field_1054).method_10982(Boolean.valueOf(true))));
            text.method_27693(" (");
            text.method_10852((class_2561)class_2561.method_43470((String)setting.qualifiedName()).method_27694(style -> style.method_10977(class_124.field_1080).method_10949((class_2568)new class_2568.class_10613((class_2561)StringUtils.translate("servux.command.info.click_to_copy", new Object[0]))).method_10958((class_2558)new class_2558.class_10606(setting.qualifiedName()))));
            text.method_27693(")");
            return text;
        }, false);
        ((class_2168)ctx.getSource()).method_9226(() -> setting.comment().method_27661().method_27692(class_124.field_1080), false);
        ((class_2168)ctx.getSource()).method_9226(() -> {
            class_5250 text = StringUtils.translate("servux.command.info.value", setting.valueToString(setting.getValue())).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)StringUtils.translate("servux.command.info.click_to_set", setting.prettyName()))).method_10958((class_2558)new class_2558.class_10610("/servux set " + setting.qualifiedName() + " "))).method_27693(" ");
            if (Objects.equals(setting.getDefaultValue(), setting.getValue())) {
                text.method_10852((class_2561)StringUtils.translate("servux.command.suffix.default_value", new Object[0]).method_27692(class_124.field_1080));
            } else {
                text.method_10852((class_2561)StringUtils.translate("servux.command.suffix.modified", new Object[0]).method_27692(class_124.field_1060));
                text.method_27693(" ");
                text.method_10852((class_2561)StringUtils.translate("servux.command.info.reset", new Object[0]).method_27692(class_124.field_1080).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610("/servux set " + setting.qualifiedName() + " " + setting.valueToString(setting.getDefaultValue()))).method_10949((class_2568)new class_2568.class_10613((class_2561)StringUtils.translate("servux.command.info.click_to_reset_to", setting.valueToString(setting.getDefaultValue()))))));
            }
            return text;
        }, false);
        if (!setting.examples().isEmpty()) {
            class_5250 text = StringUtils.translate("servux.command.info.examples", new Object[0]);
            setting.examples().forEach(example -> {
                class_5250 optionText = class_2561.method_43470((String)example).method_27694(style -> {
                    style = example.equals(setting.valueToString(setting.getValue())) ? style.method_10977(class_124.field_1060) : style.method_10977(class_124.field_1080);
                    return style.method_10958((class_2558)new class_2558.class_10610("/servux set " + setting.qualifiedName() + " " + example)).method_10949((class_2568)new class_2568.class_10613((class_2561)StringUtils.translate("servux.command.info.click_to_set", example)));
                });
                text.method_10852((class_2561)optionText).method_27693(" ");
            });
            ((class_2168)ctx.getSource()).method_9226(() -> text, false);
        }
        return 1;
    }

    private static int configModify(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String value;
        class_2960 settingId = (class_2960)ctx.getArgument("setting", class_2960.class);
        String settingName = StringUtils.removeDefaultMinecraftNamespace(settingId);
        IServuxSetting<?> setting = DataProviderManager.INSTANCE.getSettingByName(settingName);
        if (setting == null) {
            throw StringUtils.translateError("servux.command.error.unknown_setting", new Object[0]);
        }
        try {
            value = (String)ctx.getArgument("value", String.class);
        }
        catch (Exception e) {
            value = setting.getDefaultValue().toString();
        }
        if (value == null || value.isEmpty()) {
            value = setting.getDefaultValue().toString();
        }
        if (!setting.validateString(value)) {
            throw StringUtils.translateError("servux.command.error.invalid_value", new Object[0]);
        }
        String finalValue = value;
        setting.setValueFromString(finalValue);
        ((class_2168)ctx.getSource()).method_9226(() -> StringUtils.translate("servux.command.config.set_value", setting.shortDisplayName().method_27661().method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/servux info " + setting.qualifiedName()))), finalValue), true);
        return 1;
    }
}

