/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import com.google.common.collect.Lists;
import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.mixin.debug.IMixinMobEntity;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxDebugHandler;
import fi.dy.masa.servux.network.packet.ServuxDebugPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11;
import net.minecraft.class_1275;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1355;
import net.minecraft.class_1646;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3765;
import net.minecraft.class_4076;
import net.minecraft.class_4095;
import net.minecraft.class_4099;
import net.minecraft.class_4102;
import net.minecraft.class_4139;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4466;
import net.minecraft.class_4617;
import net.minecraft.class_4831;
import net.minecraft.class_5281;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_6880;
import net.minecraft.class_7045;
import net.minecraft.class_7260;
import net.minecraft.class_7893;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8707;
import net.minecraft.class_8708;
import net.minecraft.class_8710;
import net.minecraft.class_8712;
import net.minecraft.class_8713;
import net.minecraft.class_8716;
import net.minecraft.class_8720;
import net.minecraft.class_8721;
import net.minecraft.class_8722;
import net.minecraft.class_8723;
import net.minecraft.class_8724;
import net.minecraft.class_8725;
import net.minecraft.class_8726;
import net.minecraft.class_8728;
import net.minecraft.class_8729;
import net.minecraft.class_8949;
import net.minecraft.class_9004;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class DebugDataProvider
extends DataProviderBase {
    public static final DebugDataProvider INSTANCE = new DebugDataProvider();
    protected static final ServuxDebugHandler<ServuxDebugPacket.Payload> HANDLER = ServuxDebugHandler.getInstance();
    protected final HashMap<UUID, class_2487> registeredPlayers = new HashMap();
    protected final class_2487 metadata = new class_2487();
    private final ServuxIntSetting basePermissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 2, 4, 0);
    private final List<IServuxSetting<?>> settings = List.of(this.basePermissionLevel);

    protected DebugDataProvider() {
        super("debug_data", ServuxDebugHandler.CHANNEL_ID, 1, 2, "servux.provider.debug_data", "Vanilla Debug Data provider.");
        this.metadata.method_10582("name", this.getName());
        this.metadata.method_10582("id", this.getNetworkChannel().toString());
        this.metadata.method_10569("version", this.getProtocolVersion());
        this.metadata.method_10582("servux", Reference.MOD_STRING);
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxDebugPacket.Payload.ID, ServuxDebugPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxDebugPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxDebugPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    public IPluginServerPlayHandler<ServuxDebugPacket.Payload> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(class_3222 player) {
        return this.registeredPlayers.containsKey(player.method_5667());
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public boolean hasPermission(class_3222 player) {
        if (player == null) {
            return false;
        }
        return Permissions.check((class_1297)player, (String)"servux.debug_data", (int)((Integer)this.basePermissionLevel.getValue()));
    }

    public boolean register(class_3222 player) {
        return this.register(player, null);
    }

    public boolean register(class_3222 player, @Nullable class_2487 data) {
        if (this.isEnabled()) {
            boolean registered = false;
            MinecraftServer server = player.method_5682();
            UUID uuid = player.method_5667();
            if (!this.hasPermission(player)) {
                Servux.debugLog("debug_data: Denying access for player {}, Insufficient Permissions", player.method_5477().method_54160());
                return registered;
            }
            if (!this.registeredPlayers.containsKey(uuid)) {
                this.registeredPlayers.put(uuid, data != null ? data.method_10553() : new class_2487());
                this.sendMetadata(player);
                registered = true;
            }
            return registered;
        }
        return false;
    }

    public boolean unregister(class_3222 player) {
        return this.unregister(player, null);
    }

    public boolean unregister(class_3222 player, @Nullable class_2487 nbt) {
        HANDLER.resetFailures(this.getNetworkChannel(), player);
        return this.registeredPlayers.remove(player.method_5667()) != null;
    }

    public void onPacketFailure(class_3222 player) {
    }

    public void sendMetadata(class_3222 player) {
        if (this.isEnabled()) {
            if (!this.hasPermission(player)) {
                Servux.debugLog("debug_data: Denying access for player {}, Insufficient Permissions", player.method_5477().method_54160());
                return;
            }
            class_2487 nbt = new class_2487();
            nbt.method_10543(this.metadata);
            Servux.debugLog("debugDataChannel: sendMetadata to player {}", player.method_5477().method_54160());
            if (player.field_13987 != null) {
                HANDLER.sendPlayPayload(player.field_13987, new ServuxDebugPacket.Payload(ServuxDebugPacket.MetadataResponse(this.metadata)));
            } else {
                HANDLER.sendPlayPayload(player, new ServuxDebugPacket.Payload(ServuxDebugPacket.MetadataResponse(this.metadata)));
            }
        }
    }

    public void confirmMetadata(class_3222 player, class_2487 data) {
        if (this.isEnabled()) {
            UUID uuid = player.method_5667();
            if (this.registeredPlayers.containsKey(uuid)) {
                this.registeredPlayers.replace(uuid, data.method_10553());
            } else {
                this.registeredPlayers.put(uuid, data.method_10553());
            }
            Servux.debugLog("debugDataChannel: received confirm from player {}", player.method_5477().method_54160());
        }
    }

    private void sendDebugData(class_3218 world, class_8710 payload) {
        if (this.isEnabled()) {
            class_2658 packet = new class_2658(payload);
            for (class_3222 player : world.method_18456()) {
                if (!this.registeredPlayers.containsKey(player.method_5667()) || !player.field_13987.method_52413((class_2596)packet)) continue;
                player.field_13987.method_14364((class_2596)packet);
            }
        }
    }

    public void sendChunkWatchingChange(class_3218 world, class_1923 pos) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (class_8710)new class_8729(pos.method_8323().method_10086(100), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f));
        }
    }

    public void sendPoiAdditions(class_3218 world, class_2338 pos) {
        if (this.isEnabled()) {
            world.method_19494().method_19132(pos).ifPresent(registryEntry -> {
                int tickets = world.method_19494().method_35155(pos);
                String name = registryEntry.method_55840();
                this.sendDebugData(world, (class_8710)new class_8722(pos, name, tickets));
            });
        }
    }

    public void sendPoiRemoval(class_3218 world, class_2338 pos) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (class_8710)new class_8723(pos));
        }
    }

    public void sendPointOfInterest(class_3218 world, class_2338 pos) {
        if (this.isEnabled()) {
            int tickets = world.method_19494().method_35155(pos);
            this.sendDebugData(world, (class_8710)new class_8724(pos, tickets));
        }
    }

    public void sendPoi(class_3218 world, class_2338 pos) {
        if (this.isEnabled()) {
            class_6880 entry;
            class_2378 registry = world.method_30349().method_30530(class_7924.field_41246);
            class_4076 chunkSectionPos = class_4076.method_18682((class_2338)pos);
            Iterator iterator = registry.method_40286(class_7045.field_37045).iterator();
            do {
                if (!iterator.hasNext()) {
                    this.sendDebugData(world, (class_8710)new class_8728(Set.of(), Set.of(chunkSectionPos)));
                    return;
                }
                entry = (class_6880)iterator.next();
            } while (world.method_27056().method_38853(chunkSectionPos, (class_3195)entry.comp_349()).isEmpty());
            this.sendDebugData(world, (class_8710)new class_8728(Set.of(chunkSectionPos), Set.of()));
        }
    }

    public void sendPathfindingData(class_3218 world, class_1308 mob, @Nullable class_11 path, float nodeReachProximity) {
        if (this.isEnabled() && path != null) {
            this.sendDebugData(world, (class_8710)new class_8721(mob.method_5628(), path, nodeReachProximity));
        }
    }

    public void sendNeighborUpdate(class_3218 world, class_2338 pos) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (class_8710)new class_8720(world.method_8510(), pos));
        }
    }

    public void sendStructureStart(class_5281 world, class_3449 structureStart) {
        if (this.isEnabled()) {
            ArrayList<class_8726.class_8727> pieces = new ArrayList<class_8726.class_8727>();
            for (int i = 0; i < structureStart.method_14963().size(); ++i) {
                pieces.add(new class_8726.class_8727(((class_3443)structureStart.method_14963().get(i)).method_14935(), i == 0));
            }
            class_3218 serverWorld = world.method_8410();
            this.sendDebugData(serverWorld, (class_8710)new class_8726(serverWorld.method_27983(), structureStart.method_14969(), pieces));
        }
    }

    public void sendGoalSelector(class_3218 world, class_1308 mob, class_1355 goalSelector) {
        if (this.isEnabled()) {
            List<class_8716.class_8717> goals = ((IMixinMobEntity)mob).servux_getGoalSelector().method_35115().stream().map(goal -> new class_8716.class_8717(goal.method_19057(), goal.method_19056(), goal.method_19058().toString())).toList();
            this.sendDebugData(world, (class_8710)new class_8716(mob.method_5628(), mob.method_24515(), goals));
        }
    }

    public void sendRaids(class_3218 world, Collection<class_3765> raids) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (class_8710)new class_8725(raids.stream().map(class_3765::method_16495).toList()));
        }
    }

    public void sendBrainDebugData(class_3218 serverWorld, class_1309 livingEntity) {
        if (this.isEnabled()) {
            boolean wantsGolem;
            String inventory;
            int xp;
            String profession;
            int angerLevel;
            class_1308 entity = (class_1308)livingEntity;
            if (entity instanceof class_7260) {
                class_7260 wardenEntity = (class_7260)entity;
                angerLevel = wardenEntity.method_42222();
            } else {
                angerLevel = -1;
            }
            ArrayList gossips = new ArrayList();
            HashSet<class_2338> pois = new HashSet<class_2338>();
            HashSet<class_2338> potentialPois = new HashSet<class_2338>();
            if (entity instanceof class_1646) {
                class_1646 villager = (class_1646)entity;
                profession = villager.method_7231().comp_3521().toString();
                xp = villager.method_19269();
                inventory = villager.method_35199().toString();
                wantsGolem = villager.method_20687(serverWorld.method_8510());
                villager.method_21651().method_35120().forEach((uuid, associatedGossip) -> {
                    class_1297 gossipEntity = serverWorld.method_66347(uuid);
                    if (gossipEntity != null) {
                        String name = class_4617.method_36154((class_1297)gossipEntity);
                        ObjectIterator objectIterator = associatedGossip.object2IntEntrySet().iterator();
                        while (objectIterator.hasNext()) {
                            Object2IntMap.Entry typeEntry;
                            Object2IntMap.Entry entry = typeEntry = (Object2IntMap.Entry)objectIterator.next();
                            gossips.add(name + ": " + ((class_4139)entry.getKey()).method_15434() + " " + String.valueOf(entry.getValue()));
                        }
                    }
                });
                class_4095 brain = villager.method_18868();
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_18438, pois);
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_18439, pois);
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_18440, pois);
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_19008, pois);
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_25160, potentialPois);
            } else {
                profession = "";
                xp = 0;
                inventory = "";
                wantsGolem = false;
            }
            this.sendDebugData(serverWorld, (class_8710)new class_8708(new class_8708.class_4232(entity.method_5667(), entity.method_5628(), entity.method_5477().getString(), profession, xp, entity.method_6032(), entity.method_6063(), entity.method_19538(), inventory, entity.method_5942().method_6345(), wantsGolem, angerLevel, entity.method_18868().method_35059().stream().map(class_4168::toString).toList(), entity.method_18868().method_27074().stream().map(class_7893::method_46910).toList(), this.listMemories((class_1309)entity, serverWorld.method_8510()), gossips, pois, potentialPois)));
        }
    }

    public void sendBeeDebugData(class_3218 world, class_4466 bee) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (class_8710)new class_8707(new class_8707.class_5243(bee.method_5667(), bee.method_5628(), bee.method_19538(), bee.method_5942().method_6345(), bee.method_23884(), bee.method_21778(), bee.method_35161(), bee.method_35163().method_35115().stream().map(prioritizedGoal -> prioritizedGoal.method_19058().toString()).collect(Collectors.toSet()), bee.method_35162())));
        }
    }

    public void sendBreezeDebugData(class_3218 world, class_8949 breeze) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (class_8710)new class_9004(new class_9004.class_9005(breeze.method_5667(), breeze.method_5628(), breeze.method_5968() == null ? null : Integer.valueOf(breeze.method_5968().method_5628()), (class_2338)breeze.method_18868().method_18904(class_4140.field_47258).orElse(null))));
        }
    }

    public void sendGameEvent(class_3218 world, class_6880<class_5712> event, class_243 pos) {
        if (this.isEnabled()) {
            event.method_40230().ifPresent(key -> this.sendDebugData(world, (class_8710)new class_8712(key, pos)));
        }
    }

    public void sendGameEventListener(class_3218 world, class_5714 eventListener) {
        if (this.isEnabled()) {
            this.sendDebugData(world, (class_8710)new class_8713(eventListener.method_32946(), eventListener.method_32948()));
        }
    }

    private void addPoi(class_4095<?> brain, class_4140<class_4208> memoryModuleType, Set<class_2338> set) {
        if (this.isEnabled()) {
            Optional<class_2338> opt = brain.method_18904(memoryModuleType).map(class_4208::comp_2208);
            Objects.requireNonNull(set);
            opt.ifPresent(set::add);
        }
    }

    private List<String> listMemories(class_1309 entity, long currentTime) {
        if (this.isEnabled()) {
            Map map = entity.method_18868().method_35058();
            ArrayList list = Lists.newArrayList();
            for (Map.Entry memoryModuleTypeOptionalEntry : map.entrySet()) {
                Object string;
                class_4140 memoryModuleType = (class_4140)memoryModuleTypeOptionalEntry.getKey();
                Optional optional = (Optional)memoryModuleTypeOptionalEntry.getValue();
                if (optional.isPresent()) {
                    class_4831 memory = (class_4831)optional.get();
                    Object object = memory.method_24637();
                    if (memoryModuleType == class_4140.field_19009) {
                        long l = currentTime - (Long)object;
                        string = l + " ticks ago";
                    } else if (memory.method_24914()) {
                        String var10000 = this.format((class_3218)entity.method_37908(), object);
                        string = var10000 + " (ttl: " + memory.method_35127() + ")";
                    } else {
                        string = this.format((class_3218)entity.method_37908(), object);
                    }
                } else {
                    string = "-";
                }
                String type = class_7923.field_41129.method_10221((Object)memoryModuleType).method_12832();
                list.add(type + ": " + (String)string);
            }
            list.sort(String::compareTo);
            return list;
        }
        return List.of();
    }

    private String format(class_3218 world, @Nullable Object object) {
        if (this.isEnabled()) {
            if (object == null) {
                return "-";
            }
            if (object instanceof UUID) {
                return this.format(world, world.method_66347((UUID)object));
            }
            if (object instanceof class_1309) {
                class_1297 entity = (class_1297)object;
                return class_4617.method_36154((class_1297)entity);
            }
            if (object instanceof class_1275) {
                return ((class_1275)object).method_5477().getString();
            }
            if (object instanceof class_4142) {
                return this.format(world, ((class_4142)object).method_19094());
            }
            if (object instanceof class_4102) {
                return this.format(world, ((class_4102)object).method_35066());
            }
            if (object instanceof class_4208) {
                return this.format(world, ((class_4208)object).comp_2208());
            }
            if (object instanceof class_4099) {
                return this.format(world, ((class_4099)object).method_18989());
            }
            if (object instanceof class_1282) {
                class_1297 entity = ((class_1282)object).method_5529();
                return entity == null ? object.toString() : this.format(world, entity);
            }
            if (!(object instanceof Collection)) {
                return object.toString();
            }
            ArrayList list = Lists.newArrayList();
            for (Object object2 : (Iterable)object) {
                list.add(this.format(world, object2));
            }
            return ((Object)list).toString();
        }
        return "";
    }
}

