/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.loggers.DataLogger;
import fi.dy.masa.servux.loggers.DataLoggerBase;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxHudHandler;
import fi.dy.masa.servux.network.packet.ServuxHudPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.IServuxSettingCallback;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import fi.dy.masa.servux.settings.ServuxStringListSetting;
import fi.dy.masa.servux.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1860;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3695;
import net.minecraft.server.MinecraftServer;

public class HudDataProvider
extends DataProviderBase {
    public static final HudDataProvider INSTANCE = new HudDataProvider();
    protected static final ServuxHudHandler<ServuxHudPacket.Payload> HANDLER = ServuxHudHandler.getInstance();
    protected final class_2487 metadata = new class_2487();
    private final ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    private final ServuxIntSetting updateInterval = new ServuxIntSetting((IDataProvider)this, "update_interval", 40, 300, 20);
    private final ServuxBoolSetting shareWeatherStatus = new ServuxBoolSetting(this, "share_weather_status", false);
    private final ServuxIntSetting weatherPermissionLevel = new ServuxIntSetting((IDataProvider)this, "weather_permission_level", 0, 4, 0);
    private final ServuxBoolSetting shareSeed = new ServuxBoolSetting(this, "share_seed", false);
    private final ServuxIntSetting seedPermissionLevel = new ServuxIntSetting((IDataProvider)this, "seed_permission_level", 2, 4, 0);
    private final ServuxBoolSetting loggersEnabled = new ServuxBoolSetting(this, "loggers_enabled", false, new BoolCallback());
    private final ServuxStringListSetting loggersEnableList = new ServuxStringListSetting(this, "loggers_enable_list", this.getDefaultLoggers(), new StringListCallback());
    private final ServuxIntSetting loggerPermissionLevel = new ServuxIntSetting((IDataProvider)this, "logger_permission_level", 0, 4, 0);
    private final List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.updateInterval, this.shareWeatherStatus, this.weatherPermissionLevel, this.shareSeed, this.seedPermissionLevel, this.loggersEnabled, this.loggersEnableList, this.loggerPermissionLevel);
    private class_2338 spawnPos = class_2338.field_10980;
    private int spawnChunkRadius = -1;
    private long worldSeed = 0L;
    private int clearWeatherTime = -1;
    private int rainWeatherTime = -1;
    private int thunderWeatherTime = -1;
    private boolean isRaining;
    private boolean isThundering;
    private long lastTick;
    private long lastWeatherTick;
    private boolean refreshSpawnMetadata;
    private boolean refreshWeatherData;
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();
    private final HashMap<UUID, List<DataLogger>> loggerPlayers = new HashMap();
    private final HashMap<DataLogger, DataLoggerBase<?>> LOGGERS = new HashMap();
    private final HashMap<DataLogger, class_2520> DATA = new HashMap();

    protected HudDataProvider() {
        super("hud_data", ServuxHudHandler.CHANNEL_ID, 2, 0, "servux.provider.hud_data", "MiniHUD Meta Data provider for various Server-Side information");
        this.metadata.method_10582("name", this.getName());
        this.metadata.method_10582("id", this.getNetworkChannel().toString());
        this.metadata.method_10569("version", this.getProtocolVersion());
        this.metadata.method_10582("servux", Reference.MOD_STRING);
        this.metadata.method_10569("spawnPosX", this.getSpawnPos().method_10263());
        this.metadata.method_10569("spawnPosY", this.getSpawnPos().method_10264());
        this.metadata.method_10569("spawnPosZ", this.getSpawnPos().method_10260());
        this.metadata.method_10569("spawnChunkRadius", this.getSpawnChunkRadius());
        this.checkIfLoggersAreInitialized();
    }

    private List<String> getDefaultLoggers() {
        ArrayList<String> list = new ArrayList<String>();
        for (DataLogger type : DataLogger.VALUES) {
            list.add(type.method_15434());
        }
        return list;
    }

    private void resetLoggersFromConfig() {
        if (this.isLoggersEnabled()) {
            this.loggersEnabled.setValueNoCallback(false);
            this.checkIfLoggersAreInitialized();
            this.loggersEnabled.setValueNoCallback(true);
        } else {
            this.checkIfLoggersAreInitialized();
        }
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxHudPacket.Payload.ID, ServuxHudPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxHudPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxHudPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(class_3222 player) {
        return !this.isPlayerInvalid(player);
    }

    @Override
    public boolean shouldTick() {
        return this.enabled;
    }

    @Override
    public void tick(MinecraftServer server, int tickCounter, class_3695 profiler) {
        if (!this.isEnabled()) {
            return;
        }
        List playerList = server.method_3760().method_14571();
        if (tickCounter % (Integer)this.updateInterval.getValue() == 0) {
            profiler.method_15396(this.getName() + "_tick_weather");
            this.lastTick = tickCounter;
            int radius = this.getSpawnChunkRadius();
            int rule = server.method_3767().method_8356(class_1928.field_48374);
            if (radius != rule) {
                this.setSpawnChunkRadius(rule);
            }
            if (this.worldSeed == 0L) {
                this.checkWorldSeed(server);
            } else if (!((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.setWorldSeed(0L);
            }
            profiler.method_15405(this.getName() + "_weather_players");
            for (class_3222 player : playerList) {
                if (this.isPlayerInvalid(player)) continue;
                if (this.shouldRefreshWeatherData()) {
                    this.refreshWeatherData(player, null);
                }
                if (!this.shouldRefreshSpawnMetadata()) continue;
                this.refreshSpawnMetadata(player, null);
            }
            if (this.shouldRefreshWeatherData()) {
                this.lastWeatherTick = tickCounter;
                this.setRefreshWeatherDataComplete();
            }
            if (this.shouldRefreshSpawnMetadata()) {
                this.setRefreshSpawnMetadataComplete();
            }
            profiler.method_15407();
        }
        this.checkIfLoggersAreInitialized();
        if (this.isLoggersEnabled()) {
            profiler.method_15396(this.getName() + "_tick_loggers");
            this.tickLoggers(server);
            profiler.method_15405(this.getName() + "_logger_players");
            for (class_3222 player : playerList) {
                this.tickLoggerPlayer(player);
            }
            profiler.method_15407();
        }
    }

    private void setPlayerInvalid(class_3222 player) {
        if (!this.invalidPlayers.contains(player.method_5667())) {
            this.invalidPlayers.add(player.method_5667());
        }
    }

    private boolean isPlayerInvalid(class_3222 player) {
        return this.invalidPlayers.contains(player.method_5667());
    }

    private void removeInvalidPlayer(class_3222 player) {
        this.invalidPlayers.remove(player.method_5667());
    }

    public void tickWeather(int clearTime, int rainTime, int thunderTime, boolean isRaining, boolean isThunder) {
        if (!this.isEnabled()) {
            return;
        }
        this.clearWeatherTime = clearTime;
        this.rainWeatherTime = rainTime;
        this.thunderWeatherTime = thunderTime;
        this.isRaining = isRaining;
        this.isThundering = isThunder;
        if (this.lastTick - this.lastWeatherTick > (long)this.getTickInterval()) {
            this.refreshWeatherData = true;
        }
    }

    private void checkIfLoggersAreInitialized() {
        if (this.isLoggersEnabled()) {
            if (!this.metadata.method_10545("Loggers")) {
                this.metadata.method_10566("Loggers", (class_2520)this.putEnabledLoggers());
            }
            this.setTickRate(15);
            if (this.LOGGERS.isEmpty()) {
                this.initializeLoggers();
            }
        } else {
            if (this.metadata.method_10545("Loggers")) {
                this.metadata.method_10551("Loggers");
            }
            if (!this.LOGGERS.isEmpty()) {
                this.LOGGERS.clear();
            }
            this.setTickRate(40);
            if (!this.DATA.isEmpty()) {
                this.DATA.clear();
            }
        }
    }

    private class_2487 putEnabledLoggers() {
        class_2487 nbt = new class_2487();
        this.validateLoggerListConfig();
        for (DataLogger type : DataLogger.VALUES) {
            nbt.method_10556(type.method_15434(), this.isLoggerTypeEnabled(type));
        }
        return nbt;
    }

    private void validateLoggerListConfig() {
        List list = (List)this.loggersEnableList.getValue();
        ArrayList<String> safeList = new ArrayList<String>();
        boolean dirty = false;
        for (String entry : list) {
            DataLogger type = DataLogger.fromStringStatic(entry);
            if (type == null) {
                Servux.LOGGER.warn("validateLoggerListConfig: Removing invalid logger type: '{}'", (Object)entry);
                dirty = true;
                continue;
            }
            safeList.add(entry);
        }
        if (dirty) {
            this.loggersEnableList.setValueNoCallback(safeList);
        }
    }

    private boolean isLoggerTypeEnabled(DataLogger type) {
        return ((List)this.loggersEnableList.getValue()).contains(type.method_15434());
    }

    private void initializeLoggers() {
        if (this.LOGGERS.isEmpty()) {
            for (DataLogger type : DataLogger.VALUES) {
                DataLoggerBase<?> entry;
                if (!this.isLoggerTypeEnabled(type) || (entry = type.init()) == null) continue;
                this.LOGGERS.put(type, entry);
            }
        }
    }

    private void tickLoggers(MinecraftServer server) {
        this.DATA.clear();
        if (!this.isLoggersEnabled()) {
            return;
        }
        this.LOGGERS.forEach((type, logger) -> this.DATA.put((DataLogger)((Object)type), (class_2520)logger.getResult(server)));
    }

    private void tickLoggerPlayer(class_3222 player) {
        List<DataLogger> list;
        if (!this.isLoggersEnabled()) {
            return;
        }
        UUID uuid = player.method_5667();
        if (this.loggerPlayers.containsKey(uuid) && !(list = this.loggerPlayers.get(uuid)).isEmpty()) {
            class_2487 nbt = new class_2487();
            for (DataLogger type : list) {
                if (!this.DATA.containsKey((Object)type)) continue;
                nbt.method_10566(type.method_15434(), this.DATA.get((Object)type));
            }
            HANDLER.encodeServerData(player, ServuxHudPacket.DataLoggerTick(nbt));
        }
    }

    public void sendMetadata(class_3222 player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("hud_service: Denying access for player {}, Insufficient Permissions", player.method_5477().method_54160());
            return;
        }
        this.removeInvalidPlayer(player);
        class_2487 nbt = new class_2487();
        nbt.method_10543(this.metadata);
        if (!this.hasPermissionsForSeed(player) && nbt.method_10545("worldSeed")) {
            nbt.method_10551("worldSeed");
        }
        Servux.debugLog("hudDataChannel: sendMetadata to player {}", player.method_5477().method_54160());
        if (player.field_13987 != null) {
            HANDLER.sendPlayPayload(player.field_13987, new ServuxHudPacket.Payload(ServuxHudPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxHudPacket.Payload(ServuxHudPacket.MetadataResponse(this.metadata)));
        }
    }

    public void refreshLoggers(class_3222 player, @Nonnull class_2487 nbt) {
        if (!this.hasPermissionsForLoggers(player)) {
            player.method_64398((class_2561)StringUtils.translate("servux.hud_data.error.insufficient_for_loggers", "any"));
            return;
        }
        if (!nbt.method_33133()) {
            ArrayList<DataLogger> list = new ArrayList<DataLogger>();
            UUID uuid = player.method_5667();
            for (String key : nbt.method_10541()) {
                DataLogger type = DataLogger.fromStringStatic(key);
                boolean enable = nbt.method_68566(key, false);
                if (type == null) continue;
                if (this.hasPermissionsForLogger(player, key) && enable) {
                    list.add(type);
                    continue;
                }
                if (!enable) continue;
                player.method_64398((class_2561)StringUtils.translate("servux.hud_data.error.insufficient_for_loggers", key));
            }
            if (!list.isEmpty()) {
                this.loggerPlayers.put(uuid, list);
            } else {
                this.loggerPlayers.remove(uuid);
            }
        }
    }

    public void onPacketFailure(class_3222 player) {
        this.setPlayerInvalid(player);
        this.removePlayerLoggers(player);
    }

    public void removePlayer(class_3222 player) {
        this.removeInvalidPlayer(player);
        this.removePlayerLoggers(player);
    }

    private void removePlayerLoggers(class_3222 player) {
        this.loggerPlayers.remove(player.method_5667());
    }

    public void refreshSpawnMetadata(class_3222 player, @Nullable class_2487 data) {
        if (!this.isEnabled()) {
            return;
        }
        class_2487 nbt = new class_2487();
        class_2338 spawnPos = INSTANCE.getSpawnPos();
        nbt.method_10582("id", this.getNetworkChannel().toString());
        nbt.method_10582("servux", Reference.MOD_STRING);
        nbt.method_10569("version", this.getProtocolVersion());
        nbt.method_10569("spawnPosX", spawnPos.method_10263());
        nbt.method_10569("spawnPosY", spawnPos.method_10264());
        nbt.method_10569("spawnPosZ", spawnPos.method_10260());
        nbt.method_10569("spawnChunkRadius", INSTANCE.getSpawnChunkRadius());
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && this.hasPermissionsForSeed(player)) {
            Servux.debugLog("refreshSpawnMetadata() player [{}] has seedPermissions.", player.method_5477().method_54160());
            nbt.method_10544("worldSeed", this.worldSeed);
        } else {
            Servux.debugLog("refreshSpawnMetadata() player [{}] does not have seedPermissions.", player.method_5477().method_54160());
        }
        HANDLER.encodeServerData(player, ServuxHudPacket.SpawnResponse(nbt));
    }

    public void refreshWeatherData(class_3222 player, @Nullable class_2487 data) {
        if (!this.hasPermissionsForWeather(player) || !this.isEnabled()) {
            return;
        }
        class_2487 nbt = new class_2487();
        nbt.method_10582("id", this.getNetworkChannel().toString());
        nbt.method_10582("servux", Reference.MOD_STRING);
        if (this.isRaining && this.rainWeatherTime > -1) {
            nbt.method_10569("SetRaining", this.rainWeatherTime);
            nbt.method_10556("isRaining", true);
        } else {
            nbt.method_10556("isRaining", false);
        }
        if (this.isThundering && this.thunderWeatherTime > -1) {
            nbt.method_10569("SetThundering", this.thunderWeatherTime);
            nbt.method_10556("isThundering", true);
        } else {
            nbt.method_10556("isThundering", false);
        }
        if (this.clearWeatherTime > -1) {
            nbt.method_10569("SetClear", this.clearWeatherTime);
        }
        HANDLER.encodeServerData(player, ServuxHudPacket.WeatherTick(nbt));
    }

    public void refreshRecipeManager(class_3222 player, @Nullable class_2487 data) {
        if (!this.hasPermission(player)) {
            return;
        }
        class_3218 world = player.method_51469();
        Collection recipes = world.method_64577().method_8126();
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        if (data != null) {
            Servux.debugLog("hudDataChannel: received RecipeManager request from {}, client version: {}", player.method_5477().method_54160(), data.method_68564("version", "?"));
        }
        recipes.forEach(recipeEntry -> {
            DataResult dr = class_1860.field_47319.encodeStart((DynamicOps)class_2509.field_11560, (Object)recipeEntry.comp_1933());
            if (dr.result().isPresent()) {
                class_2487 entry = new class_2487();
                entry.method_10582("id_reg", recipeEntry.comp_1932().method_41185().toString());
                entry.method_10582("id_value", recipeEntry.comp_1932().method_29177().toString());
                entry.method_10566("recipe", (class_2520)dr.result().get());
                list.add((Object)entry);
            }
        });
        nbt.method_10566("RecipeManager", (class_2520)list);
        HANDLER.encodeServerData(player, ServuxHudPacket.ResponseS2CStart(nbt));
    }

    public class_2338 getSpawnPos() {
        if (this.spawnPos == null) {
            this.setSpawnPos(class_2338.field_10980);
        }
        return this.spawnPos;
    }

    public void setSpawnPos(class_2338 spawnPos) {
        if (!this.spawnPos.equals((Object)spawnPos)) {
            this.metadata.method_10551("spawnPosX");
            this.metadata.method_10551("spawnPosY");
            this.metadata.method_10551("spawnPosZ");
            this.metadata.method_10569("spawnPosX", spawnPos.method_10263());
            this.metadata.method_10569("spawnPosY", spawnPos.method_10264());
            this.metadata.method_10569("spawnPosZ", spawnPos.method_10260());
            this.refreshSpawnMetadata = true;
            Servux.debugLog("setSpawnPos(): updating World Spawn [{}] -> [{}]", this.spawnPos.method_23854(), spawnPos.method_23854());
        }
        this.spawnPos = spawnPos;
    }

    public int getSpawnChunkRadius() {
        if (this.spawnChunkRadius < 0) {
            this.spawnChunkRadius = 2;
        }
        return this.spawnChunkRadius;
    }

    public void setSpawnChunkRadius(int radius) {
        if (this.spawnChunkRadius != radius) {
            this.metadata.method_10551("spawnChunkRadius");
            this.metadata.method_10569("spawnChunkRadius", radius);
            this.refreshSpawnMetadata = true;
            Servux.debugLog("setSpawnPos(): updating Spawn Chunk Radius [{}] -> [{}]", this.spawnChunkRadius, radius);
        }
        this.spawnChunkRadius = radius;
    }

    public boolean shouldRefreshSpawnMetadata() {
        return this.refreshSpawnMetadata;
    }

    public void setRefreshSpawnMetadataComplete() {
        this.refreshSpawnMetadata = false;
        Servux.debugLog("setRefreshSpawnMetadataComplete()", new Object[0]);
    }

    public boolean shouldRefreshWeatherData() {
        return this.refreshWeatherData;
    }

    public void setRefreshWeatherDataComplete() {
        this.refreshWeatherData = false;
    }

    public long getWorldSeed() {
        return this.worldSeed;
    }

    public void setWorldSeed(long seed) {
        if (this.worldSeed != seed) {
            if (((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.metadata.method_10551("worldSeed");
                this.metadata.method_10544("worldSeed", seed);
                this.refreshSpawnMetadata = true;
            }
            Servux.debugLog("setWorldSeed(): updating World Seed [{}] -> [{}]", this.worldSeed, seed);
        }
        this.worldSeed = seed;
    }

    public void checkWorldSeed(MinecraftServer server) {
        class_3218 world;
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && (world = server.method_30002()) != null) {
            this.setWorldSeed(world.method_8412());
        }
    }

    public boolean isLoggersEnabled() {
        return (Boolean)this.loggersEnabled.getValue();
    }

    public boolean hasPermissionsForWeather(class_3222 player) {
        return Permissions.check((class_1297)player, (String)(this.permNode + ".weather"), (int)((Integer)this.weatherPermissionLevel.getValue()));
    }

    public boolean hasPermissionsForSeed(class_3222 player) {
        return Permissions.check((class_1297)player, (String)(this.permNode + ".seed"), (int)((Integer)this.seedPermissionLevel.getValue()));
    }

    public boolean hasPermissionsForLoggers(class_3222 player) {
        return Permissions.check((class_1297)player, (String)(this.permNode + ".logger"), (int)((Integer)this.loggerPermissionLevel.getValue()));
    }

    public boolean hasPermissionsForLogger(class_3222 player, String type) {
        return Permissions.check((class_1297)player, (String)(this.permNode + ".logger." + type), (int)((Integer)this.loggerPermissionLevel.getValue()));
    }

    @Override
    public boolean hasPermission(class_3222 player) {
        return Permissions.check((class_1297)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }

    public static class BoolCallback
    implements IServuxSettingCallback<Boolean> {
        @Override
        public void onValueChanged(IServuxSetting<Boolean> setting, Boolean oldValue, Boolean value) {
            INSTANCE.resetLoggersFromConfig();
        }
    }

    public static class StringListCallback
    implements IServuxSettingCallback<List<String>> {
        @Override
        public void onValueChanged(IServuxSetting<List<String>> setting, List<String> oldValue, List<String> value) {
            INSTANCE.resetLoggersFromConfig();
        }
    }
}

