/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network.packet;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.LitematicsDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.IServerPayloadData;
import fi.dy.masa.servux.network.PacketSplitter;
import fi.dy.masa.servux.network.packet.ServuxLitematicaPacket;
import fi.dy.masa.servux.schematic.LitematicaSchematic;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5819;
import net.minecraft.class_8710;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.SERVER)
public abstract class ServuxLitematicaHandler<T extends class_8710>
implements IPluginServerPlayHandler<T> {
    private static final ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> INSTANCE = new ServuxLitematicaHandler<ServuxLitematicaPacket.Payload>(){

        public void receive(ServuxLitematicaPacket.Payload payload, ServerPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final class_2960 CHANNEL_ID = class_2960.method_60655((String)"servux", (String)"litematics");
    private boolean payloadRegistered = false;
    private final Map<UUID, Integer> failures = new HashMap<UUID, Integer>();
    private static final int MAX_FAILURES = 4;
    private final Map<UUID, Long> readingSessionKeys = new HashMap<UUID, Long>();

    public static ServuxLitematicaHandler<ServuxLitematicaPacket.Payload> getInstance() {
        return INSTANCE;
    }

    @Override
    public class_2960 getPayloadChannel() {
        return CHANNEL_ID;
    }

    @Override
    public boolean isPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    @Override
    public void setPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    @Override
    public <P extends IServerPayloadData> void decodeServerData(class_2960 channel, class_3222 player, P data) {
        ServuxLitematicaPacket packet = (ServuxLitematicaPacket)data;
        if (!channel.equals((Object)CHANNEL_ID)) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_C2S_METADATA_REQUEST: {
                LitematicsDataProvider.INSTANCE.sendMetadata(player);
                break;
            }
            case PACKET_C2S_BLOCK_ENTITY_REQUEST: {
                LitematicsDataProvider.INSTANCE.onBlockEntityRequest(player, packet.getPos());
                break;
            }
            case PACKET_C2S_ENTITY_REQUEST: {
                LitematicsDataProvider.INSTANCE.onEntityRequest(player, packet.getEntityId());
                break;
            }
            case PACKET_C2S_BULK_ENTITY_NBT_REQUEST: {
                LitematicsDataProvider.INSTANCE.onBulkEntityRequest(player, packet.getChunkPos(), packet.getCompound());
                break;
            }
            case PACKET_C2S_NBT_RESPONSE_DATA: {
                long readingSessionKey;
                UUID uuid = player.method_5667();
                if (!this.readingSessionKeys.containsKey(uuid)) {
                    readingSessionKey = class_5819.method_43049((long)class_156.method_658()).method_43055();
                    this.readingSessionKeys.put(uuid, readingSessionKey);
                } else {
                    readingSessionKey = this.readingSessionKeys.get(uuid);
                }
                class_2540 fullPacket = PacketSplitter.receive(this, readingSessionKey, packet.getBuffer());
                if (fullPacket == null) break;
                try {
                    this.readingSessionKeys.remove(uuid);
                    this.handleBulkData(player, fullPacket.method_10816(), (class_2487)fullPacket.method_30616(class_2505.method_53898()));
                }
                catch (Exception e) {
                    Servux.LOGGER.error("ServuxLitematicaHandler#decodeServerData(): Litematic Data: error reading fullBuffer [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                Servux.LOGGER.warn("ServuxLitematicaHandler#decodeServerData(): Invalid packetType '{}' from player: {}, of size in bytes: {}.", (Object)packet.getPacketType(), (Object)player.method_5477().method_54160(), (Object)packet.getTotalSize());
            }
        }
    }

    private void handleBulkData(class_3222 player, int type, class_2487 nbt) {
        String task;
        switch (task = nbt.method_68564("Task", "LitematicaPaste")) {
            case "Litematic-TransmitStart": 
            case "Litematic-TransmitCancel": 
            case "Litematic-TransmitData": 
            case "Litematic-TransmitEnd": {
                Pair<LitematicaSchematic, class_2487> schemPair = LitematicaSchematic.receiveFileTransmit(nbt, player);
                if (schemPair == null || ((LitematicaSchematic)schemPair.getLeft()).getFile() == null) break;
                Servux.debugLog("handleBulkData(): Received litematic '{}' from player {}", ((LitematicaSchematic)schemPair.getLeft()).getFile().toAbsolutePath().toString(), player.method_5477().method_54160());
                LitematicsDataProvider.INSTANCE.handleClientPasteRequestPair(player, type, schemPair);
                break;
            }
            default: {
                LitematicsDataProvider.INSTANCE.handleClientPasteRequest(player, type, nbt);
            }
        }
    }

    @Override
    public void reset(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.clear();
        }
    }

    public void resetFailures(class_2960 channel, class_3222 player) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.remove(player.method_5667());
        }
    }

    @Override
    public void receivePlayPayload(T payload, ServerPlayNetworking.Context ctx) {
        if (payload.method_56479().comp_2242().equals((Object)CHANNEL_ID)) {
            class_3222 player = ctx.player();
            INSTANCE.decodeServerData(CHANNEL_ID, player, ((ServuxLitematicaPacket.Payload)payload).data());
        }
    }

    @Override
    public void encodeWithSplitter(class_3222 player, class_2540 buffer, class_3244 networkHandler) {
        INSTANCE.sendPlayPayload(player, new ServuxLitematicaPacket.Payload(ServuxLitematicaPacket.ResponseS2CData(buffer)));
    }

    @Override
    public <P extends IServerPayloadData> void encodeServerData(class_3222 player, P data) {
        if (!LitematicsDataProvider.INSTANCE.isEnabled()) {
            return;
        }
        ServuxLitematicaPacket packet = (ServuxLitematicaPacket)data;
        if (packet.getType().equals((Object)ServuxLitematicaPacket.Type.PACKET_S2C_NBT_RESPONSE_START)) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.method_10804(packet.getTransactionId());
            buffer.method_10794((class_2520)packet.getCompound());
            PacketSplitter.send(this, buffer, player, player.field_13987);
        } else if (!INSTANCE.sendPlayPayload(player, new ServuxLitematicaPacket.Payload(packet))) {
            UUID id = player.method_5667();
            if (!this.failures.containsKey(id)) {
                this.failures.put(id, 1);
            } else if (this.failures.get(id) > 4) {
                LitematicsDataProvider.INSTANCE.onPacketFailure(player);
            } else {
                int count = this.failures.get(id) + 1;
                this.failures.put(id, count);
            }
        }
    }
}

