/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic.placement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.servux.Servux;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class SubRegionPlacement {
    public static final Codec<SubRegionPlacement> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PrimitiveCodec.STRING.fieldOf("Name").forGetter(get -> get.name), (App)class_2338.field_25064.fieldOf("DefaultPos").forGetter(get -> get.defaultPos), (App)class_2338.field_25064.fieldOf("Pos").forGetter(get -> get.pos), (App)class_2470.field_39313.fieldOf("Rotation").forGetter(get -> get.rotation), (App)class_2415.field_39311.fieldOf("Mirror").forGetter(get -> get.mirror), (App)PrimitiveCodec.BOOL.fieldOf("Enabled").forGetter(get -> get.enabled), (App)PrimitiveCodec.BOOL.fieldOf("RenderingEnabled").forGetter(get -> get.renderingEnabled), (App)PrimitiveCodec.BOOL.fieldOf("IgnoreEntities").forGetter(get -> get.ignoreEntities), (App)PrimitiveCodec.INT.fieldOf("CoordinateLockMask").forGetter(get -> get.coordinateLockMask)).apply((Applicative)inst, SubRegionPlacement::new));
    public static final class_9139<ByteBuf, class_2415> BLOCK_MIRROR_PACKET_CODEC = class_9135.field_48554.method_56432(class_2415::valueOf, class_2415::method_15434);
    public static final class_9139<ByteBuf, SubRegionPlacement> PACKET_CODEC = new class_9139<ByteBuf, SubRegionPlacement>(){

        public void encode(ByteBuf buf, SubRegionPlacement value) {
            class_9135.field_48554.encode((Object)buf, (Object)value.name);
            class_2338.field_48404.encode((Object)buf, (Object)value.defaultPos);
            class_2338.field_48404.encode((Object)buf, (Object)value.pos);
            class_2470.field_55987.encode((Object)buf, (Object)value.rotation);
            BLOCK_MIRROR_PACKET_CODEC.encode((Object)buf, (Object)value.mirror);
            class_9135.field_48547.encode((Object)buf, (Object)value.enabled);
            class_9135.field_48547.encode((Object)buf, (Object)value.renderingEnabled);
            class_9135.field_48547.encode((Object)buf, (Object)value.ignoreEntities);
            class_9135.field_49675.encode((Object)buf, (Object)value.coordinateLockMask);
        }

        public SubRegionPlacement decode(ByteBuf buf) {
            return new SubRegionPlacement((String)class_9135.field_48554.decode((Object)buf), (class_2338)class_2338.field_48404.decode((Object)buf), (class_2338)class_2338.field_48404.decode((Object)buf), (class_2470)class_2470.field_55987.decode((Object)buf), (class_2415)BLOCK_MIRROR_PACKET_CODEC.decode((Object)buf), (Boolean)class_9135.field_48547.decode((Object)buf), (Boolean)class_9135.field_48547.decode((Object)buf), (Boolean)class_9135.field_48547.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf));
        }
    };
    private final String name;
    private final class_2338 defaultPos;
    private class_2338 pos;
    public class_2470 rotation = class_2470.field_11467;
    public class_2415 mirror = class_2415.field_11302;
    public boolean enabled = true;
    private boolean renderingEnabled = false;
    public boolean ignoreEntities;
    private int coordinateLockMask;

    public SubRegionPlacement(class_2338 pos, String name) {
        this.pos = pos;
        this.defaultPos = pos;
        this.name = name;
    }

    private SubRegionPlacement(String name, class_2338 defPos, class_2338 pos, class_2470 rot, class_2415 mirror, Boolean enabled, Boolean renderingEnabled, Boolean ignoreEntities, Integer coordinateLockMask) {
        this(defPos, name);
        this.pos = pos;
        this.rotation = rot;
        this.mirror = mirror;
        this.enabled = enabled;
        this.renderingEnabled = renderingEnabled;
        this.ignoreEntities = ignoreEntities;
        this.coordinateLockMask = coordinateLockMask;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean ignoreEntities() {
        return this.ignoreEntities;
    }

    public boolean matchesRequirement(RequiredEnabled required) {
        if (required == RequiredEnabled.ANY) {
            return true;
        }
        if (required == RequiredEnabled.PLACEMENT_ENABLED) {
            return this.isEnabled();
        }
        Servux.LOGGER.warn("RequiredEnabled.RENDERING_ENABLED is not supported on server side!");
        return false;
    }

    public String getName() {
        return this.name;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2470 getRotation() {
        return this.rotation;
    }

    public class_2415 getMirror() {
        return this.mirror;
    }

    void toggleIgnoreEntities() {
        this.ignoreEntities = !this.ignoreEntities;
    }

    void setPos(class_2338 pos) {
        this.pos = pos;
    }

    void setRotation(class_2470 rotation) {
        this.rotation = rotation;
    }

    void setMirror(class_2415 mirror) {
        this.mirror = mirror;
    }

    void resetToOriginalValues() {
        this.pos = this.defaultPos;
        this.rotation = class_2470.field_11467;
        this.mirror = class_2415.field_11302;
        this.enabled = true;
        this.ignoreEntities = false;
    }

    public boolean isRegionPlacementModifiedFromDefault() {
        return this.isRegionPlacementModified(this.defaultPos);
    }

    public boolean isRegionPlacementModified(class_2338 originalPosition) {
        return !this.isEnabled() || this.ignoreEntities() || this.getMirror() != class_2415.field_11302 || this.getRotation() != class_2470.field_11467 || !this.getPos().equals((Object)originalPosition);
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        arr.add((Number)this.pos.method_10263());
        arr.add((Number)this.pos.method_10264());
        arr.add((Number)this.pos.method_10260());
        obj.add("pos", (JsonElement)arr);
        obj.add("name", (JsonElement)new JsonPrimitive(this.getName()));
        obj.add("rotation", (JsonElement)new JsonPrimitive(this.rotation.name()));
        obj.add("mirror", (JsonElement)new JsonPrimitive(this.mirror.name()));
        obj.add("locked_coords", (JsonElement)new JsonPrimitive((Number)0));
        obj.add("enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.enabled)));
        obj.add("rendering_enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        obj.add("ignore_entities", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.ignoreEntities)));
        return obj;
    }

    public static enum RequiredEnabled {
        ANY,
        PLACEMENT_ENABLED,
        RENDERING_ENABLED;

    }
}

