/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui;

import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.gui.GuiLifecycleProvider;
import com.tttsaurus.ingameinfo.common.core.gui.IgiGuiContainer;
import com.tttsaurus.ingameinfo.common.core.input.InputFrameGenerator;
import com.tttsaurus.ingameinfo.common.core.mvvm.registry.MvvmRegistry;

public abstract class GuiLifecycleHolder {
    private final String holderName;
    private GuiLifecycleProvider lifecycleProvider;
    protected final InputFrameGenerator inputGen;

    public final String getHolderName() {
        return this.holderName;
    }

    public final void setLifecycleProvider(GuiLifecycleProvider provider) {
        this.lifecycleProvider = provider;
        InternalMethods.instance.GuiLifecycleProvider$lifecycleHolderName$setter.invoke(provider, this.holderName);
    }

    public final GuiLifecycleProvider getLifecycleProvider() {
        return this.lifecycleProvider;
    }

    protected GuiLifecycleHolder(String holderName, InputFrameGenerator inputGen) {
        this.holderName = holderName;
        this.inputGen = inputGen;
    }

    public final void openGui(String mvvmRegistryName, MvvmRegistry mvvmRegistry) {
        if (this.lifecycleProvider == null) {
            return;
        }
        IgiGuiContainer container = mvvmRegistry.getIgiGuiContainer(mvvmRegistryName);
        if (container == null) {
            return;
        }
        container.prepareGuiOpen();
        this.lifecycleProvider.openIgiGui(mvvmRegistryName, container);
    }

    public final void closeGui(String mvvmRegistryName, MvvmRegistry mvvmRegistry) {
        if (this.lifecycleProvider == null) {
            return;
        }
        IgiGuiContainer container = mvvmRegistry.getIgiGuiContainer(mvvmRegistryName);
        if (container == null) {
            return;
        }
        container.onGuiClose();
        this.lifecycleProvider.closeIgiGui(mvvmRegistryName);
    }

    public abstract void update();
}

