/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui;

import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.commonutils.GhostableItem;
import com.tttsaurus.ingameinfo.common.core.function.IFunc;
import com.tttsaurus.ingameinfo.common.core.gui.layout.MainGroup;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.RenderDecorator;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.gui.theme.registry.ThemeRegistry;
import com.tttsaurus.ingameinfo.common.core.input.InputState;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.SlotAccessor;
import com.tttsaurus.ingameinfo.common.core.mvvm.compose.ComposeBlock;
import com.tttsaurus.ingameinfo.common.core.mvvm.registry.MvvmRegistry;
import com.tttsaurus.ingameinfo.common.core.mvvm.viewmodel.ViewModel;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import java.util.ArrayList;
import java.util.List;

public class IgiGuiContainer {
    protected ViewModel<?> viewModel;
    protected boolean useHeldItemWhitelist = false;
    protected final List<GhostableItem> heldItemWhitelist = new ArrayList<GhostableItem>();
    protected boolean useHeldItemBlacklist = false;
    protected final List<GhostableItem> heldItemBlacklist = new ArrayList<GhostableItem>();
    protected MainGroup mainGroup = new MainGroup();
    protected boolean debug = false;
    protected int exitKeyForFocusedGui = 1;
    protected boolean isFocused = false;
    protected boolean hasFocusBackground = true;
    protected int backgroundColor = -1072689136;
    protected String themeName = "default";
    private ThemeConfig themeConfig;
    private boolean prepareGuiOpen = false;
    private boolean initFlag = false;
    private boolean isActive = true;
    private IFunc<Boolean> exitCallback = () -> true;

    private void resetDef() {
        this.useHeldItemWhitelist = false;
        this.heldItemWhitelist.clear();
        this.useHeldItemBlacklist = false;
        this.heldItemBlacklist.clear();
        this.debug = false;
        this.exitKeyForFocusedGui = 1;
        this.isFocused = false;
        this.hasFocusBackground = true;
        this.backgroundColor = -1072689136;
        this.themeName = "default";
    }

    public boolean getPrepareGuiOpen() {
        return this.prepareGuiOpen;
    }

    public boolean getActive() {
        return this.isActive;
    }

    public IFunc<Boolean> getExitCallback() {
        return this.exitCallback;
    }

    public int getExitKeyForFocusedGui() {
        return this.exitKeyForFocusedGui;
    }

    public boolean getFocused() {
        return this.isFocused;
    }

    public boolean getUseHeldItemWhitelist() {
        return this.useHeldItemWhitelist;
    }

    public boolean getUseHeldItemBlacklist() {
        return this.useHeldItemBlacklist;
    }

    public List<GhostableItem> getHeldItemWhitelist() {
        return this.heldItemWhitelist;
    }

    public List<GhostableItem> getHeldItemBlacklist() {
        return this.heldItemBlacklist;
    }

    public ThemeConfig getThemeConfig() {
        return this.themeConfig;
    }

    public RenderDecorator getRenderDecorator() {
        return InternalMethods.instance.ViewModel$getRenderDecorator.invoke(this.viewModel);
    }

    protected IgiGuiContainer() {
    }

    public void onInit() {
        if (this.initFlag) {
            return;
        }
        this.initFlag = true;
        this.themeConfig = ThemeRegistry.getTheme(this.themeName);
        this.mainGroup.applyLogicTheme(this.themeConfig);
        InternalMethods.instance.ViewModel$isActiveGetter$setter.invoke(this.viewModel, () -> this.isActive);
        InternalMethods.instance.ViewModel$isActiveSetter$setter.invoke(this.viewModel, flag -> {
            this.isActive = flag;
        });
        InternalMethods.instance.ViewModel$exitCallbackSetter$setter.invoke(this.viewModel, callback -> {
            this.exitCallback = callback;
        });
        InternalMethods.instance.ViewModel$isFocusedGetter$setter.invoke(this.viewModel, () -> this.isFocused);
        InternalMethods.instance.ViewModel$isFocusedSetter$setter.invoke(this.viewModel, focused -> {
            this.isFocused = focused;
        });
        this.viewModel.onStart();
        List<SlotAccessor> slotAccessors = InternalMethods.instance.ViewModel$slotAccessors$getter.invoke(this.viewModel);
        for (SlotAccessor slotAccessor : slotAccessors) {
            ComposeBlock composeBlock = slotAccessor.getComposeBlock();
            if (composeBlock == null) continue;
            composeBlock.updateTheme(this.themeConfig);
            composeBlock.update(0.0, InternalMethods.instance.ViewModel$sharedContext$getter.invoke(this.viewModel));
        }
        this.mainGroup.calcWidthHeight();
        this.mainGroup.calcRenderPos(this.mainGroup.rect);
        this.mainGroup.finishReCalc();
        this.mainGroup.onCollectLerpInfo();
    }

    public void onScaledResolutionResize() {
        this.mainGroup.resetRenderInfo();
        this.mainGroup.calcWidthHeight();
        this.mainGroup.calcRenderPos(this.mainGroup.rect);
        this.mainGroup.finishReCalc();
    }

    public void onFixedUpdate(double deltaTime) {
        if (!this.isActive) {
            return;
        }
        List<SlotAccessor> slotAccessors = InternalMethods.instance.ViewModel$slotAccessors$getter.invoke(this.viewModel);
        for (SlotAccessor slotAccessor : slotAccessors) {
            if (slotAccessor.getComposeBlock() == null) continue;
            slotAccessor.getComposeBlock().update(deltaTime, InternalMethods.instance.ViewModel$sharedContext$getter.invoke(this.viewModel));
        }
        this.viewModel.onFixedUpdate(deltaTime);
        this.mainGroup.onFixedUpdate(deltaTime);
        if (this.mainGroup.getNeedReCalc()) {
            this.mainGroup.resetRenderInfo();
            this.mainGroup.calcWidthHeight();
            this.mainGroup.calcRenderPos(this.mainGroup.rect);
            this.mainGroup.finishReCalc();
        }
        this.mainGroup.onCollectLerpInfo();
    }

    public RenderOpQueue onRenderUpdate(boolean focused) {
        if (!this.isActive) {
            return new RenderOpQueue();
        }
        if (this.isFocused && this.hasFocusBackground) {
            RenderUtils.renderRectFullScreen(this.backgroundColor);
        }
        RenderOpQueue queue = new RenderOpQueue();
        this.mainGroup.onRenderUpdate(queue, focused);
        if (this.debug) {
            this.mainGroup.renderDebugRect(queue);
        }
        return queue;
    }

    public void onPropagateInput(InputState inputState) {
        if (!this.isActive) {
            return;
        }
        this.mainGroup.onPropagateInput(inputState);
    }

    public void prepareGuiOpen() {
        this.prepareGuiOpen = true;
    }

    public void onGuiOpen() {
        this.prepareGuiOpen = false;
        this.viewModel.onGuiOpen();
    }

    public void onGuiClose() {
        this.viewModel.onGuiClose();
    }

    public void refreshVvm(MvvmRegistry mvvmRegistry) {
        this.resetDef();
        this.viewModel.refresh(this, mvvmRegistry);
        this.themeConfig = ThemeRegistry.getTheme(this.themeName);
        this.mainGroup.applyLogicTheme(this.themeConfig);
        this.viewModel.onStart();
        List<SlotAccessor> slotAccessors = InternalMethods.instance.ViewModel$slotAccessors$getter.invoke(this.viewModel);
        for (SlotAccessor slotAccessor : slotAccessors) {
            ComposeBlock composeBlock = slotAccessor.getComposeBlock();
            if (composeBlock == null) continue;
            composeBlock.clear();
            composeBlock.updateTheme(this.themeConfig);
            composeBlock.update(0.0, InternalMethods.instance.ViewModel$sharedContext$getter.invoke(this.viewModel));
        }
        this.mainGroup.calcWidthHeight();
        this.mainGroup.calcRenderPos(this.mainGroup.rect);
        this.mainGroup.finishReCalc();
        this.mainGroup.onCollectLerpInfo();
    }
}

