/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.gui.layout;

import java.util.Objects;
import javax.annotation.Nullable;

public class Rect {
    public float x;
    public float y;
    public float width;
    public float height;

    public Rect(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void set(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean contains(float x, float y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
    }

    public boolean contains(Rect rect) {
        return rect.x >= this.x && rect.x + rect.width <= this.x + this.width && rect.y >= this.y && rect.y + rect.height <= this.y + this.height;
    }

    @Nullable
    public Rect intersect(Rect rect2) {
        if (rect2 == null) {
            return null;
        }
        float x1 = Math.max(this.x, rect2.x);
        float y1 = Math.max(this.y, rect2.y);
        float x2 = Math.min(this.x + this.width, rect2.x + rect2.width);
        float y2 = Math.min(this.y + this.height, rect2.y + rect2.height);
        float width = x2 - x1;
        float height = y2 - y1;
        if (width > 0.0f && height > 0.0f) {
            return new Rect(x1, y1, width, height);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rect)) {
            return false;
        }
        Rect rect = (Rect)o;
        return Float.compare(this.x, rect.x) == 0 && Float.compare(this.y, rect.y) == 0 && Float.compare(this.width, rect.width) == 0 && Float.compare(this.height, rect.height) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.width), Float.valueOf(this.height));
    }
}

