/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.input;

import com.tttsaurus.ingameinfo.common.core.input.IKeyboard;
import com.tttsaurus.ingameinfo.common.core.input.Key;
import java.util.HashSet;
import java.util.Set;
import org.lwjgl.input.Keyboard;

public class IgiKeyboard
implements IKeyboard {
    private final Set<Integer> heldKeys = new HashSet<Integer>();
    private final Set<Integer> pressedKeys = new HashSet<Integer>();
    private final Set<Integer> leftKeys = new HashSet<Integer>();

    @Override
    public Set<Integer> getHeldKeys() {
        return this.heldKeys;
    }

    @Override
    public Set<Integer> getPressedKeys() {
        return this.pressedKeys;
    }

    @Override
    public Set<Integer> getLeftKeys() {
        return this.leftKeys;
    }

    @Override
    public void updateInput() {
        HashSet<Integer> copy = new HashSet<Integer>(this.heldKeys);
        this.heldKeys.clear();
        this.pressedKeys.clear();
        this.leftKeys.clear();
        for (int key = 1; key <= 223; ++key) {
            boolean down = Keyboard.isKeyDown((int)key);
            if (down) {
                this.heldKeys.add(key);
            }
            if (!copy.contains(key) && down) {
                this.pressedKeys.add(key);
            }
            if (!copy.contains(key) || down) continue;
            this.leftKeys.add(key);
        }
    }

    @Override
    public boolean keyPress(Key key) {
        return this.pressedKeys.contains(key.keycode);
    }

    @Override
    public boolean keyLeave(Key key) {
        return this.leftKeys.contains(key.keycode);
    }

    @Override
    public boolean keyDown(Key key) {
        return this.heldKeys.contains(key.keycode);
    }
}

