/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.input;

import com.tttsaurus.ingameinfo.common.core.commonutils.MouseUtils;
import com.tttsaurus.ingameinfo.common.core.input.IMouse;

public class IgiMouse
implements IMouse {
    private boolean leftDown;
    private boolean leftPress;
    private boolean leftLeave;
    private boolean rightDown;
    private boolean rightPress;
    private boolean rightLeave;
    private float posX;
    private float posY;
    private float deltaPosX;
    private float deltaPosY;

    @Override
    public void updateInput() {
        boolean ld = MouseUtils.isMouseDownLeft();
        boolean rd = MouseUtils.isMouseDownRight();
        this.leftPress = !this.leftDown && ld;
        this.rightPress = !this.rightDown && rd;
        this.leftLeave = this.leftDown && !ld;
        this.rightLeave = this.rightDown && !rd;
        this.leftDown = ld;
        this.rightDown = rd;
        float px = MouseUtils.getMouseX();
        float py = MouseUtils.getMouseY();
        this.deltaPosX = px - this.posX;
        this.deltaPosY = py - this.posY;
        this.posX = px;
        this.posY = py;
    }

    @Override
    public boolean isLeftDown() {
        return this.leftDown;
    }

    @Override
    public boolean isLeftPress() {
        return this.leftPress;
    }

    @Override
    public boolean isLeftLeave() {
        return this.leftLeave;
    }

    @Override
    public boolean isRightDown() {
        return this.rightDown;
    }

    @Override
    public boolean isRightPress() {
        return this.rightPress;
    }

    @Override
    public boolean isRightLeave() {
        return this.rightLeave;
    }

    @Override
    public float getPosX() {
        return this.posX;
    }

    @Override
    public float getPosY() {
        return this.posY;
    }

    @Override
    public float getDeltaPosX() {
        return this.deltaPosX;
    }

    @Override
    public float getDeltaPosY() {
        return this.deltaPosY;
    }
}

