/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.input;

import java.util.Objects;
import java.util.Set;

public class InputState {
    public final Set<Integer> heldKeys;
    public final Set<Integer> pressedKeys;
    public final Set<Integer> leftKeys;
    public final boolean leftDown;
    public final boolean leftPress;
    public final boolean leftLeave;
    public final boolean rightDown;
    public final boolean rightPress;
    public final boolean rightLeave;
    public final float posX;
    public final float posY;
    public final float deltaPosX;
    public final float deltaPosY;
    private boolean consumed = false;

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }

    public InputState(Set<Integer> heldKeys, Set<Integer> pressedKeys, Set<Integer> leftKeys, boolean leftDown, boolean leftPress, boolean leftLeave, boolean rightDown, boolean rightPress, boolean rightLeave, float posX, float posY, float deltaPosX, float deltaPosY) {
        this.heldKeys = heldKeys;
        this.pressedKeys = pressedKeys;
        this.leftKeys = leftKeys;
        this.leftDown = leftDown;
        this.leftPress = leftPress;
        this.leftLeave = leftLeave;
        this.rightDown = rightDown;
        this.rightPress = rightPress;
        this.rightLeave = rightLeave;
        this.posX = posX;
        this.posY = posY;
        this.deltaPosX = deltaPosX;
        this.deltaPosY = deltaPosY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputState)) {
            return false;
        }
        InputState state = (InputState)o;
        return this.leftDown == state.leftDown && this.leftPress == state.leftPress && this.leftLeave == state.leftLeave && this.rightDown == state.rightDown && this.rightPress == state.rightPress && this.rightLeave == state.rightLeave && Float.compare(this.posX, state.posX) == 0 && Float.compare(this.posY, state.posY) == 0 && Float.compare(this.deltaPosX, state.deltaPosX) == 0 && Float.compare(this.deltaPosY, state.deltaPosY) == 0 && Objects.equals(this.heldKeys, state.heldKeys) && Objects.equals(this.pressedKeys, state.pressedKeys) && Objects.equals(this.leftKeys, state.leftKeys);
    }

    public int hashCode() {
        return Objects.hash(this.heldKeys, this.pressedKeys, this.leftKeys, this.leftDown, this.leftPress, this.leftLeave, this.rightDown, this.rightPress, this.rightLeave, Float.valueOf(this.posX), Float.valueOf(this.posY), Float.valueOf(this.deltaPosX), Float.valueOf(this.deltaPosY));
    }
}

