/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.binding;

import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.function.IAction_1Param;
import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.GuiLayout;
import com.tttsaurus.ingameinfo.common.core.gui.IgiGuiContainer;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.MainGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Slot;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertyGetter;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertySetter;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.IStylePropertySyncTo;
import com.tttsaurus.ingameinfo.common.core.gui.registry.ElementRegistry;
import com.tttsaurus.ingameinfo.common.core.gui.render.decorator.RenderDecorator;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.Reactive;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveCollection;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveObject;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.SlotAccessor;
import com.tttsaurus.ingameinfo.common.core.mvvm.view.View;
import com.tttsaurus.ingameinfo.common.core.mvvm.viewmodel.ViewModel;
import com.tttsaurus.ingameinfo.common.core.reflection.TypeUtils;
import com.tttsaurus.ingameinfo.plugin.crt.impl.CrtView;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Map;

public class VvmBinding<TView extends View> {
    public TView view = null;

    public GuiLayout init(ViewModel<TView> viewModel, String mvvmRegistryName) {
        Class viewClass = (Class)((ParameterizedType)viewModel.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        try {
            this.view = (View)viewClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CrtView.class.isAssignableFrom(viewClass)) {
            ((CrtView)this.view).runtimeMvvm = mvvmRegistryName;
        }
        GuiLayout guiLayout = InternalMethods.instance.View$init.invoke((View)this.view, (IgiGuiContainer)null);
        MainGroup mainGroup = InternalMethods.instance.GuiLayout$mainGroup$getter.invoke(guiLayout);
        InternalMethods.instance.View$mainGroup$setter.invoke((View)this.view, mainGroup);
        RenderDecorator renderDecorator = new RenderDecorator();
        ((View)this.view).initRenderDecorator(renderDecorator);
        InternalMethods.instance.View$renderDecorator$setter.invoke((View)this.view, renderDecorator);
        return guiLayout;
    }

    public <T> void bindReactiveObject(Reactive reactive, ReactiveObject<T> reactiveObject) {
        Class reactiveObjectParameter;
        if (reactiveObject == null) {
            return;
        }
        if (reactive.targetUid().isEmpty()) {
            return;
        }
        if (reactive.property().isEmpty()) {
            return;
        }
        try {
            reactiveObjectParameter = (Class)((ParameterizedType)reactiveObject.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Exception ignored) {
            return;
        }
        int index = 0;
        List<Element> elements = ((View)this.view).getElements(reactive.targetUid());
        for (Element element : elements) {
            if (reactive.ordinal() != -1 && reactive.ordinal() != index++) continue;
            IStylePropertySetter stylePropertySetter = ElementRegistry.getStylePropertySetter(element.getClass(), reactive.property());
            Class<?> stylePropertyClass = ElementRegistry.getStylePropertyClass(stylePropertySetter);
            if (stylePropertySetter == null || stylePropertyClass == null || !TypeUtils.looseTypeCheck(reactiveObjectParameter, stylePropertyClass)) continue;
            if (reactive.initiativeSync()) {
                IAction_1Param<Object> action = ElementRegistry.getStylePropertySetterFullCallback(element, reactive.property());
                reactiveObject.initiativeCallbacks.add(value -> action.invoke(value));
            }
            if (!reactive.passiveSync()) continue;
            Map<String, IStylePropertySyncTo> syncToMap = InternalMethods.instance.Element$syncToMap$getter.invoke(element);
            IStylePropertyGetter getter = ElementRegistry.getStylePropertyGetter(stylePropertySetter);
            if (getter == null) continue;
            syncToMap.put(reactive.property(), () -> reactiveObject.setInternal(getter.get(element)));
            reactiveObject.setInternal(getter.get(element));
        }
    }

    public void bindReactiveCollection(Reactive reactive, ReactiveCollection reactiveCollection) {
        if (reactiveCollection == null) {
            return;
        }
        if (reactive.targetUid().isEmpty()) {
            return;
        }
        int index = 0;
        List<Element> elements = ((View)this.view).getElements(reactive.targetUid());
        for (Element element : elements) {
            if (reactive.ordinal() != -1 && reactive.ordinal() != index++ || !ElementGroup.class.isAssignableFrom(element.getClass())) continue;
            reactiveCollection.group = (ElementGroup)element;
        }
    }

    public void bindSlotAccessor(Reactive reactive, SlotAccessor slotAccessor) {
        if (slotAccessor == null) {
            return;
        }
        if (reactive.targetUid().isEmpty()) {
            return;
        }
        int index = 0;
        List<Element> elements = ((View)this.view).getElements(reactive.targetUid());
        for (Element element : elements) {
            if (reactive.ordinal() != -1 && reactive.ordinal() != index++ || !Slot.class.isAssignableFrom(element.getClass())) continue;
            slotAccessor.group = (ElementGroup)element;
        }
    }
}

