/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.compose;

import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.registry.ElementRegistry;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.mvvm.compose.ComposeNodeWorkspace;
import com.tttsaurus.ingameinfo.common.core.mvvm.compose.ComposeValidator;
import com.tttsaurus.ingameinfo.common.core.mvvm.compose.SnapshotTree;
import com.tttsaurus.ingameinfo.common.core.mvvm.compose.UpdatePlan;
import com.tttsaurus.ingameinfo.common.core.mvvm.context.SharedContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ComposeBlock {
    private final ElementGroup root;
    private SnapshotTree prevSnapshot = null;
    private SnapshotTree currSnapshot = new SnapshotTree();
    private final ComposeValidator validator;
    private final AtomicInteger sysKeyCounter = new AtomicInteger(0);
    private final AtomicBoolean abortThisFrame = new AtomicBoolean(false);
    private ThemeConfig themeConfig;

    public ComposeBlock(ElementGroup root) {
        this.root = root;
        this.validator = ComposeValidator.getInstance();
    }

    public final void clear() {
        this.root.elements.clear();
        this.prevSnapshot = null;
        this.currSnapshot = new SnapshotTree();
        this.sysKeyCounter.set(0);
        this.abortThisFrame.set(false);
    }

    public final void updateTheme(ThemeConfig themeConfig) {
        this.themeConfig = themeConfig;
    }

    public final void update(double deltaTime, SharedContext sharedContext) {
        this.compose(deltaTime, sharedContext);
        boolean abort = this.abortThisFrame.get();
        this.sysKeyCounter.set(0);
        this.abortThisFrame.set(false);
        if (abort) {
            this.currSnapshot = new SnapshotTree();
        } else {
            List<UpdatePlan> updatePlans = this.prevSnapshot == null ? this.currSnapshot.addAll() : this.prevSnapshot.diff(this.currSnapshot);
            this.prevSnapshot = this.currSnapshot;
            this.currSnapshot = new SnapshotTree();
            if (this.reConstruct(updatePlans)) {
                this.root.requestReCalc();
            }
        }
    }

    private void recursiveReConstruct(ElementGroup root, List<UpdatePlan> updatePlans, AtomicInteger indexCounter) {
        if (indexCounter.get() >= updatePlans.size()) {
            return;
        }
        UpdatePlan plan = updatePlans.get(indexCounter.get());
        switch (plan.actionType) {
            case ADD: {
                Element element = ElementRegistry.newElement(plan.newElementName);
                if (element != null) {
                    element.applyLogicTheme(this.themeConfig);
                    root.add(plan.index, element);
                    for (Map.Entry<String, Object> entry : plan.newStyleProperties.entrySet()) {
                        element.setStyleProperty(entry.getKey(), entry.getValue());
                    }
                }
                indexCounter.incrementAndGet();
                break;
            }
            case SWAP: {
                Collections.swap(root.elements, plan.index, plan.swapIndex);
                indexCounter.incrementAndGet();
                break;
            }
            case REMOVE: {
                root.elements.remove(plan.index);
                indexCounter.incrementAndGet();
                break;
            }
            case UPDATE_PROP: {
                Element element = root.elements.get(plan.index);
                element.setStyleProperty(plan.stylePropertyName, plan.stylePropertyOverride);
                indexCounter.incrementAndGet();
                break;
            }
            case GOTO_NEXT_LAYER: {
                indexCounter.incrementAndGet();
                this.recursiveReConstruct((ElementGroup)root.elements.get(plan.index), updatePlans, indexCounter);
                break;
            }
            case GOTO_PREV_LAYER: {
                indexCounter.incrementAndGet();
                return;
            }
        }
        this.recursiveReConstruct(root, updatePlans, indexCounter);
    }

    private boolean reConstruct(List<UpdatePlan> updatePlans) {
        boolean needReCalc = false;
        for (UpdatePlan plan : updatePlans) {
            if (plan.actionType == UpdatePlan.ActionType.UPDATE_PROP || plan.actionType == UpdatePlan.ActionType.GOTO_NEXT_LAYER || plan.actionType == UpdatePlan.ActionType.GOTO_PREV_LAYER) continue;
            needReCalc = true;
            break;
        }
        this.recursiveReConstruct(this.root, updatePlans, new AtomicInteger(0));
        return needReCalc;
    }

    public abstract void compose(double var1, SharedContext var3);

    protected final ComposeNodeWorkspace ui(String name) {
        if (!this.validator.element(name)) {
            this.validator.error(name + " is not a valid Element. This frame will be aborted.");
            this.abortThisFrame.set(true);
        }
        return new ComposeNodeWorkspace(this.currSnapshot.add(name, this.sysKeyCounter.getAndIncrement()), this.currSnapshot, this.sysKeyCounter, this.validator, this.abortThisFrame);
    }
}

