/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.mvvm.registry;

import com.tttsaurus.ingameinfo.common.core.mvvm.binding.IReactiveCollectionGetter;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.IReactiveObjectGetter;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ISlotAccessorGetter;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.Reactive;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveCollection;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveObject;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.SlotAccessor;
import com.tttsaurus.ingameinfo.common.core.mvvm.viewmodel.ViewModel;
import com.tttsaurus.ingameinfo.plugin.crt.impl.CrtViewModel;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Tuple;

public final class RegistryUtils {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static final Class<Reactive> annotation = Reactive.class;

    public static Map<Reactive, IReactiveObjectGetter> findReactiveObjects(String mvvmRegistryName, Class<? extends ViewModel<?>> clazz) {
        HashMap<Reactive, IReactiveObjectGetter> reactiveObjects = new HashMap<Reactive, IReactiveObjectGetter>();
        if (CrtViewModel.class.isAssignableFrom(clazz)) {
            Map<String, Tuple<Reactive, ReactiveObject<?>>> def = CrtViewModel.reactiveObjectDefs.get(mvvmRegistryName);
            if (def != null) {
                for (Tuple<Reactive, ReactiveObject<?>> tuple : def.values()) {
                    reactiveObjects.put((Reactive)tuple.func_76341_a(), target -> (ReactiveObject)tuple.func_76340_b());
                }
            }
            return reactiveObjects;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            Reactive reactive = field.getAnnotation(annotation);
            try {
                Class<?> fieldClass = field.getType();
                String fieldName = field.getName();
                if (!ReactiveObject.class.equals(fieldClass)) continue;
                MethodHandle getter = lookup.findGetter(clazz, fieldName, fieldClass);
                IReactiveObjectGetter wrappedGetter = target -> {
                    try {
                        return getter.invoke(target);
                    }
                    catch (Throwable ignored) {
                        return null;
                    }
                };
                reactiveObjects.put(reactive, wrappedGetter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return reactiveObjects;
    }

    public static Map<Reactive, IReactiveCollectionGetter> findReactiveCollections(String mvvmRegistryName, Class<? extends ViewModel<?>> clazz) {
        HashMap<Reactive, IReactiveCollectionGetter> reactiveCollections = new HashMap<Reactive, IReactiveCollectionGetter>();
        if (CrtViewModel.class.isAssignableFrom(clazz)) {
            Map<String, Tuple<Reactive, ReactiveCollection>> def = CrtViewModel.reactiveCollectionDefs.get(mvvmRegistryName);
            if (def != null) {
                for (Tuple<Reactive, ReactiveCollection> tuple : def.values()) {
                    reactiveCollections.put((Reactive)tuple.func_76341_a(), target -> (ReactiveCollection)tuple.func_76340_b());
                }
            }
            return reactiveCollections;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            Reactive reactive = field.getAnnotation(annotation);
            try {
                Class<?> fieldClass = field.getType();
                String fieldName = field.getName();
                if (!ReactiveCollection.class.equals(fieldClass)) continue;
                MethodHandle getter = lookup.findGetter(clazz, fieldName, fieldClass);
                IReactiveCollectionGetter wrappedGetter = target -> {
                    try {
                        return getter.invoke(target);
                    }
                    catch (Throwable ignored) {
                        return null;
                    }
                };
                reactiveCollections.put(reactive, wrappedGetter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return reactiveCollections;
    }

    public static Map<Reactive, ISlotAccessorGetter> findSlotAccessors(String mvvmRegistryName, Class<? extends ViewModel<?>> clazz) {
        HashMap<Reactive, ISlotAccessorGetter> slotAccessors = new HashMap<Reactive, ISlotAccessorGetter>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            Reactive reactive = field.getAnnotation(annotation);
            try {
                Class<?> fieldClass = field.getType();
                String fieldName = field.getName();
                if (!SlotAccessor.class.equals(fieldClass)) continue;
                MethodHandle getter = lookup.findGetter(clazz, fieldName, fieldClass);
                ISlotAccessorGetter wrappedGetter = target -> {
                    try {
                        return getter.invoke(target);
                    }
                    catch (Throwable ignored) {
                        return null;
                    }
                };
                slotAccessors.put(reactive, wrappedGetter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return slotAccessors;
    }
}

