/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.reflection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class FieldUtils {
    public static Field getFieldByNameIncludingSuperclasses(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        List<Field> fields = FieldUtils.getAllFieldsIncludingSuperclasses(clazz);
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new NoSuchFieldException("Cannot find " + fieldName + " from " + clazz.getName() + " including its superclasses.");
    }

    public static List<Field> getAllFieldsIncludingSuperclasses(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = current.getDeclaredFields()) {
                field.setAccessible(true);
                fields.add(field);
            }
        }
        return fields;
    }
}

