/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.render;

import com.tttsaurus.ingameinfo.common.core.function.IFunc;
import com.tttsaurus.ingameinfo.common.core.render.texture.param.FilterMode;
import com.tttsaurus.ingameinfo.common.core.render.texture.param.WrapMode;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public final class RenderHints {
    private static boolean glVersionParsed = false;
    private static int majorGlVersion = -1;
    private static int minorGlVersion = -1;
    private static String rawGlVersion = "";
    private static GlStateManager.BindTextureHint hint_GlStateManager$BindTextureHint = GlStateManager.BindTextureHint.TEXTURE_2D;
    private static Framebuffer.CreateFramebufferHint hint_Framebuffer$CreateFramebufferHint = Framebuffer.CreateFramebufferHint.TEXTURE_2D;
    private static Framebuffer.FramebufferClearHint hint_Framebuffer$FramebufferClearHint = Framebuffer.FramebufferClearHint.UNBIND_FBO;
    private static int hint_Framebuffer$FramebufferSampleNum = 2;
    private static FilterMode hint_Texture2D$FilterModeMin = FilterMode.LINEAR;
    private static FilterMode hint_Texture2D$FilterModeMag = FilterMode.LINEAR;
    private static WrapMode hint_Texture2D$WrapModeS = WrapMode.CLAMP;
    private static WrapMode hint_Texture2D$WrapModeT = WrapMode.CLAMP;
    private static float hint_pixelPerUnit = 1.0f;
    private static boolean isActiveRenderInfoGettersInit = false;
    private static IFunc<FloatBuffer> modelViewMatrixGetter;
    private static IFunc<FloatBuffer> projectionMatrixGetter;
    private static boolean isPartialTickGetterInit;
    private static IFunc<Double> partialTickGetter;

    public static int getMajorGlVersion() {
        if (!glVersionParsed) {
            RenderHints.parseGlVersion();
        }
        return majorGlVersion;
    }

    public static int getMinorGlVersion() {
        if (!glVersionParsed) {
            RenderHints.parseGlVersion();
        }
        return minorGlVersion;
    }

    public static String getRawGlVersion() {
        if (!glVersionParsed) {
            RenderHints.parseGlVersion();
        }
        return rawGlVersion;
    }

    private static void parseGlVersion() {
        glVersionParsed = true;
        rawGlVersion = GL11.glGetString((int)7938);
        if (rawGlVersion != null) {
            String[] parts = rawGlVersion.split("\\s+")[0].split("\\.");
            if (parts.length >= 2) {
                try {
                    majorGlVersion = Integer.parseInt(parts[0]);
                    minorGlVersion = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            rawGlVersion = "";
        }
        if (rawGlVersion.isEmpty() || majorGlVersion == -1 || minorGlVersion == -1) {
            throw new RuntimeException("RenderHints.parseGlVersion() failed to parse GL version.");
        }
    }

    public static void multisampleTexBind() {
        hint_GlStateManager$BindTextureHint = GlStateManager.BindTextureHint.TEXTURE_2D_MULTISAMPLE;
    }

    public static void defaultTexBind() {
        hint_GlStateManager$BindTextureHint = GlStateManager.BindTextureHint.TEXTURE_2D;
    }

    public static void multisampleFbo() {
        hint_Framebuffer$CreateFramebufferHint = Framebuffer.CreateFramebufferHint.TEXTURE_2D_MULTISAMPLE;
    }

    public static void defaultFbo() {
        hint_Framebuffer$CreateFramebufferHint = Framebuffer.CreateFramebufferHint.TEXTURE_2D;
    }

    public static void clearFboWithoutUnbind() {
        hint_Framebuffer$FramebufferClearHint = Framebuffer.FramebufferClearHint.DONT_UNBIND_FBO;
    }

    public static void clearFboWithUnbind() {
        hint_Framebuffer$FramebufferClearHint = Framebuffer.FramebufferClearHint.UNBIND_FBO;
    }

    public static void fboSampleNum(int num) {
        if (num < 1) {
            num = 1;
        }
        if (num > 4) {
            num = 4;
        }
        hint_Framebuffer$FramebufferSampleNum = num;
    }

    public static void texture2dLinearFilterMin() {
        hint_Texture2D$FilterModeMin = FilterMode.LINEAR;
    }

    public static void texture2dNearestFilterMin() {
        hint_Texture2D$FilterModeMin = FilterMode.NEAREST;
    }

    public static void texture2dLinearFilterMag() {
        hint_Texture2D$FilterModeMag = FilterMode.LINEAR;
    }

    public static void texture2dNearestFilterMag() {
        hint_Texture2D$FilterModeMag = FilterMode.NEAREST;
    }

    public static void texture2dRepeatWrapS() {
        hint_Texture2D$WrapModeS = WrapMode.REPEAT;
    }

    public static void texture2dClampWrapS() {
        hint_Texture2D$WrapModeS = WrapMode.CLAMP;
    }

    public static void texture2dClampToEdgeWrapS() {
        hint_Texture2D$WrapModeS = WrapMode.CLAMP_TO_EDGE;
    }

    public static void texture2dClampToBorderWrapS() {
        hint_Texture2D$WrapModeS = WrapMode.CLAMP_TO_BORDER;
    }

    public static void texture2dMirroredRepeatWrapS() {
        hint_Texture2D$WrapModeS = WrapMode.MIRRORED_REPEAT;
    }

    public static void texture2dRepeatWrapT() {
        hint_Texture2D$WrapModeT = WrapMode.REPEAT;
    }

    public static void texture2dClampWrapT() {
        hint_Texture2D$WrapModeT = WrapMode.CLAMP;
    }

    public static void texture2dClampToEdgeWrapT() {
        hint_Texture2D$WrapModeT = WrapMode.CLAMP_TO_EDGE;
    }

    public static void texture2dClampToBorderWrapT() {
        hint_Texture2D$WrapModeT = WrapMode.CLAMP_TO_BORDER;
    }

    public static void texture2dMirroredRepeatWrapT() {
        hint_Texture2D$WrapModeT = WrapMode.MIRRORED_REPEAT;
    }

    public static void pixelPerUnit(float pixel) {
        hint_pixelPerUnit = pixel;
    }

    public static void setHint_GlStateManager$BindTextureHint(GlStateManager.BindTextureHint hint) {
        hint_GlStateManager$BindTextureHint = hint;
    }

    public static void setHint_Framebuffer$CreateFramebufferHint(Framebuffer.CreateFramebufferHint hint) {
        hint_Framebuffer$CreateFramebufferHint = hint;
    }

    public static void setHint_Framebuffer$FramebufferClearHint(Framebuffer.FramebufferClearHint hint) {
        hint_Framebuffer$FramebufferClearHint = hint;
    }

    public static void setHint_Framebuffer$FramebufferSampleNum(int hint) {
        hint_Framebuffer$FramebufferSampleNum = hint;
    }

    public static void setHint_Texture2D$FilterModeMin(FilterMode hint) {
        hint_Texture2D$FilterModeMin = hint;
    }

    public static void setHint_Texture2D$FilterModeMag(FilterMode hint) {
        hint_Texture2D$FilterModeMag = hint;
    }

    public static void setHint_Texture2D$WrapModeS(WrapMode hint) {
        hint_Texture2D$WrapModeS = hint;
    }

    public static void setHint_Texture2D$WrapModeT(WrapMode hint) {
        hint_Texture2D$WrapModeT = hint;
    }

    public static void setHint_pixelPerUnit(float pixel) {
        hint_pixelPerUnit = pixel;
    }

    public static GlStateManager.BindTextureHint getHint_GlStateManager$BindTextureHint() {
        return hint_GlStateManager$BindTextureHint;
    }

    public static Framebuffer.CreateFramebufferHint getHint_Framebuffer$CreateFramebufferHint() {
        return hint_Framebuffer$CreateFramebufferHint;
    }

    public static Framebuffer.FramebufferClearHint getHint_Framebuffer$FramebufferClearHint() {
        return hint_Framebuffer$FramebufferClearHint;
    }

    public static int getHint_Framebuffer$FramebufferSampleNum() {
        return hint_Framebuffer$FramebufferSampleNum;
    }

    public static FilterMode getHint_Texture2D$FilterModeMin() {
        return hint_Texture2D$FilterModeMin;
    }

    public static FilterMode getHint_Texture2D$FilterModeMag() {
        return hint_Texture2D$FilterModeMag;
    }

    public static WrapMode getHint_Texture2D$WrapModeS() {
        return hint_Texture2D$WrapModeS;
    }

    public static WrapMode getHint_Texture2D$WrapModeT() {
        return hint_Texture2D$WrapModeT;
    }

    public static float getHint_pixelPerUnit() {
        return hint_pixelPerUnit;
    }

    public static FloatBuffer getModelViewMatrix() {
        if (!isActiveRenderInfoGettersInit) {
            RenderHints.initActiveRenderInfoGetters();
        }
        return modelViewMatrixGetter.invoke();
    }

    public static FloatBuffer getProjectionMatrix() {
        if (!isActiveRenderInfoGettersInit) {
            RenderHints.initActiveRenderInfoGetters();
        }
        return projectionMatrixGetter.invoke();
    }

    private static void initActiveRenderInfoGetters() {
        MethodHandle handle;
        isActiveRenderInfoGettersInit = true;
        Field modelViewMatrixField = null;
        try {
            modelViewMatrixField = ActiveRenderInfo.class.getDeclaredField("MODELVIEW");
        }
        catch (Exception ignored) {
            try {
                modelViewMatrixField = ActiveRenderInfo.class.getDeclaredField("field_178812_b");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (modelViewMatrixField == null) {
            throw new RuntimeException("RenderHints.initActiveRenderInfoGetters() failed to find the getter of MODELVIEW.");
        }
        Field projectionMatrixField = null;
        try {
            projectionMatrixField = ActiveRenderInfo.class.getDeclaredField("PROJECTION");
        }
        catch (Exception ignored) {
            try {
                projectionMatrixField = ActiveRenderInfo.class.getDeclaredField("field_178813_c");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (projectionMatrixField == null) {
            throw new RuntimeException("RenderHints.initActiveRenderInfoGetters() failed to find the getter of PROJECTION.");
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            modelViewMatrixField.setAccessible(true);
            handle = lookup.unreflectGetter(modelViewMatrixField);
            modelViewMatrixGetter = () -> {
                try {
                    return handle.invoke();
                }
                catch (Throwable e) {
                    return null;
                }
            };
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        try {
            projectionMatrixField.setAccessible(true);
            handle = lookup.unreflectGetter(projectionMatrixField);
            projectionMatrixGetter = () -> {
                try {
                    return handle.invoke();
                }
                catch (Throwable e) {
                    return null;
                }
            };
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static double getPartialTick() {
        Minecraft minecraft;
        if (!isPartialTickGetterInit) {
            RenderHints.initPartialTickGetter();
        }
        return (minecraft = Minecraft.func_71410_x()).func_147113_T() ? partialTickGetter.invoke() : (double)minecraft.func_184121_ak();
    }

    private static void initPartialTickGetter() {
        isPartialTickGetterInit = true;
        Field partialTickField = null;
        try {
            partialTickField = Minecraft.class.getDeclaredField("renderPartialTicksPaused");
        }
        catch (Exception ignored) {
            try {
                partialTickField = Minecraft.class.getDeclaredField("field_193996_ah");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partialTickField == null) {
            throw new RuntimeException("RenderHints.initPartialTickGetter() failed to find the getter of renderPartialTicksPaused.");
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            partialTickField.setAccessible(true);
            MethodHandle handle = lookup.unreflectGetter(partialTickField);
            partialTickGetter = () -> {
                try {
                    return handle.invoke(Minecraft.func_71410_x());
                }
                catch (Throwable e) {
                    return null;
                }
            };
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Vec3d getWorldOffset() {
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        if (camera == null) {
            camera = Minecraft.func_71410_x().field_71439_g;
        }
        double partialTicks = RenderHints.getPartialTick();
        double camX = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * partialTicks;
        double camY = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * partialTicks;
        double camZ = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * partialTicks;
        return new Vec3d(camX, camY, camZ);
    }

    public static Vec3d getCameraPos() {
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        if (camera == null) {
            camera = Minecraft.func_71410_x().field_71439_g;
        }
        double partialTicks = RenderHints.getPartialTick();
        double camX = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * partialTicks;
        double camY = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * partialTicks + (double)camera.func_70047_e();
        double camZ = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * partialTicks;
        return new Vec3d(camX, camY, camZ);
    }

    public static Vector2f getCameraRotationInDegree() {
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            return new Vector2f(0.0f, 0.0f);
        }
        return new Vector2f(viewEntity.field_70177_z, viewEntity.field_70125_A);
    }

    public static Vector2f getCameraRotationInRadian() {
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            return new Vector2f(0.0f, 0.0f);
        }
        return new Vector2f((float)Math.toRadians(viewEntity.field_70177_z), (float)Math.toRadians(viewEntity.field_70125_A));
    }

    static {
        isPartialTickGetterInit = false;
    }

    public static class GlStateManager {

        public static enum BindTextureHint {
            TEXTURE_2D,
            TEXTURE_2D_MULTISAMPLE;

        }
    }

    public static class Framebuffer {

        public static enum FramebufferClearHint {
            UNBIND_FBO,
            DONT_UNBIND_FBO;

        }

        public static enum CreateFramebufferHint {
            TEXTURE_2D,
            TEXTURE_2D_MULTISAMPLE;

        }
    }
}

