/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.serialization.json;

import java.util.ArrayList;
import java.util.List;

public final class RawJsonUtils {
    public static String extractValue(String json, String key) {
        String keyPattern;
        int keyIndex;
        if ((json = json.trim()).startsWith("{") && json.endsWith("}")) {
            json = json.substring(1, json.length() - 1);
        }
        if ((keyIndex = RawJsonUtils.findKeyAtTopLevel(json = json.trim(), keyPattern = "\"" + key + "\"")) == -1) {
            return "";
        }
        int startIndex = keyIndex + keyPattern.length();
        char c = json.charAt(startIndex);
        while (startIndex + 1 < json.length() && (c == ' ' || c == ':')) {
            c = json.charAt(++startIndex);
        }
        if (c == '{') {
            return RawJsonUtils.extractObjectValue(json, startIndex);
        }
        if (c == '[') {
            return RawJsonUtils.extractArrayValue(json, startIndex);
        }
        if (c == '\"') {
            return RawJsonUtils.extractStringValue(json, startIndex);
        }
        return RawJsonUtils.extractSimpleValue(json, startIndex);
    }

    public static List<String> extractKeys(String json) {
        if ((json = json.trim()).startsWith("{") && json.endsWith("}")) {
            json = json.substring(1, json.length() - 1).trim();
        }
        ArrayList<String> list = new ArrayList<String>();
        int level = 0;
        for (int startIndex = 0; startIndex < json.length(); ++startIndex) {
            int index;
            char c = json.charAt(startIndex);
            if (c == '{' || c == '[') {
                ++level;
            } else if (c == '}' || c == ']') {
                --level;
            }
            if (c != ':' || level != 0 || (index = startIndex - 1) < 0) continue;
            char c1 = json.charAt(index);
            while (index - 1 >= 0 && c1 == ' ') {
                c1 = json.charAt(--index);
            }
            int endIndex = index + 1;
            while (index >= 0 && c1 != ' ' && c1 != ',' && c1 != '{') {
                if (index - 1 == -1) {
                    --index;
                    continue;
                }
                c1 = json.charAt(--index);
            }
            String key = json.substring(index + 1, endIndex);
            list.add(key.substring(1, key.length() - 1));
        }
        return list;
    }

    public static List<String> splitArray(String json) {
        if ((json = json.trim()).startsWith("[") && json.endsWith("]")) {
            json = json.substring(1, json.length() - 1).trim();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int startIndex = 0; startIndex < json.length(); ++startIndex) {
            String element;
            char c = json.charAt(startIndex);
            while (startIndex + 1 < json.length() && (c == ' ' || c == ',')) {
                c = json.charAt(++startIndex);
            }
            if (c == '{') {
                element = RawJsonUtils.extractObjectValue(json, startIndex);
                startIndex += element.length();
            } else if (c == '[') {
                element = RawJsonUtils.extractArrayValue(json, startIndex);
                startIndex += element.length();
            } else if (c == '\"') {
                element = RawJsonUtils.extractStringValue(json, startIndex);
                startIndex += element.length() + 2;
            } else {
                element = RawJsonUtils.extractSimpleValue(json, startIndex);
                startIndex += element.length();
            }
            list.add(element);
        }
        return list;
    }

    private static int findKeyAtTopLevel(String json, String keyPattern) {
        int level = 0;
        for (int startIndex = 0; startIndex < json.length(); ++startIndex) {
            char c = json.charAt(startIndex);
            if (c == '{' || c == '[') {
                ++level;
            } else if (c == '}' || c == ']') {
                --level;
            }
            if (level != 0 || !json.startsWith(keyPattern, startIndex)) continue;
            return startIndex;
        }
        return -1;
    }

    private static String extractObjectValue(String json, int startIndex) {
        int i;
        int braceCount = 1;
        for (i = startIndex + 1; i < json.length() && braceCount > 0; ++i) {
            char c = json.charAt(i);
            if (c == '{') {
                ++braceCount;
                continue;
            }
            if (c != '}') continue;
            --braceCount;
        }
        return json.substring(startIndex, i);
    }

    private static String extractArrayValue(String json, int startIndex) {
        int i;
        int bracketCount = 1;
        for (i = startIndex + 1; i < json.length() && bracketCount > 0; ++i) {
            char c = json.charAt(i);
            if (c == '[') {
                ++bracketCount;
                continue;
            }
            if (c != ']') continue;
            --bracketCount;
        }
        return json.substring(startIndex, i);
    }

    private static String extractStringValue(String json, int startIndex) {
        int endIndex = json.indexOf(34, startIndex + 1);
        return endIndex != -1 ? json.substring(startIndex + 1, endIndex) : "";
    }

    private static String extractSimpleValue(String json, int startIndex) {
        int endIndex = startIndex;
        char c = json.charAt(endIndex);
        while (endIndex + 1 <= json.length() && c != ' ' && c != ',' && c != '}') {
            if (endIndex + 1 == json.length()) {
                ++endIndex;
                continue;
            }
            c = json.charAt(++endIndex);
        }
        return json.substring(startIndex, endIndex).trim();
    }
}

