/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.control;

import com.tttsaurus.ingameinfo.common.core.gui.control.Sized;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.impl.gui.render.op.ProgressBarOp;

@RegisterElement
public class ProgressBar
extends Sized {
    @StyleProperty
    public int fillerColor;
    @StyleProperty
    public int backgroundColor;
    @StyleProperty
    public int outlineColor;
    @StyleProperty(setterCallbackPre="percentageValidation")
    public float percentage = 0.0f;

    public void percentageValidation(float value, CallbackInfo callbackInfo) {
        if (value < 0.0f) {
            this.percentage = 0.0f;
            callbackInfo.cancel = true;
        } else if (value > 1.0f) {
            this.percentage = 1.0f;
            callbackInfo.cancel = true;
        }
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        super.onRenderUpdate(queue, focused);
        if (this.rect.width == 0.0f || this.rect.height == 0.0f) {
            return;
        }
        queue.enqueue(new ProgressBarOp(this.rect, this.percentage, this.backgroundColor, this.fillerColor, this.outlineColor));
    }
}

