/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.control;

import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StylePropertyCallback;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.core.render.text.FormattedText;
import com.tttsaurus.ingameinfo.common.impl.gui.render.op.TextOp;

@RegisterElement
public class Text
extends Element {
    private FormattedText formattedText = RenderUtils.bakeFormattedText("");
    @StyleProperty(setterCallbackPost="setTextCallback", setterCallbackPre="textValidation")
    public String text = "";
    @StyleProperty(setterCallbackPost="requestReCalc", setterCallbackPre="scaleValidation")
    public float scale = 0.0f;
    @StyleProperty
    public int color;
    @StyleProperty(setterCallbackPost="setShadowCallback")
    public boolean shadow;
    private boolean isShadowInit = false;

    @StylePropertyCallback
    public void setTextCallback() {
        this.formattedText = RenderUtils.bakeFormattedText(this.text);
        this.requestReCalc();
    }

    @StylePropertyCallback
    public void textValidation(String value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void scaleValidation(float value, CallbackInfo callbackInfo) {
        if (value < 0.0f) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void setShadowCallback() {
        if (!this.isShadowInit) {
            this.isShadowInit = true;
        }
    }

    @Override
    public void calcWidthHeight() {
        this.rect.width = this.formattedText.width * this.scale;
        this.rect.height = this.formattedText.height * this.scale;
    }

    @Override
    public void applyLogicTheme(ThemeConfig themeConfig) {
        super.applyLogicTheme(themeConfig);
        if (this.scale == 0.0f) {
            this.setStyleProperty("scale", Float.valueOf(themeConfig.text.scale));
        }
        if (!this.isShadowInit) {
            this.isShadowInit = true;
            this.setStyleProperty("shadow", themeConfig.text.shadow);
        }
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        super.onRenderUpdate(queue, focused);
        queue.enqueue(new TextOp(this.formattedText, this.rect.x, this.rect.y, this.scale, this.color, this.shadow));
    }
}

