/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.control;

import com.tttsaurus.ingameinfo.common.core.gui.control.Sized;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StylePropertyCallback;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.core.render.texture.Texture2D;
import com.tttsaurus.ingameinfo.common.impl.gui.render.op.UrlImageOp;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;

@RegisterElement
public class UrlImage
extends Sized {
    private BufferedImage asyncImage = null;
    private Texture2D texture = null;
    @StyleProperty
    public boolean rounded;
    @StyleProperty(setterCallbackPost="setUrlCallback", setterCallbackPre="urlValidation")
    public String url;

    @StylePropertyCallback
    public void urlValidation(String value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void setUrlCallback() {
        if (this.url.isEmpty()) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            try {
                URL imageUrl = new URL(this.url);
                InputStream in = imageUrl.openStream();
                return ImageIO.read(in);
            }
            catch (Exception e) {
                return null;
            }
        }).thenAccept(image -> {
            if (image != null) {
                this.asyncImage = image;
            }
        });
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        super.onRenderUpdate(queue, focused);
        if (this.asyncImage != null) {
            if (this.texture != null) {
                this.texture.dispose();
            }
            this.texture = RenderUtils.createTexture2D(this.asyncImage);
            this.asyncImage = null;
        }
        queue.enqueue(new UrlImageOp(this.rect, this.texture, this.rounded));
    }
}

