/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.render.op;

import com.tttsaurus.ingameinfo.common.core.gui.GuiResources;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderContext;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import java.awt.Color;

public class ButtonOp
implements IRenderOp {
    public Rect rect;
    public int buttonColor;
    public String text;
    public float x;
    public float y;
    public float scale;
    public int textColor;
    public boolean shadow;
    public boolean hover;
    public boolean hold;
    private static final float ORIGINAL_R;
    private static final float ORIGINAL_G;
    private static final float ORIGINAL_B;

    public ButtonOp(Rect rect, int buttonColor, String text, float x, float y, float scale, int textColor, boolean shadow, boolean hover, boolean hold) {
        this.rect = rect;
        this.buttonColor = buttonColor;
        this.text = text;
        this.x = x;
        this.y = y;
        this.scale = scale;
        this.textColor = textColor;
        this.shadow = shadow;
        this.hover = hover;
        this.hold = hold;
    }

    @Override
    public void execute(RenderContext context) {
        float a = (float)(this.buttonColor >> 24 & 0xFF) / 255.0f;
        float r = (float)(this.buttonColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.buttonColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.buttonColor & 0xFF) / 255.0f;
        float _r = r / ORIGINAL_R;
        float _g = g / ORIGINAL_G;
        float _b = b / ORIGINAL_B;
        int tempColor = new Color(Math.min(_r, 1.0f), Math.min(_g, 1.0f), Math.min(_b, 1.0f), a).getRGB();
        RenderUtils.renderImagePrefab(this.rect.x, this.rect.y, this.rect.width, this.rect.height, GuiResources.get("vanilla_button"), tempColor);
        RenderUtils.renderRectBrightnessOverlay(this.rect.x, this.rect.y, this.rect.width, this.rect.height, _r > 1.0f ? r - ORIGINAL_R : 0.0f, _g > 1.0f ? g - ORIGINAL_G : 0.0f, _b > 1.0f ? b - ORIGINAL_B : 0.0f);
        if (this.hover && !this.hold) {
            RenderUtils.renderRectOutline(this.rect.x, this.rect.y, this.rect.width - 1.0f, this.rect.height - 1.0f, 1.0f, Color.BLACK.getRGB());
        }
        RenderUtils.renderText(this.text, this.x, this.y, this.scale, this.textColor, this.shadow);
    }

    static {
        String originalColorString = "aaaaaa";
        int originalColor = 0xFF000000 | Integer.parseInt(originalColorString, 16);
        ORIGINAL_R = (float)(originalColor >> 16 & 0xFF) / 255.0f;
        ORIGINAL_G = (float)(originalColor >> 8 & 0xFF) / 255.0f;
        ORIGINAL_B = (float)(originalColor & 0xFF) / 255.0f;
    }
}

