/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.render.op;

import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderContext;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import com.tttsaurus.ingameinfo.common.core.render.RenderMask;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.core.render.texture.ImagePrefab;

public class ImageOp
implements IRenderOp {
    public Rect rect;
    public ImagePrefab image;
    public boolean rounded;

    public ImageOp(Rect rect, ImagePrefab image, boolean rounded) {
        this.rect = rect;
        this.image = image;
        this.rounded = rounded;
    }

    @Override
    public void execute(RenderContext context) {
        if (this.image == null) {
            return;
        }
        if (this.rounded) {
            RenderMask mask = new RenderMask(RenderMask.MaskShape.ROUNDED_RECT);
            mask.setRoundedRectMask(this.rect.x, this.rect.y, this.rect.width, this.rect.height, context.theme.image.cornerRadius);
            mask.startMasking();
        }
        RenderUtils.renderImagePrefab(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.image);
        if (this.rounded) {
            RenderMask.endMasking();
        }
    }
}

