/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.render.op;

import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderContext;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import com.tttsaurus.ingameinfo.common.core.render.RenderMask;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.core.render.texture.Texture2D;

public class UrlImageOp
implements IRenderOp {
    public Rect rect;
    public Texture2D texture;
    public boolean rounded;

    public UrlImageOp(Rect rect, Texture2D texture, boolean rounded) {
        this.rect = rect;
        this.texture = texture;
        this.rounded = rounded;
    }

    @Override
    public void execute(RenderContext context) {
        if (this.texture == null) {
            return;
        }
        if (!this.texture.isGlRegistered()) {
            return;
        }
        if (this.rounded) {
            RenderMask mask = new RenderMask(RenderMask.MaskShape.ROUNDED_RECT);
            mask.setRoundedRectMask(this.rect.x, this.rect.y, this.rect.width, this.rect.height, context.theme.urlImage.cornerRadius);
            mask.startMasking();
        }
        RenderUtils.renderTexture2D(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.texture.getGlTextureID());
        if (this.rounded) {
            RenderMask.endMasking();
        }
    }
}

