/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.serialization;

import com.tttsaurus.ingameinfo.common.core.reflection.TypeUtils;
import com.tttsaurus.ingameinfo.common.core.serialization.IDeserializer;
import java.awt.Color;

public class BuiltinTypesDeserializer<T>
implements IDeserializer<T> {
    private final Class<T> clazz;

    public BuiltinTypesDeserializer(Class<T> clazz) {
        this.clazz = clazz;
    }

    private static int parseColor0(String hex) {
        if (hex.length() == 6) {
            return 0xFF000000 | Integer.parseInt(hex, 16);
        }
        if (hex.length() == 8) {
            return (int)Long.parseLong(hex, 16);
        }
        return 0;
    }

    private static int parseColor1(String rgb) {
        String[] items = rgb.split(",");
        if (items.length != 3) {
            return 0;
        }
        int r = Integer.parseInt(items[0].trim());
        int g = Integer.parseInt(items[1].trim());
        int b = Integer.parseInt(items[2].trim());
        return new Color(r, g, b, 255).getRGB();
    }

    private static int parseColor2(String argb) {
        String[] items = argb.split(",");
        if (items.length != 4) {
            return 0;
        }
        float a = Float.parseFloat(items[0].trim());
        int r = Integer.parseInt(items[1].trim());
        int g = Integer.parseInt(items[2].trim());
        int b = Integer.parseInt(items[3].trim());
        return new Color(r, g, b, (int)(a * 255.0f)).getRGB();
    }

    private static int parseColor3(String rgba) {
        String[] items = rgba.split(",");
        if (items.length != 4) {
            return 0;
        }
        int r = Integer.parseInt(items[0].trim());
        int g = Integer.parseInt(items[1].trim());
        int b = Integer.parseInt(items[2].trim());
        float a = Float.parseFloat(items[3].trim());
        return new Color(r, g, b, (int)(a * 255.0f)).getRGB();
    }

    @Override
    public T deserialize(String raw) {
        if (TypeUtils.isIntOrWrappedInt(this.clazz)) {
            try {
                if (raw.startsWith("#")) {
                    return (T)Integer.valueOf(BuiltinTypesDeserializer.parseColor0(raw.substring(1)));
                }
                if (raw.startsWith("rgb(")) {
                    return (T)Integer.valueOf(BuiltinTypesDeserializer.parseColor1(raw.substring(4, raw.length() - 1)));
                }
                if (raw.startsWith("argb(")) {
                    return (T)Integer.valueOf(BuiltinTypesDeserializer.parseColor2(raw.substring(5, raw.length() - 1)));
                }
                if (raw.startsWith("rgba(")) {
                    return (T)Integer.valueOf(BuiltinTypesDeserializer.parseColor3(raw.substring(5, raw.length() - 1)));
                }
                if (raw.startsWith("0x")) {
                    return (T)Integer.valueOf(Integer.parseInt(raw.substring(2), 16));
                }
                return (T)Integer.valueOf(Integer.parseInt(raw));
            }
            catch (Exception ignored) {
                return (T)Integer.valueOf(0);
            }
        }
        if (TypeUtils.isLongOrWrappedLong(this.clazz)) {
            try {
                return (T)Long.valueOf(Long.parseLong(raw));
            }
            catch (Exception ignored) {
                return (T)Long.valueOf(0L);
            }
        }
        if (TypeUtils.isShortOrWrappedShort(this.clazz)) {
            try {
                return (T)Short.valueOf(Short.parseShort(raw));
            }
            catch (Exception ignored) {
                return (T)Integer.valueOf(0);
            }
        }
        if (TypeUtils.isByteOrWrappedByte(this.clazz)) {
            try {
                return (T)Byte.valueOf(Byte.parseByte(raw));
            }
            catch (Exception ignored) {
                return (T)Integer.valueOf(0);
            }
        }
        if (TypeUtils.isDoubleOrWrappedDouble(this.clazz)) {
            try {
                return (T)Double.valueOf(Double.parseDouble(raw));
            }
            catch (Exception ignored) {
                return (T)Double.valueOf(0.0);
            }
        }
        if (TypeUtils.isFloatOrWrappedFloat(this.clazz)) {
            try {
                return (T)Float.valueOf(Float.parseFloat(raw));
            }
            catch (Exception ignored) {
                return (T)Float.valueOf(0.0f);
            }
        }
        if (TypeUtils.isCharacterOrWrappedCharacter(this.clazz)) {
            try {
                return (T)raw;
            }
            catch (Exception ignored) {
                return (T)Character.valueOf(' ');
            }
        }
        if (TypeUtils.isBooleanOrWrappedBoolean(this.clazz)) {
            try {
                return (T)Boolean.valueOf(Boolean.parseBoolean(raw));
            }
            catch (Exception ignored) {
                return (T)Boolean.valueOf(false);
            }
        }
        if (this.clazz.equals(String.class)) {
            try {
                return (T)raw;
            }
            catch (Exception ignored) {
                return (T)"";
            }
        }
        return null;
    }
}

