/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.serialization;

import com.tttsaurus.ingameinfo.common.core.InternalMethods;
import com.tttsaurus.ingameinfo.common.core.commonutils.GhostableItem;
import com.tttsaurus.ingameinfo.common.core.gui.Element;
import com.tttsaurus.ingameinfo.common.core.gui.ElementProperty;
import com.tttsaurus.ingameinfo.common.core.gui.GuiLayout;
import com.tttsaurus.ingameinfo.common.core.gui.IgiGuiContainer;
import com.tttsaurus.ingameinfo.common.core.gui.layout.ElementGroup;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Slot;
import com.tttsaurus.ingameinfo.common.core.gui.registry.ElementRegistry;
import com.tttsaurus.ingameinfo.common.core.serialization.IDeserializer;
import com.tttsaurus.ingameinfo.common.core.serialization.ixml.RawIxmlUtils;
import com.tttsaurus.ingameinfo.common.core.serialization.json.RawJsonUtils;
import com.tttsaurus.ingameinfo.common.impl.serialization.ElementPropertiesDeserializer;
import com.tttsaurus.ingameinfo.common.impl.serialization.ItemDeserializer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Tuple;

public class GuiLayoutDeserializer
implements IDeserializer<GuiLayout> {
    private final IgiGuiContainer container;

    public GuiLayoutDeserializer(@Nullable IgiGuiContainer container) {
        this.container = container;
    }

    @Override
    public GuiLayout deserialize(String raw) {
        GuiLayout guiLayout = InternalMethods.instance.GuiLayout$constructor.invoke();
        if (this.container != null) {
            InternalMethods.instance.GuiLayout$igiGuiContainer$setter.invoke(guiLayout, this.container);
        }
        if (raw.isEmpty()) {
            return guiLayout;
        }
        List<Tuple<String, String>> nodes = RawIxmlUtils.extractNodes(raw);
        for (Tuple<String, String> pair : nodes) {
            Element element;
            if (((String)pair.func_76341_a()).equals("Def")) {
                List<Tuple<String, String>> defs = RawIxmlUtils.splitParams((String)pair.func_76340_b());
                for (Tuple<String, String> def : defs) {
                    GhostableItem item;
                    ItemDeserializer itemDeserializer;
                    String field = (String)def.func_76341_a();
                    String value = (String)def.func_76340_b();
                    if (field.equals("debug")) {
                        guiLayout.setDebug(Boolean.parseBoolean(value));
                        continue;
                    }
                    if (field.equals("exitKey")) {
                        try {
                            guiLayout.setExitKeyForFocusedGui(Integer.parseInt(value));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (field.equals("focused")) {
                        guiLayout.setFocused(Boolean.parseBoolean(value));
                        continue;
                    }
                    if (field.equals("hasFocusBg")) {
                        guiLayout.setHasFocusBackground(Boolean.parseBoolean(value));
                        continue;
                    }
                    if (field.equals("bgColor")) {
                        try {
                            guiLayout.setBackgroundColor(Integer.parseInt(value));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (field.equals("useHeldItemWhitelist")) {
                        guiLayout.setHeldItemWhitelist(Boolean.parseBoolean(value));
                        continue;
                    }
                    if (field.equals("useHeldItemBlacklist")) {
                        guiLayout.setHeldItemBlacklist(Boolean.parseBoolean(value));
                        continue;
                    }
                    if (field.equals("heldItemWhitelist")) {
                        itemDeserializer = new ItemDeserializer();
                        for (String rawItem : RawJsonUtils.splitArray(value)) {
                            item = itemDeserializer.deserialize(rawItem);
                            if (item == null) continue;
                            guiLayout.addHeldItemWhitelist(item);
                        }
                        continue;
                    }
                    if (field.equals("heldItemBlacklist")) {
                        itemDeserializer = new ItemDeserializer();
                        for (String rawItem : RawJsonUtils.splitArray(value)) {
                            item = itemDeserializer.deserialize(rawItem);
                            if (item == null) continue;
                            guiLayout.addHeldItemBlacklist(item);
                        }
                        continue;
                    }
                    if (!field.equals("theme")) continue;
                    guiLayout.setThemeName(value);
                }
            } else if (((String)pair.func_76341_a()).equals("/Group")) {
                guiLayout.endGroup();
                continue;
            }
            if ((element = ElementRegistry.newElement((String)pair.func_76341_a())) == null) continue;
            Object properties = new ElementPropertiesDeserializer(element.getClass()).deserialize((String)pair.func_76340_b());
            if (element.getClass().equals(Slot.class)) {
                guiLayout.addElement(element, (List<ElementProperty>)properties);
                continue;
            }
            if (ElementGroup.class.isAssignableFrom(element.getClass())) {
                guiLayout.startGroup((ElementGroup)element, (List<ElementProperty>)properties);
                continue;
            }
            guiLayout.addElement(element, (List<ElementProperty>)properties);
        }
        return guiLayout;
    }
}

