/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.deprecated.mesh2d;

import com.tttsaurus.ingameinfo.deprecated.Mesh;
import com.tttsaurus.ingameinfo.deprecated.ScaledRes2NdcUtils;
import com.tttsaurus.ingameinfo.deprecated.VertexIndexUtils;

public class LineMesh
extends Mesh {
    private boolean formLoop = false;
    private float lineWidth;
    private final int maxLineNum;
    private int lineNum;
    private int vertexNum;
    private final float[] vertices;

    public int getLineNum() {
        return this.lineNum;
    }

    public LineMesh(int lineNum, float lineWidth) {
        super(new float[(lineNum + 1) * 2 * 8], new int[lineNum * 6 + 9]);
        this.maxLineNum = lineNum;
        this.lineNum = lineNum;
        this.vertexNum = lineNum + 1;
        this.vertices = new float[this.vertexNum * 2];
        this.lineWidth = lineWidth;
        this.setEboIndexOffset(9);
    }

    public LineMesh setFormLoop(boolean flag) {
        this.formLoop = flag;
        this.setEboIndexOffset((this.maxLineNum - this.lineNum) * 6 + (this.formLoop ? 0 : 9));
        return this;
    }

    public LineMesh setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public LineMesh setLineNum(int lineNum) {
        if (lineNum < 0) {
            throw new IllegalStateException("Line number " + lineNum + " is invalid. You need at least 0 lines in a line mesh");
        }
        if (lineNum > this.maxLineNum) {
            throw new IllegalStateException("Line number " + lineNum + " is invalid. You can't exceed the allocated limit " + this.maxLineNum);
        }
        this.lineNum = lineNum;
        this.vertexNum = lineNum + 1;
        this.setEboIndexOffset((this.maxLineNum - lineNum) * 6 + (this.formLoop ? 0 : 9));
        return this;
    }

    public LineMesh setVertex(int index, float x, float y) {
        if (index < 0 || index > this.vertexNum - 1) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for vertex number " + this.vertexNum);
        }
        this.vertices[index * 2] = x;
        this.vertices[index * 2 + 1] = y;
        return this;
    }

    public void update() {
        float y2;
        float x2;
        float y1;
        float x1;
        float[] newVertices = new float[this.getVerticesLength()];
        float[] lineNormalX = new float[this.vertexNum];
        float[] lineNormalY = new float[this.vertexNum];
        for (int i = 0; i < this.vertexNum - 1; ++i) {
            float dxN;
            float y22 = this.vertices[(i + 1) * 2 + 1];
            float y12 = this.vertices[i * 2 + 1];
            float x22 = this.vertices[(i + 1) * 2];
            float x12 = this.vertices[i * 2];
            float dyN = x22 - x12;
            float len = (float)Math.sqrt((dxN = -(y22 - y12)) * dxN + dyN * dyN);
            lineNormalX[i] = dxN / (len == 0.0f ? 1.0E-6f : len);
            lineNormalY[i] = dyN / (len == 0.0f ? 1.0E-6f : len);
        }
        lineNormalX[this.vertexNum - 1] = lineNormalX[this.vertexNum - 2];
        lineNormalY[this.vertexNum - 1] = lineNormalY[this.vertexNum - 2];
        float[] vertexNormalX = new float[this.vertexNum * 2];
        float[] vertexNormalY = new float[this.vertexNum * 2];
        for (int i = 0; i < this.vertexNum; ++i) {
            float normalY2;
            float normalX2;
            float normalY1;
            float normalX1;
            if (i == 0 || i == this.vertexNum - 1) {
                normalX1 = lineNormalX[i] * this.lineWidth / 2.0f;
                normalY1 = lineNormalY[i] * this.lineWidth / 2.0f;
                normalX2 = -normalX1;
                normalY2 = -normalY1;
            } else {
                x1 = this.vertices[(i - 1) * 2];
                y1 = this.vertices[(i - 1) * 2 + 1];
                x2 = this.vertices[i * 2];
                y2 = this.vertices[i * 2 + 1];
                float dx1 = lineNormalX[i - 1];
                float dx2 = lineNormalX[i];
                float dy1 = lineNormalY[i - 1];
                float dy2 = lineNormalY[i];
                float dx = (dx1 + dx2) / 2.0f;
                float dy = (dy1 + dy2) / 2.0f;
                float prevNormalX = vertexNormalX[(i - 1) * 2];
                float prevNormalY = vertexNormalY[(i - 1) * 2];
                float k = (y2 - y1) / (x2 - x1 == 0.0f ? 1.0E-6f : x2 - x1);
                float c = y1 + prevNormalY - (x1 + prevNormalX) * k;
                float normalK = dy / (dx == 0.0f ? 1.0E-6f : dx);
                float normalC = y2 - x2 * normalK;
                float intersectX = (c - normalC) / (normalK - k == 0.0f ? 1.0E-6f : normalK - k);
                float intersectY = normalK * intersectX + normalC;
                normalX1 = intersectX - x2;
                normalY1 = intersectY - y2;
                prevNormalX = vertexNormalX[(i - 1) * 2 + 1];
                prevNormalY = vertexNormalY[(i - 1) * 2 + 1];
                c = y1 + prevNormalY - (x1 + prevNormalX) * k;
                intersectX = (c - normalC) / (normalK - k == 0.0f ? 1.0E-6f : normalK - k);
                intersectY = normalK * intersectX + normalC;
                normalX2 = intersectX - x2;
                normalY2 = intersectY - y2;
            }
            vertexNormalX[i * 2] = normalX1;
            vertexNormalY[i * 2] = normalY1;
            vertexNormalX[i * 2 + 1] = normalX2;
            vertexNormalY[i * 2 + 1] = normalY2;
            float x = this.vertices[i * 2];
            float y = this.vertices[i * 2 + 1];
            newVertices[i * 2 * 8] = ScaledRes2NdcUtils.toNdcX(x + normalX1);
            newVertices[i * 2 * 8 + 1] = ScaledRes2NdcUtils.toNdcY(y + normalY1);
            newVertices[i * 2 * 8 + 2] = 0.0f;
            newVertices[i * 2 * 8 + 3] = 0.0f;
            newVertices[i * 2 * 8 + 4] = 0.0f;
            newVertices[i * 2 * 8 + 5] = 0.0f;
            newVertices[i * 2 * 8 + 6] = 0.0f;
            newVertices[i * 2 * 8 + 7] = 1.0f;
            newVertices[(i * 2 + 1) * 8] = ScaledRes2NdcUtils.toNdcX(x + normalX2);
            newVertices[(i * 2 + 1) * 8 + 1] = ScaledRes2NdcUtils.toNdcY(y + normalY2);
            newVertices[(i * 2 + 1) * 8 + 2] = 0.0f;
            newVertices[(i * 2 + 1) * 8 + 3] = 0.0f;
            newVertices[(i * 2 + 1) * 8 + 4] = 0.0f;
            newVertices[(i * 2 + 1) * 8 + 5] = 0.0f;
            newVertices[(i * 2 + 1) * 8 + 6] = 0.0f;
            newVertices[(i * 2 + 1) * 8 + 7] = 1.0f;
        }
        int[] newIndices = new int[this.getIndicesLength()];
        for (int i = 0; i < this.lineNum; ++i) {
            int offset = this.maxLineNum - this.lineNum;
            float x13 = newVertices[i * 2 * 8];
            float y13 = newVertices[i * 2 * 8 + 1];
            float x23 = newVertices[(i * 2 + 1) * 8];
            float y23 = newVertices[(i * 2 + 1) * 8 + 1];
            float x3 = newVertices[(i + 1) * 2 * 8];
            float y3 = newVertices[(i + 1) * 2 * 8 + 1];
            float x4 = newVertices[((i + 1) * 2 + 1) * 8];
            float y4 = newVertices[((i + 1) * 2 + 1) * 8 + 1];
            if (VertexIndexUtils.isCcw(x13, y13, x3, y3, x23, y23)) {
                newIndices[9 + (i + offset) * 6] = i * 2;
                newIndices[9 + (i + offset) * 6 + 1] = i * 2 + 2;
                newIndices[9 + (i + offset) * 6 + 2] = i * 2 + 1;
            } else {
                newIndices[9 + (i + offset) * 6] = i * 2;
                newIndices[9 + (i + offset) * 6 + 1] = i * 2 + 1;
                newIndices[9 + (i + offset) * 6 + 2] = i * 2 + 2;
            }
            if (VertexIndexUtils.isCcw(x3, y3, x4, y4, x23, y23)) {
                newIndices[9 + (i + offset) * 6 + 3] = i * 2 + 2;
                newIndices[9 + (i + offset) * 6 + 4] = i * 2 + 3;
                newIndices[9 + (i + offset) * 6 + 5] = i * 2 + 1;
                continue;
            }
            newIndices[9 + (i + offset) * 6 + 3] = i * 2 + 2;
            newIndices[9 + (i + offset) * 6 + 4] = i * 2 + 1;
            newIndices[9 + (i + offset) * 6 + 5] = i * 2 + 3;
        }
        if (this.formLoop) {
            int i1 = 0;
            int i2 = 1;
            int i3 = this.vertexNum * 2 - 2;
            int i4 = this.vertexNum * 2 - 1;
            x1 = newVertices[i1 * 8];
            y1 = newVertices[i1 * 8 + 1];
            x2 = newVertices[i2 * 8];
            y2 = newVertices[i2 * 8 + 1];
            float x3 = newVertices[i3 * 8];
            float y3 = newVertices[i3 * 8 + 1];
            float x4 = newVertices[i4 * 8];
            float y4 = newVertices[i4 * 8 + 1];
            if (VertexIndexUtils.isCcw(x1, y1, x2, y2, x3, y3)) {
                newIndices[0] = i1;
                newIndices[1] = i2;
                newIndices[2] = i3;
            } else {
                newIndices[0] = i1;
                newIndices[1] = i3;
                newIndices[2] = i2;
            }
            if (VertexIndexUtils.isCcw(x3, y3, x2, y2, x4, y4)) {
                newIndices[3] = i3;
                newIndices[4] = i2;
                newIndices[5] = i4;
            } else {
                newIndices[3] = i3;
                newIndices[4] = i4;
                newIndices[5] = i2;
            }
            if (VertexIndexUtils.isCcw(x1, y1, x4, y4, x3, y3)) {
                newIndices[6] = i1;
                newIndices[7] = i4;
                newIndices[8] = i3;
            } else {
                newIndices[6] = i1;
                newIndices[7] = i3;
                newIndices[8] = i4;
            }
        }
        this.updateVerticesByBufferSubData(newVertices);
        this.updateIndicesByBufferSubData(newIndices);
    }
}

