/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.objectmapping;

import com.tttsaurus.ingameinfo.shadow.io.leangen.geantyref.GenericTypeReflector;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.objectmapping.FieldDiscoverer;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.serialize.SerializationException;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.util.CheckedFunction;
import com.tttsaurus.ingameinfo.shadow.org.spongepowered.configurate.util.Types;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

class ObjectFieldDiscoverer
implements FieldDiscoverer<Map<Field, Object>> {
    static final ObjectFieldDiscoverer EMPTY_CONSTRUCTOR_INSTANCE = new ObjectFieldDiscoverer(type -> {
        try {
            Constructor<?> constructor = GenericTypeReflector.erase(type.getType()).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return () -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }, "Objects must have a zero-argument constructor to be able to create new instances", false);
    private final CheckedFunction<AnnotatedType, @Nullable Supplier<Object>, SerializationException> instanceFactory;
    private final String instanceUnavailableErrorMessage;
    private final boolean requiresInstanceCreation;

    ObjectFieldDiscoverer(CheckedFunction<AnnotatedType, @Nullable Supplier<Object>, SerializationException> instanceFactory, @Nullable String instanceUnavailableErrorMessage, boolean requiresInstanceCreation) {
        this.instanceFactory = instanceFactory;
        this.instanceUnavailableErrorMessage = instanceUnavailableErrorMessage == null ? "Unable to create instances for this type!" : instanceUnavailableErrorMessage;
        this.requiresInstanceCreation = requiresInstanceCreation;
    }

    @Override
    public <V> @Nullable FieldDiscoverer.InstanceFactory<Map<Field, Object>> discover(final AnnotatedType target, FieldDiscoverer.FieldCollector<Map<Field, Object>, V> collector) throws SerializationException {
        Class<?> clazz = GenericTypeReflector.erase(target.getType());
        if (clazz.isInterface()) {
            throw new SerializationException(target.getType(), "ObjectMapper can only work with concrete types");
        }
        final @Nullable Supplier<Object> maker = this.instanceFactory.apply(target);
        if (maker == null && this.requiresInstanceCreation) {
            return null;
        }
        AnnotatedType collectType = target;
        Class<?> collectClass = clazz;
        while (true) {
            this.collectFields(collectType, collector);
            collectClass = collectClass.getSuperclass();
            if (collectClass.equals(Object.class)) break;
            collectType = GenericTypeReflector.getExactSuperType(collectType, collectClass);
        }
        return new FieldDiscoverer.MutableInstanceFactory<Map<Field, Object>>(){

            @Override
            public Map<Field, Object> begin() {
                return new HashMap<Field, Object>();
            }

            @Override
            public void complete(Object instance, Map<Field, Object> intermediate) throws SerializationException {
                for (Map.Entry<Field, Object> entry : intermediate.entrySet()) {
                    try {
                        if (entry.getValue() instanceof ImplicitProvider) {
                            @Nullable Object implicit = ((ImplicitProvider)entry.getValue()).provider.get();
                            if (implicit == null || entry.getKey().get(instance) != null) continue;
                            entry.getKey().set(instance, implicit);
                            continue;
                        }
                        entry.getKey().set(instance, entry.getValue());
                    }
                    catch (IllegalAccessException e) {
                        throw new SerializationException(target.getType(), (Throwable)e);
                    }
                }
            }

            @Override
            public Object complete(Map<Field, Object> intermediate) throws SerializationException {
                Object instance;
                Object v0 = instance = maker == null ? null : maker.get();
                if (instance == null) {
                    throw new SerializationException(target.getType(), ObjectFieldDiscoverer.this.instanceUnavailableErrorMessage);
                }
                this.complete((Object)instance, intermediate);
                return instance;
            }

            @Override
            public boolean canCreateInstances() {
                return maker != null;
            }
        };
    }

    private void collectFields(AnnotatedType clazz, FieldDiscoverer.FieldCollector<Map<Field, Object>, ?> fieldMaker) {
        for (Field field : GenericTypeReflector.erase(clazz.getType()).getDeclaredFields()) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            field.setAccessible(true);
            AnnotatedType fieldType = GenericTypeReflector.getFieldType(field, clazz);
            fieldMaker.accept(field.getName(), fieldType, Types.combinedAnnotations(fieldType, field), (intermediate, val, implicitProvider) -> {
                if (val != null) {
                    intermediate.put(field, val);
                } else {
                    intermediate.put(field, new ImplicitProvider(implicitProvider));
                }
            }, field::get);
        }
    }

    static class ImplicitProvider {
        final Supplier<Object> provider;

        ImplicitProvider(Supplier<Object> provider) {
            this.provider = provider;
        }
    }
}

